/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.border;

import java.util.HashMap;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.draw2d.AbstractBorder;
import org.eclipse.draw2d.geometry.Insets;

public abstract class BaseBorder
extends AbstractBorder {
    public String bottomWidth;
    public String bottomStyle;
    public String bottomColor;
    public String topWidth;
    public String topStyle;
    public String topColor;
    public String leftWidth;
    public String leftStyle;
    public String leftColor;
    public String rightWidth;
    public String rightStyle;
    public String rightColor;
    protected int i_bottom_style;
    protected int i_bottom_width = 1;
    protected int i_top_style;
    protected int i_top_width = 1;
    protected int i_left_style;
    protected int i_left_width = 1;
    protected int i_right_style;
    protected int i_right_width = 1;
    private static final HashMap styleMap = new HashMap();
    private static final HashMap widthMap = new HashMap();
    private static final double EPS = 1.0E-10;
    protected int leftGap;
    protected int rightGap;
    protected int bottomGap;
    protected int topGap;

    public abstract Insets getTrueBorderInsets();

    public abstract Insets getBorderInsets();

    public abstract void setPaddingInsets(Insets var1);

    protected int getBorderStyle(Object obj) {
        Integer retValue = (Integer)styleMap.get(obj);
        if (retValue == null) {
            return 2;
        }
        return retValue;
    }

    protected int getBorderWidth(Object obj) {
        String[] rt;
        if (obj instanceof String && (rt = DEUtil.splitString((String)((String)obj)))[0] != null && DEUtil.isValidNumber((String)rt[0])) {
            double w = DEUtil.convertoToPixel((Object)new DimensionValue(Double.parseDouble(rt[0]), rt[1]));
            if (w <= 1.0E-10) {
                return 0;
            }
            return Math.max(1, (int)w);
        }
        Integer retValue = (Integer)widthMap.get(obj);
        if (retValue == null) {
            return 1;
        }
        return retValue;
    }

    public int getLeftBorderStyle() {
        return this.getBorderStyle(this.leftStyle);
    }

    public int getRightBorderStyle() {
        return this.getBorderStyle(this.rightStyle);
    }

    public int getTopBorderStyle() {
        return this.getBorderStyle(this.topStyle);
    }

    public int getBottomBorderStyle() {
        return this.getBorderStyle(this.bottomStyle);
    }

    public int getLeftBorderWidth() {
        return this.getBorderWidth(this.leftWidth);
    }

    public int getRightBorderWidth() {
        return this.getBorderWidth(this.rightWidth);
    }

    public int getTopBorderWidth() {
        return this.getBorderWidth(this.topWidth);
    }

    public int getBottomBorderWidth() {
        return this.getBorderWidth(this.bottomWidth);
    }

    public int getLeftBorderColor() {
        return ColorUtil.parseColor((String)this.leftColor);
    }

    public int getRightBorderColor() {
        return ColorUtil.parseColor((String)this.rightColor);
    }

    public int getTopBorderColor() {
        return ColorUtil.parseColor((String)this.topColor);
    }

    public int getBottomBorderColor() {
        return ColorUtil.parseColor((String)this.bottomColor);
    }

    static {
        styleMap.put("solid", new Integer(1));
        styleMap.put("dotted", new Integer(3));
        styleMap.put("dashed", new Integer(2));
        styleMap.put("double", new Integer(-2));
        styleMap.put("none", new Integer(0));
        widthMap.put("thin", new Integer(1));
        widthMap.put("medium", new Integer(2));
        widthMap.put("thick", new Integer(3));
    }
}

