/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.ImageHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.LineBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportComponentEditPolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ImageFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ImageBuilder;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ImageEditPart
extends ReportElementEditPart {
    private static final String IMG_TRANS_MSG = Messages.getString((String)"ImageEditPart.trans.editImage");

    public ImageEditPart(Object model) {
        super(model);
    }

    public ImageHandleAdapter getImageAdapter() {
        return (ImageHandleAdapter)this.getModelAdapter();
    }

    protected IFigure createFigure() {
        return new ImageFigure();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new ReportComponentEditPolicy(){

            public boolean understandsRequest(Request request) {
                if ("direct edit".equals(request.getType()) || "open".equals(request.getType()) || "create element".equals(request.getType())) {
                    return true;
                }
                return super.understandsRequest(request);
            }
        });
    }

    public void refreshFigure() {
        this.refreshBorder((DesignElementHandle)this.getModel(), new LineBorder());
        Insets pist = this.getImageAdapter().getPadding(this.getFigure().getInsets());
        ((LineBorder)this.getFigure().getBorder()).setPaddingInsets(pist);
        Image image = null;
        try {
            image = this.getImageAdapter().getImage();
        }
        catch (SWTException e) {
            // empty catch block
        }
        ((ImageFigure)this.getFigure()).setStretched(image != null);
        if (image == null) {
            image = ReportPlatformUIImages.getImage("Missing image");
        }
        ((ImageFigure)this.getFigure()).setImage(image);
        if (this.getImageAdapter().getSize() != null) {
            this.getFigure().setSize(this.getImageAdapter().getSize());
        } else if (image != null) {
            Dimension rawSize = this.getImageAdapter().getRawSize();
            if (rawSize.height == 0 && rawSize.width == 0) {
                this.getFigure().setSize(new Dimension(image.getBounds().width, image.getBounds().height));
            } else if (rawSize.height == 0) {
                this.getFigure().setSize(new Dimension(rawSize.width, image.getBounds().height));
            } else {
                this.getFigure().setSize(new Dimension(image.getBounds().width, rawSize.height));
            }
        }
        this.refreshBackgroundColor((DesignElementHandle)this.getModel());
        this.refreshMargin();
        ((AbstractGraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), this.getConstraint());
    }

    protected Object getConstraint() {
        ReportItemHandle handle = (ReportItemHandle)this.getModel();
        ReportItemConstraint constraint = new ReportItemConstraint();
        constraint.setDisplay(handle.getPrivateStyle().getDisplay());
        DimensionHandle value = handle.getWidth();
        constraint.setMeasure(value.getMeasure());
        constraint.setUnits(value.getUnits());
        return constraint;
    }

    public void performDirectEdit() {
        List dataSetList = DEUtil.getDataSetListExcludeSelf((DesignElementHandle)((DesignElementHandle)this.getModel()));
        ImageBuilder dialog = new ImageBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), ImageBuilder.DLG_TITLE_EDIT, dataSetList);
        dialog.setInput(this.getModel());
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(IMG_TRANS_MSG);
        if (dialog.open() == 0) {
            stack.commit();
        } else {
            stack.rollback();
        }
    }
}

