/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.schematic.ColumnHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.RowHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportElementEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableCellEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.CellDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.TableLayout;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class TableUtil {
    public static void calculateNewSelection(Rectangle bounds, List selection, List children) {
        for (int i = 0; i < children.size(); ++i) {
            EditPart child = (EditPart)children.get(i);
            if (!child.isSelectable() || TableUtil.isInTable(child)) continue;
            IFigure figure = ((GraphicalEditPart)child).getFigure();
            Rectangle r = figure.getBounds().getCopy();
            figure.translateToAbsolute((Translatable)r);
            Rectangle rect = bounds.getCopy().intersect(r);
            if (rect.width <= 0 || rect.height <= 0 || !figure.isShowing() || child.getTargetEditPart(CellDragTracker.MARQUEE_REQUEST) != child || !TableUtil.isFigureVisible(figure) || selection.contains(child)) continue;
            selection.add(child);
        }
    }

    public static Rectangle getUnionBounds(List list) {
        int size = list.size();
        if (size == 0) {
            return new Rectangle();
        }
        IFigure figure = ((TableCellEditPart)((Object)list.get(0))).getFigure();
        Rectangle retValue = figure.getBounds().getCopy();
        for (int i = 1; i < size; ++i) {
            TableCellEditPart cellPart = (TableCellEditPart)((Object)list.get(i));
            retValue.union(cellPart.getFigure().getBounds());
        }
        retValue.shrink(2, 2);
        figure.translateToAbsolute((Translatable)retValue);
        return retValue;
    }

    private static boolean isInTable(EditPart child) {
        if (child instanceof TableCellEditPart) {
            return false;
        }
        for (EditPart part = child.getParent(); part != null; part = part.getParent()) {
            if (!(part instanceof TableCellEditPart)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFigureVisible(IFigure fig) {
        Rectangle figBounds = fig.getBounds().getCopy();
        for (IFigure walker = fig.getParent(); !figBounds.isEmpty() && walker != null; walker = walker.getParent()) {
            walker.translateToParent((Translatable)figBounds);
            figBounds.intersect(walker.getBounds());
        }
        return !figBounds.isEmpty();
    }

    public static int caleY(TableEditPart part, int row) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        for (int i = 1; i < row; ++i) {
            height += data.findRowData((int)i).height;
        }
        return height;
    }

    public static int caleVisualHeight(TableEditPart part, Object row) {
        RowHandleAdapter adapt = HandleAdapterFactory.getInstance().getRowHandleAdapter(row);
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return adapt.getHeight();
        }
        int rowNumber = adapt.getRowNumber();
        if (rowNumber <= data.rowHeights.length) {
            return data.findRowData((int)rowNumber).height;
        }
        return 0;
    }

    public static int caleVisualWidth(TableEditPart part, Object Column) {
        ColumnHandleAdapter adapt = HandleAdapterFactory.getInstance().getColumnHandleAdapter(Column);
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return adapt.getWidth();
        }
        int columnNumber = adapt.getColumnNumber();
        if (columnNumber <= data.columnWidths.length) {
            return data.findColumnData((int)columnNumber).width;
        }
        return 0;
    }

    public static int caleX(TableEditPart part, int column) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        for (int i = 1; i < column; ++i) {
            height += data.findColumnData((int)i).width;
        }
        return height;
    }

    public static List getSelectionCells(TableEditPart part) {
        List list = part.getViewer().getSelectedEditParts();
        ArrayList temp = new ArrayList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (!(list.get(i) instanceof TableCellEditPart)) continue;
            temp.add(list.get(i));
        }
        return temp;
    }

    public static ISelection filletCellInSelectionEditorpart(ISelection selection) {
        if (selection == null || !(selection instanceof IStructuredSelection)) {
            return new StructuredSelection(Collections.EMPTY_LIST);
        }
        List list = ((IStructuredSelection)selection).toList();
        list = TableUtil.filterRemoveEditpart(list);
        List retValue = TableUtil.filletCellModel(list);
        return new StructuredSelection(retValue);
    }

    private static List filterRemoveEditpart(List list) {
        ArrayList retValue = new ArrayList(list);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (!(obj instanceof ReportElementEditPart) || !((ReportElementEditPart)((Object)obj)).isDelete()) continue;
            retValue.remove(obj);
        }
        return retValue;
    }

    public static List filletCellModel(List list) {
        Object obj;
        int i;
        ArrayList retValue = new ArrayList(list);
        boolean hasRowOrColumn = false;
        int size = list.size();
        for (i = 0; i < size; ++i) {
            obj = list.get(i);
            if (!(obj instanceof TableEditPart.DummyColumnEditPart) && !(obj instanceof TableEditPart.DummyRowEditPart)) continue;
            hasRowOrColumn = true;
            break;
        }
        if (hasRowOrColumn) {
            for (i = 0; i < size; ++i) {
                obj = list.get(i);
                if (!(obj instanceof TableCellEditPart)) continue;
                retValue.remove(obj);
            }
        }
        return retValue;
    }

    public static int getMinHeight(TableEditPart part, int rowNumber) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (rowNumber <= data.rowHeights.length) {
            return data.findRowData((int)rowNumber).minRowHeight;
        }
        return 0;
    }

    public static int getMinWidth(TableEditPart part, int columnNumber) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        if (columnNumber <= data.columnWidths.length) {
            return data.findColumnData((int)columnNumber).minColumnWidth;
        }
        return 0;
    }

    public static int getTableContentsHeight(TableEditPart part) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int height = 0;
        if (data.rowHeights == null) {
            return height;
        }
        int len = data.rowHeights.length;
        for (int i = 0; i < len; ++i) {
            height += data.rowHeights[i].height;
        }
        return height;
    }

    public static int getTableContentsWidth(TableEditPart part) {
        IFigure figure = part.getLayer("Primary Layer");
        TableLayout.WorkingData data = (TableLayout.WorkingData)figure.getLayoutManager().getConstraint(figure);
        if (data == null) {
            return 0;
        }
        int width = 0;
        if (data.columnWidths == null) {
            return width;
        }
        int len = data.columnWidths.length;
        for (int i = 0; i < len; ++i) {
            width += data.columnWidths[i].width;
        }
        return width;
    }

    public static boolean isAllCell(List list) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Object obj = list.get(i);
            if (obj instanceof CellHandle) continue;
            return false;
        }
        return true;
    }

    public static boolean isContinue(int[] intValue) {
        if (intValue == null || intValue.length < 2) {
            return true;
        }
        Arrays.sort(intValue);
        int len = intValue.length;
        return len - 1 == intValue[len - 1] - intValue[0];
    }
}

