/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.ExtendedItemPageGenerator;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.extensions.IExtension;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedEditPart;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.PaletteCategory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportCombinedTemplateCreationEntry;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemFigureProvider;
import org.eclipse.birt.report.designer.ui.extensions.IReportItemPropertyEditUI;
import org.eclipse.birt.report.designer.ui.views.attributes.DefaultPageGenerator;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.jface.resource.ImageDescriptor;

public class GuiExtensionManager {
    public static final String PALETTE_DESIGNER = "pallet_designer";
    public static final String PALETTE_MASTERPAGE = "pallet_masterpage";
    public static final String DESIGNER_FACTORY = "designer_factory";
    public static final String ATTRIBUTE = "attribute";
    private static final String EXT_MGR_LABEL;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Object doExtension(IExtension extension, Object object) {
        List list = ExtensionPointManager.getInstance().getExtendedElementPoints();
        if (list == null || list.size() == 0) {
            return null;
        }
        Object retValue = null;
        if (PALETTE_DESIGNER.equals(extension.getExtendsionIdentify()) || PALETTE_MASTERPAGE.equals(extension.getExtendsionIdentify())) {
            retValue = GuiExtensionManager.doPalette(object, extension.getExtendsionIdentify());
        } else if (DESIGNER_FACTORY.equals(extension.getExtendsionIdentify())) {
            retValue = GuiExtensionManager.doDesignerFactory(object);
        } else if (ATTRIBUTE.equals(extension.getExtendsionIdentify())) {
            retValue = GuiExtensionManager.doAttribute(object);
        }
        return retValue;
    }

    private static Object doAttribute(Object object) {
        DefaultPageGenerator retValue = null;
        if (object instanceof ExtendedItemHandle) {
            retValue = new DefaultPageGenerator();
            ExtendedItemHandle handle = (ExtendedItemHandle)object;
            String id = GuiExtensionManager.getExtendedElementID(handle);
            ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(id);
            if (point == null) {
                return retValue;
            }
            IReportItemPropertyEditUI edit = point.getReportItemPropertyEditUI();
            ExtendedItemPageGenerator generator = new ExtendedItemPageGenerator();
            generator.setPropertyEditUI(edit);
            retValue = generator;
        }
        return retValue;
    }

    private static Object doDesignerFactory(Object object) {
        if (object instanceof ExtendedItemHandle) {
            ExtendedItemHandle model = (ExtendedItemHandle)object;
            ExtendedEditPart part = new ExtendedEditPart(model);
            String id = GuiExtensionManager.getExtendedElementID(model);
            ExtendedElementUIPoint point = ExtensionPointManager.getInstance().getExtendedElementPoint(id);
            if (point == null) {
                return null;
            }
            IReportItemFigureProvider UI = ExtensionPointManager.getInstance().getExtendedElementPoint(id).getReportItemUI();
            if (UI == null) {
                return null;
            }
            part.setExtendedElementUI(UI);
            return part;
        }
        return null;
    }

    public static String getExtendedElementID(ExtendedItemHandle model) {
        return model.getExtensionName();
    }

    public static String getExtensionDisplayName(Object obj) {
        String name;
        String value = EXT_MGR_LABEL;
        if (obj instanceof ExtendedItemHandle && (name = ((ExtendedItemHandle)obj).getDefn().getDisplayName()) != null) {
            value = name;
        }
        return value;
    }

    private static Object doPalette(Object object, String type) {
        if (!$assertionsDisabled && !(object instanceof PaletteRoot)) {
            throw new AssertionError();
        }
        PaletteRoot root = (PaletteRoot)object;
        List list = root.getChildren();
        List exts = ExtensionPointManager.getInstance().getExtendedElementPoints();
        if (exts == null) {
            return root;
        }
        Iterator itor = exts.iterator();
        while (itor.hasNext()) {
            Boolean bool;
            ExtendedElementUIPoint point = (ExtendedElementUIPoint)itor.next();
            if (point == null) {
                return root;
            }
            String category = (String)point.getAttribute("category");
            ImageDescriptor icon = (ImageDescriptor)point.getAttribute("paletteIcon");
            IReportItemFigureProvider UI = point.getReportItemUI();
            if (UI == null) {
                return root;
            }
            if (PALETTE_DESIGNER.equals(type) ? (bool = (Boolean)point.getAttribute("showInDesigner")) == false : PALETTE_MASTERPAGE.equals(type) && (bool = (Boolean)point.getAttribute("showInMasterPage")) == false) continue;
            String displayName = DesignEngine.getMetaDataDictionary().getExtension(point.getExtensionName()).getDisplayName();
            ReportCombinedTemplateCreationEntry combined = new ReportCombinedTemplateCreationEntry(displayName, Messages.getFormattedString((String)"GuiExtensionManager.tooltip.insert", (Object[])new Object[]{displayName}), GuiExtensionManager.getExtendedPalletTemplateName(point), new ReportElementFactory("Extended" + point.getExtensionName()), icon, icon, BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName(GuiExtensionManager.getExtendedPalletTemplateName(point)));
            PaletteCategory entry = GuiExtensionManager.findCategory(list, category);
            if (entry == null) {
                String categoryLabel = (String)point.getAttribute("categoryDisplayName");
                if (categoryLabel == null) {
                    categoryLabel = category;
                }
                entry = new PaletteCategory(category, categoryLabel, null);
                root.add((PaletteEntry)entry);
            }
            entry.add((PaletteEntry)combined);
        }
        return root;
    }

    public static Object getExtendedPalletTemplateName(ExtendedElementUIPoint point) {
        return "Extended" + point.getExtensionName();
    }

    private static PaletteCategory findCategory(List list, String category) {
        Iterator itor = list.iterator();
        while (itor.hasNext()) {
            Object entry = itor.next();
            if (!(entry instanceof PaletteCategory) || !((PaletteCategory)((Object)entry)).getCategoryName().equals(category)) continue;
            return (PaletteCategory)((Object)entry);
        }
        return null;
    }

    static {
        $assertionsDisabled = !GuiExtensionManager.class.desiredAssertionStatus();
        EXT_MGR_LABEL = Messages.getString((String)"GuiExtensionManager.label.name");
    }
}

