/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures;

import com.ibm.icu.text.BreakIterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TextFlow;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowPage;
import org.eclipse.draw2d.text.ParagraphTextLayout;
import org.eclipse.swt.graphics.Font;

public class LabelFigure
extends ReportElementFigure {
    private static final Dimension ZERO_DIMENSION = new Dimension();
    private TextFlow label;
    private FlowPage flowPage;
    private String display;
    private Dimension recommendSize;
    static final BreakIterator LINE_BREAK = BreakIterator.getLineInstance();

    public LabelFigure() {
        this(1);
    }

    public LabelFigure(int borderSize) {
        this.setBorder((Border)new MarginBorder(borderSize));
        this.label = new TextFlow(){

            public void postValidate() {
                if ("block".equals(LabelFigure.this.display) || "inline".equals(LabelFigure.this.display)) {
                    int i;
                    int left;
                    List list = this.getFragments();
                    int top = left = Integer.MAX_VALUE;
                    int bottom = Integer.MIN_VALUE;
                    for (i = 0; i < list.size(); ++i) {
                        FlowBox box = (FlowBox)list.get(i);
                        left = Math.min(left, box.getX());
                        top = Math.min(top, box.getBaseline() - box.getAscent());
                        bottom = Math.max(bottom, box.getBaseline() + box.getDescent());
                    }
                    this.setBounds(new Rectangle(left, top, LabelFigure.this.getClientArea().width, Math.max(LabelFigure.this.getClientArea().height, bottom - top)));
                    list = this.getChildren();
                    for (i = 0; i < list.size(); ++i) {
                        ((FlowFigure)list.get(i)).postValidate();
                    }
                } else {
                    super.postValidate();
                }
            }
        };
        this.label.setLayoutManager((LayoutManager)new ParagraphTextLayout((org.eclipse.draw2d.text.TextFlow)this.label, 1));
        this.flowPage = new FlowPage();
        this.flowPage.add((IFigure)this.label);
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.add((IFigure)this.flowPage);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        int ry;
        Dimension dim = super.getPreferredSize(wHint, hHint);
        int rx = this.recommendSize != null ? this.recommendSize.width : 0;
        int n = ry = this.recommendSize != null ? this.recommendSize.height : 0;
        if ("block".equals(this.display)) {
            return new Dimension(dim.width, Math.max(dim.height, ry));
        }
        if ("inline".equals(this.display)) {
            return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
        }
        return dim;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        int ry;
        if ("none".equals(this.display)) {
            return ZERO_DIMENSION;
        }
        int rx = this.recommendSize != null ? this.recommendSize.width : 0;
        int n = ry = this.recommendSize != null ? this.recommendSize.height : 0;
        if (wHint == -1 && hHint == -1) {
            int maxWidth = this.calcMaxSegment();
            return new Dimension(Math.max(maxWidth, rx), Math.max(this.getInsets().getHeight(), ry));
        }
        Dimension dim = super.getMinimumSize(-1, hHint);
        if (dim.width < wHint) {
            return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
        }
        dim = super.getMinimumSize(wHint, hHint);
        return new Dimension(Math.max(dim.width, rx), Math.max(dim.height, ry));
    }

    private int calcMaxSegment() {
        int tempMaxWidth;
        String text = this.label.getText();
        char[] chars = text.toCharArray();
        int position = 0;
        int maxWidth = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (!LabelFigure.canBreakAfter(chars[i])) continue;
            String st = text.substring(position, i + 1);
            tempMaxWidth = FigureUtilities.getStringExtents((String)st, (Font)this.getFont()).width;
            if (tempMaxWidth > maxWidth) {
                maxWidth = tempMaxWidth;
            }
            position = i;
        }
        String st = text.substring(position, chars.length);
        tempMaxWidth = FigureUtilities.getStringExtents((String)st, (Font)this.getFont()).width;
        if (tempMaxWidth > maxWidth) {
            maxWidth = tempMaxWidth;
        }
        return maxWidth;
    }

    static boolean canBreakAfter(char c) {
        boolean result;
        boolean bl = result = Character.isWhitespace(c) || c == '-';
        if (!(result || c >= 'a' && c <= 'z')) {
            LINE_BREAK.setText(c + "a");
            result = LINE_BREAK.isBoundary(1);
        }
        return result;
    }

    private static int getMinimumFontSize(Font ft) {
        if (ft != null && ft.getFontData().length > 0) {
            return ft.getFontData()[0].height;
        }
        return 0;
    }

    public Rectangle getEditorArea() {
        Rectangle rect = this.getClientArea().getCopy();
        String s = this.getText();
        int count = 0;
        if (s != null && s.length() > 1) {
            for (int i = s.length() - 2; i >= 0 && "\r\n".equals(s.substring(i, i + 2)); i -= 2) {
                ++count;
            }
        }
        int hh = LabelFigure.getMinimumFontSize(this.getFont());
        rect.height = rect.height + (count * hh + (count == 0 ? 0 : hh / 2));
        return rect;
    }

    public void setRecommendSize(Dimension recommendSize) {
        this.recommendSize = recommendSize;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String newText) {
        if (newText == null) {
            newText = "";
        }
        this.label.setText(newText);
    }

    public void setTextOverline(String textOverline) {
        this.label.setTextOverline(textOverline);
    }

    public void setTextLineThrough(String textLineThrough) {
        this.label.setTextLineThrough(textLineThrough);
    }

    public void setTextUnderline(String textUnderline) {
        this.label.setTextUnderline(textUnderline);
    }

    public void setTextAlign(String textAlign) {
        this.label.setTextAlign(textAlign);
    }

    public void setVerticalAlign(String verticalAlign) {
        this.label.setVerticalAlign(verticalAlign);
    }

    public void setToolTipText(String toolTip) {
        if (toolTip != null) {
            LabelFigure tooltip = new LabelFigure();
            tooltip.setText(toolTip);
            tooltip.setBorder((Border)new MarginBorder(0, 2, 0, 2));
            this.setToolTip((IFigure)tooltip);
        } else {
            this.setToolTip(null);
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.label.setFont(f);
    }
}

