/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.model.schematic.TableHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableDragGuideTracker;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;

public class RowDragTracker
extends TableDragGuideTracker {
    public RowDragTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart, start, end);
        this.setDisabledCursor(Cursors.SIZENS);
    }

    protected void resize() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        int value = this.getLocation().y - this.getStartLocation().y;
        if (this.getStart() != this.getEnd()) {
            value = this.getTrueValue(value);
            part.resizeRow(this.getStart(), this.getEnd(), value);
        } else {
            Dimension dimension = this.getDragWidth();
            if (value < dimension.width) {
                value = dimension.width;
            }
            TableHandleAdapter adp = HandleAdapterFactory.getInstance().getTableHandleAdapter(part.getModel());
            Dimension dm = adp.calculateSize();
            dm.height += value;
            try {
                adp.ajustSize(dm);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
        }
    }

    protected Rectangle getMarqueeSelectionRectangle() {
        IFigure figure = ((TableEditPart)this.getSourceEditPart()).getFigure();
        Insets insets = figure.getInsets();
        int value = this.getLocation().y - this.getStartLocation().y;
        value = this.getTrueValue(value);
        Point p = this.getStartLocation().getCopy();
        figure.translateToAbsolute((Translatable)p);
        figure.translateToRelative((Translatable)p);
        Rectangle bounds = figure.getBounds().getCopy();
        figure.translateToAbsolute((Translatable)bounds);
        return new Rectangle(bounds.x + insets.left, value + p.y, bounds.width - (insets.left + insets.right), 2);
    }

    protected Dimension getDragWidth() {
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        Object start = part.getRow(this.getStart());
        return new Dimension(part.getMinHeight(this.getStart()) - this.getRowHeight(start), Integer.MAX_VALUE);
    }
}

