/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.RowHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.IContainer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.TableSelectionGuideTracker;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;

public class RowTracker
extends TableSelectionGuideTracker {
    IContainer container;

    public RowTracker(TableEditPart sourceEditPart, int row, IContainer container) {
        super(sourceEditPart, row);
        this.container = container;
    }

    public void select() {
        if (this.container.isSelect() && this.getCurrentInput().isMouseButtonDown(3)) {
            return;
        }
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        part.selectRow(new int[]{this.getNumber()});
    }

    protected boolean handleMove() {
        return super.handleMove();
    }

    protected boolean handleButtonUp(int button) {
        boolean rlt = super.handleButtonUp(button);
        if (button == 1 && this.container != null && this.container.contains(this.getLocation())) {
            this.getSourceEditPart().getViewer().getContextMenu().getMenu().setVisible(true);
        }
        return rlt;
    }

    public boolean isDealwithDrag() {
        Handle handle = this.getHandleUnderMouse();
        if (handle instanceof RowHandle) {
            return ((RowHandle)handle).getOwner() == this.getSourceEditPart();
        }
        return false;
    }

    public void selectDrag() {
        RowHandle handle = (RowHandle)this.getHandleUnderMouse();
        int rowNumber = handle.getRowNumber();
        int number = this.getNumber();
        int[] rows = new int[]{};
        for (int i = number; i <= number + Math.abs(number - rowNumber); ++i) {
            int lenegth = rows.length;
            int[] temp = new int[lenegth + 1];
            System.arraycopy(rows, 0, temp, 0, lenegth);
            temp[lenegth] = number > rowNumber ? number - (i - number) : i;
            rows = temp;
        }
        if (rows.length > 0) {
            TableEditPart tableEditpart = (TableEditPart)this.getSourceEditPart();
            tableEditpart.selectRow(rows);
        }
    }

    protected void performOpen() {
        SelectionRequest request = new SelectionRequest();
        request.setLocation(this.getLocation());
        request.setType((Object)"open");
        request.getExtendedData().put("rowNumber", new Integer(this.getNumber()));
        if (this.getSourceEditPart().understandsRequest((Request)request)) {
            this.getSourceEditPart().performRequest((Request)request);
        }
    }
}

