/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools;

import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.tools.DragEditPartsTracker;
import org.eclipse.swt.widgets.Display;

public abstract class TableDragGuideTracker
extends DragEditPartsTracker {
    private int start;
    private int end;
    private Figure marqueeRectangleFigure;

    public TableDragGuideTracker(EditPart sourceEditPart, int start, int end) {
        super(sourceEditPart);
        this.start = start;
        this.end = end;
    }

    protected boolean handleDragInProgress() {
        return super.handleDragInProgress();
    }

    protected boolean handleButtonUp(int button) {
        return super.handleButtonUp(button);
    }

    protected void performSelection() {
    }

    protected void showSourceFeedback() {
        Rectangle rect = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rect);
        this.getMarqueeFeedbackFigure().setBounds(rect);
    }

    protected void showTargetFeedback() {
    }

    protected void performDrag() {
        this.resize();
        TableEditPart part = (TableEditPart)this.getSourceEditPart();
        part.getViewer().setSelection(part.getViewer().getSelection());
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure();
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    protected void eraseSourceFeedback() {
        super.eraseSourceFeedback();
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    public int getEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    protected abstract void resize();

    protected abstract Rectangle getMarqueeSelectionRectangle();

    protected abstract Dimension getDragWidth();

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    protected int getTrueValue(int value) {
        Dimension dimension = this.getDragWidth();
        if (value < dimension.width) {
            value = dimension.width;
        } else if (value > dimension.height) {
            value = dimension.height;
        }
        return value;
    }

    protected int getRowHeight(Object row) {
        return TableUtil.caleVisualHeight(this.getTableEditPart(), row);
    }

    protected int getColumnWidth(Object column) {
        return TableUtil.caleVisualWidth(this.getTableEditPart(), column);
    }

    protected int getRowHeight(int rowNumber) {
        Object row = this.getTableEditPart().getRow(rowNumber);
        return this.getRowHeight(row);
    }

    protected int getColumnWidth(int columnNumber) {
        Object column = this.getTableEditPart().getColumn(columnNumber);
        if (column == null) {
            return HandleAdapterFactory.getInstance().getTableHandleAdapter(this.getTableEditPart().getModel()).getDefaultWidth(columnNumber);
        }
        return this.getColumnWidth(column);
    }

    protected TableEditPart getTableEditPart() {
        return (TableEditPart)this.getSourceEditPart();
    }

    class MarqueeRectangleFigure
    extends Figure {
        private int offset = 0;
        private boolean schedulePaint = true;
        private static final int DELAY = 110;

        MarqueeRectangleFigure() {
        }

        protected void paintFigure(Graphics graphics) {
            Rectangle bounds = this.getBounds().getCopy();
            graphics.translate(this.getLocation());
            graphics.setXORMode(true);
            graphics.setForegroundColor(ColorConstants.white);
            graphics.setBackgroundColor(ColorConstants.black);
            graphics.setLineStyle(3);
            int[] points = new int[]{0 + this.offset, 0, bounds.width - 1, 0, bounds.width - 1, bounds.height - 1};
            graphics.drawPolyline(points);
            points[0] = 0;
            points[1] = 0 + this.offset;
            points[2] = 0;
            points[3] = bounds.height - 1;
            points[4] = bounds.width - 1;
            points[5] = bounds.height - 1;
            graphics.drawPolyline(points);
            graphics.translate(this.getLocation().getNegated());
            if (this.schedulePaint) {
                Display.getCurrent().timerExec(110, new Runnable(this){
                    private final /* synthetic */ MarqueeRectangleFigure this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        MarqueeRectangleFigure.access$008(this.this$1);
                        if (MarqueeRectangleFigure.access$000(this.this$1) > 5) {
                            MarqueeRectangleFigure.access$002(this.this$1, 0);
                        }
                        MarqueeRectangleFigure.access$102(this.this$1, true);
                        this.this$1.repaint();
                    }
                });
            }
            this.schedulePaint = false;
        }

        static /* synthetic */ int access$008(MarqueeRectangleFigure x0) {
            return x0.offset++;
        }

        static /* synthetic */ int access$000(MarqueeRectangleFigure x0) {
            return x0.offset;
        }

        static /* synthetic */ int access$002(MarqueeRectangleFigure x0, int x1) {
            x0.offset = x1;
            return x0.offset;
        }

        static /* synthetic */ boolean access$102(MarqueeRectangleFigure x0, boolean x1) {
            x0.schedulePaint = x1;
            return x0.schedulePaint;
        }
    }
}

