/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.layout;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ImageFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.LabelFigure;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportItemConstraint;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReportFlowLayout
extends AbstractHintLayout {
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_LEFTTOP = 1;
    public static final int ALIGN_RIGHTBOTTOM = 2;
    private static final Insets INSETS_SINGLETON = new Insets();
    protected boolean fill = false;
    protected int majorAlignment = 1;
    protected int minorAlignment = 1;
    protected int minorSpacing = 5;
    protected int majorSpacing = 5;
    private WorkingData data = null;
    private Hashtable constraints = new Hashtable();

    public int getMajorAlignment() {
        return this.majorAlignment;
    }

    public int getMajorSpacing() {
        return this.majorSpacing;
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    public int getMinorSpacing() {
        return this.minorSpacing;
    }

    private Insets getFigureMargin(IFigure f) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(f));
        Insets margin = INSETS_SINGLETON;
        if (constraint != null) {
            margin = constraint.getMargin();
        }
        if ((margin == null || margin == INSETS_SINGLETON) && f instanceof IReportElementFigure) {
            margin = ((IReportElementFigure)f).getMargin();
        }
        return margin;
    }

    private void initRow() {
        this.data.rowX = 0;
        this.data.rowHeight = 0;
        this.data.rowWidth = 0;
    }

    private void initVariables(IFigure parent) {
        this.data.row = new IFigure[parent.getChildren().size()];
        this.data.bounds = new Rectangle[this.data.row.length];
        this.data.margin = new Insets[this.data.row.length];
        this.data.maxWidth = this.data.area.width;
    }

    public void layout(IFigure parent) {
        Rectangle relativeArea;
        this.data = new WorkingData();
        this.data.area = relativeArea = parent.getClientArea();
        Iterator iterator = parent.getChildren().iterator();
        int wHint = parent.getClientArea().width;
        int hHint = -1;
        this.initVariables(parent);
        this.initRow();
        int i = 0;
        int display = 0;
        int lastDisplay = 0;
        while (iterator.hasNext()) {
            IFigure f = (IFigure)iterator.next();
            Insets fmargin = this.getFigureMargin(f);
            wHint = this.getDisplay(f) == 2 || f instanceof ImageFigure ? parent.getClientArea().width : -1;
            if (wHint != -1) {
                wHint = Math.max(0, wHint - fmargin.getWidth());
            }
            Dimension pref = this.getChildSize(f, wHint, hHint);
            if (f instanceof LabelFigure && pref.width + fmargin.getWidth() > parent.getClientArea().width) {
                pref = this.getChildSize(f, Math.max(0, parent.getClientArea().width - fmargin.getWidth()), hHint);
            }
            Rectangle r = new Rectangle(0, 0, pref.width + fmargin.getWidth(), pref.height + fmargin.getHeight());
            display = this.getDisplay(f);
            if (this.data.rowCount > this.data.rowPos && (this.data.rowWidth + r.width > this.data.maxWidth || display == 2 || lastDisplay == 2)) {
                this.layoutRow(parent);
            }
            lastDisplay = display;
            r.x = this.data.rowX;
            r.y = this.data.rowY;
            int dx = r.width + this.getMinorSpacing();
            this.data.rowX += dx;
            this.data.rowWidth += dx;
            this.data.rowHeight = Math.max(this.data.rowHeight, r.height);
            this.data.row[this.data.rowCount] = f;
            this.data.margin[this.data.rowCount] = fmargin;
            this.data.bounds[this.data.rowCount] = r;
            ++this.data.rowCount;
            ++i;
        }
        if (this.data.rowCount > this.data.rowPos) {
            this.layoutRow(parent);
        }
        this.layoutVertical(parent);
        this.data = null;
    }

    private void layoutVertical(IFigure parent) {
        block7: {
            int i;
            if (this.minorAlignment != 0 && this.minorAlignment != 2) break block7;
            int minTop = 0;
            int maxBottom = 0;
            for (i = 0; i < this.data.bounds.length; ++i) {
                if (this.data.bounds[i].y < minTop) {
                    minTop = this.data.bounds[i].y;
                }
                if (this.data.bounds[i].y + this.data.bounds[i].height <= maxBottom) continue;
                maxBottom = this.data.bounds[i].y + this.data.bounds[i].height;
            }
            if (maxBottom - minTop < this.data.area.height) {
                int adjustment = this.data.area.height - maxBottom + minTop;
                if (this.minorAlignment == 0) {
                    adjustment /= 2;
                }
                for (int i2 = 0; i2 < this.data.bounds.length; ++i2) {
                    Rectangle fbounds = this.data.bounds[i2].getCopy().crop(this.data.margin[i2]);
                    fbounds.y += adjustment;
                    this.setBoundsOfChild(parent, this.data.row[i2], fbounds);
                }
            } else {
                for (i = 0; i < this.data.bounds.length; ++i) {
                    Rectangle fbounds = this.data.bounds[i].getCopy().crop(this.data.margin[i]);
                    this.setBoundsOfChild(parent, this.data.row[i], fbounds);
                }
            }
        }
    }

    protected void layoutRow(IFigure parent) {
        int majorAdjustment = 0;
        int minorAdjustment = 0;
        int correctMajorAlignment = this.majorAlignment;
        int correctMinorAlignment = this.minorAlignment;
        majorAdjustment = this.data.area.width - this.data.rowWidth + this.getMinorSpacing();
        switch (correctMajorAlignment) {
            case 1: {
                majorAdjustment = 0;
                break;
            }
            case 0: {
                majorAdjustment /= 2;
                break;
            }
        }
        boolean needVerticalAlign = this.minorAlignment == 0 || this.minorAlignment == 2;
        for (int j = this.data.rowPos; j < this.data.rowCount; ++j) {
            if (this.fill) {
                this.data.bounds[j].height = this.data.rowHeight;
            } else {
                minorAdjustment = this.data.rowHeight - this.data.bounds[j].height;
                switch (correctMinorAlignment) {
                    case 1: {
                        minorAdjustment = 0;
                        break;
                    }
                    case 0: {
                        minorAdjustment /= 2;
                        break;
                    }
                }
                this.data.bounds[j].y += minorAdjustment;
            }
            this.data.bounds[j].x += majorAdjustment;
            if (needVerticalAlign) continue;
            this.setBoundsOfChild(parent, this.data.row[j], this.data.bounds[j].getCopy().crop(this.data.margin[j]));
        }
        this.data.rowPos = this.data.rowCount;
        this.data.rowY += this.getMajorSpacing() + this.data.rowHeight;
        this.initRow();
    }

    protected void setBoundsOfChild(IFigure parent, IFigure child, Rectangle bounds) {
        parent.getClientArea(Rectangle.SINGLETON);
        bounds.translate(Rectangle.SINGLETON.x, Rectangle.SINGLETON.y);
        child.setBounds(bounds);
    }

    public void setStretchMinorAxis(boolean value) {
        this.fill = value;
    }

    public void setMajorAlignment(int align) {
        this.majorAlignment = align;
    }

    public void setMajorSpacing(int n) {
        this.majorSpacing = n;
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setMinorSpacing(int n) {
        this.minorSpacing = n;
    }

    private int getDisplay(IFigure element) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(element));
        if (constraint != null) {
            return constraint.getDisplay();
        }
        return 2;
    }

    public Object getConstraint(IFigure child) {
        return this.constraints.get(child);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    protected Dimension getChildSize(IFigure child, int wHint, int hHint) {
        ReportItemConstraint constraint = (ReportItemConstraint)((Object)this.getConstraint(child));
        Dimension preferredDimension = child.getPreferredSize(wHint, hHint);
        if (constraint != null) {
            if (constraint.isNone()) {
                return new Dimension(0, 0);
            }
            Dimension dimension = constraint.getSize();
            if (dimension.height <= 0) {
                dimension.height = preferredDimension.height;
            }
            if (dimension.width <= 0) {
                dimension.width = constraint.getMeasure() != 0.0 && "%".equals(constraint.getUnits()) ? (int)constraint.getMeasure() * wHint / 100 : preferredDimension.width;
            }
            return dimension;
        }
        return preferredDimension;
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        int maxWidth = wHint;
        hHint = -1;
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        IFigure lastChild = null;
        for (int i = 0; i < children.size(); ++i) {
            IFigure child = (IFigure)children.get(i);
            Insets fmargin = this.getFigureMargin(child);
            if (wHint != -1) {
                wHint = Math.max(0, wHint - fmargin.getWidth());
            }
            if (this.getDisplay(child) != 2) {
                wHint = -1;
            }
            Dimension childSize = this.getChildSize(child, wHint, hHint);
            if (i == 0) {
                width = childSize.width + fmargin.getWidth();
                height = childSize.height + fmargin.getHeight();
            } else if (this.getDisplay(child) != 0) {
                if (width + childSize.width + fmargin.getWidth() + this.getMinorSpacing() <= maxWidth && this.getDisplay(child) == 1 && this.getDisplay(lastChild) == 1) {
                    width += childSize.width + fmargin.getWidth() + this.getMinorSpacing();
                    height = Math.max(height, childSize.height + fmargin.getHeight());
                } else {
                    prefSize.height += height + this.getMajorSpacing();
                    prefSize.width = Math.max(prefSize.width, width);
                    width = childSize.width + fmargin.getWidth();
                    height = childSize.height + fmargin.getHeight();
                }
            }
            lastChild = child;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        if (wHint > -1) {
            wHint = Math.max(0, wHint - container.getInsets().getWidth());
        }
        if (hHint > -1) {
            hHint = Math.max(0, hHint - container.getInsets().getHeight());
        }
        int maxWidth = wHint;
        hHint = -1;
        if (maxWidth < 0) {
            maxWidth = Integer.MAX_VALUE;
        }
        Dimension prefSize = new Dimension();
        List children = container.getChildren();
        int width = 0;
        int height = 0;
        IFigure lastChild = null;
        for (int i = 0; i < children.size(); ++i) {
            IFigure child = (IFigure)children.get(i);
            Insets fmargin = this.getFigureMargin(child);
            if (wHint != -1) {
                wHint = Math.max(0, wHint - fmargin.getWidth());
            }
            Dimension childSize = child.getMinimumSize(wHint, hHint);
            if (i == 0) {
                width = childSize.width + fmargin.getWidth();
                height = childSize.height + fmargin.getHeight();
            } else if (this.getDisplay(child) != 0) {
                if (width + childSize.width + fmargin.getWidth() + this.getMinorSpacing() <= maxWidth && this.getDisplay(child) == 1 && this.getDisplay(lastChild) == 1) {
                    width += childSize.width + fmargin.getWidth() + this.getMinorSpacing();
                    height = Math.max(height, childSize.height + fmargin.getHeight());
                } else {
                    prefSize.height += height + this.getMajorSpacing();
                    prefSize.width = Math.max(prefSize.width, width);
                    width = childSize.width + fmargin.getWidth();
                    height = childSize.height + fmargin.getHeight();
                }
            }
            lastChild = child;
        }
        prefSize.height += height;
        prefSize.width = Math.max(prefSize.width, width);
        prefSize.width += container.getInsets().getWidth();
        prefSize.height += container.getInsets().getHeight();
        prefSize.union(this.getBorderPreferredSize(container));
        return prefSize;
    }

    class WorkingData {
        int rowHeight;
        int rowWidth;
        int rowCount;
        int rowX;
        int rowY;
        int maxWidth;
        int rowPos;
        Rectangle[] bounds;
        Rectangle area;
        Insets[] margin;
        IFigure[] row;

        WorkingData() {
        }
    }
}

