/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.palette;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.data.DataSetItemModel;
import org.eclipse.birt.report.designer.internal.ui.dnd.InsertInLayoutUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.AbstractToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.LibraryElementsToolHandleExtends;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportCreationTool;
import org.eclipse.birt.report.designer.internal.ui.palette.BasePaletteFactory;
import org.eclipse.birt.report.designer.internal.ui.palette.ReportElementFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.InsertInLayoutAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.DNDUtil;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DropTargetEvent;

public class ReportTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private static final String TRANS_LABEL_CREATE_ELEMENT = Messages.getString((String)"ReportTemplateTransferDropTargetListener.transLabel.createElement");
    private static final String IMG_TRANS_MSG = Messages.getString((String)"ImageEditPart.trans.editImage");

    public ReportTemplateTransferDropTargetListener(EditPartViewer viewer) {
        super(viewer);
    }

    protected CreationFactory getFactory(Object template) {
        if (this.handleValidateDrag(template)) {
            if (template instanceof String) {
                return new ReportElementFactory(template);
            }
            return new ReportElementFactory(this.getSingleTransferData(template), template);
        }
        return null;
    }

    protected void handleDrop() {
        Object dragObj;
        boolean isScalarparameter = false;
        boolean isResultSetColumn = false;
        boolean isEmbeddImage = false;
        Object template = TemplateTransfer.getInstance().getTemplate();
        Assert.isNotNull((Object)template);
        Assert.isTrue((boolean)this.handleValidateDrag(template));
        this.updateTargetRequest();
        this.updateTargetEditPart();
        AbstractToolHandleExtends preHandle = null;
        String transName = null;
        if (template instanceof String) {
            transName = TRANS_LABEL_CREATE_ELEMENT;
            preHandle = BasePaletteFactory.getAbstractToolHandleExtendsFromPaletteName(template);
        } else if (this.handleValidateInsert(template)) {
            transName = InsertInLayoutAction.DISPLAY_TEXT;
            Object objectType = this.getFactory(template).getObjectType();
            if (objectType instanceof DataSetHandle) {
                preHandle = new BasePaletteFactory.DataSetToolExtends();
            } else if (objectType instanceof DataSetItemModel) {
                preHandle = new BasePaletteFactory.DataSetColumnToolExtends();
            } else if (objectType instanceof ResultSetColumnHandle) {
                isResultSetColumn = true;
                preHandle = new BasePaletteFactory.DataSetColumnToolExtends();
            } else if (objectType instanceof ScalarParameterHandle) {
                isScalarparameter = true;
                preHandle = new BasePaletteFactory.ParameterToolExtends();
            }
        } else if (this.handleValidateLibrary(template)) {
            dragObj = this.getSingleTransferData(template);
            if (dragObj instanceof EmbeddedImageHandle) {
                ModuleHandle moduleHandle = SessionHandleAdapter.getInstance().getReportDesignHandle();
                LibraryHandle library = (LibraryHandle)((EmbeddedImageHandle)dragObj).getElementHandle().getRoot();
                try {
                    if (UIUtil.includeLibrary(moduleHandle, library)) {
                        EmbeddedImage image = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)((EmbeddedImageHandle)dragObj), (ModuleHandle)moduleHandle);
                        DNDUtil.addEmbeddedImageHandle((Object)this.getTargetEditPart().getModel(), (EmbeddedImage)image);
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.handle(e);
                }
                isEmbeddImage = true;
                preHandle = new BasePaletteFactory.ImageToolExtends();
            } else {
                preHandle = new LibraryElementsToolHandleExtends((DesignElementHandle)dragObj);
            }
        } else if (this.handleValidateOutline(template) && (dragObj = this.getSingleTransferData(template)) instanceof EmbeddedImageHandle) {
            isEmbeddImage = true;
            preHandle = new BasePaletteFactory.ImageToolExtends();
        }
        if (preHandle != null) {
            SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().startTrans(transName);
            preHandle.setRequest(this.getCreateRequest());
            preHandle.setTargetEditPart(this.getTargetEditPart());
            Command command = this.getCommand();
            if (command != null && command.canExecute() && !preHandle.preHandleMouseUp()) {
                SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
                return;
            }
            boolean isTheme = this.checkTheme(preHandle, this.getSingleTransferData(template));
            if (isTheme) {
                SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().commit();
            } else {
                super.handleDrop();
                if (!preHandle.postHandleCreation()) {
                    SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().rollback();
                    return;
                }
                SessionHandleAdapter.getInstance().getReportDesignHandle().getCommandStack().commit();
                if (isScalarparameter || isResultSetColumn) {
                    Request request = new Request((Object)"create scalarparameter or resultsetcolumn");
                    this.selectAddedObject(request);
                } else if (isEmbeddImage) {
                    Object dragObj2 = this.getSingleTransferData(template);
                    Object model = this.getCreateRequest().getExtendedData().get("newObject");
                    try {
                        ((ImageHandle)model).setImageName(((EmbeddedImageHandle)dragObj2).getName());
                    }
                    catch (SemanticException e) {
                        ExceptionHandler.handle(e);
                    }
                    CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                    stack.startTrans(IMG_TRANS_MSG);
                    stack.commit();
                } else {
                    this.selectAddedObject();
                }
            }
        }
    }

    private boolean checkTheme(AbstractToolHandleExtends preHandle, Object obj) {
        return preHandle instanceof LibraryElementsToolHandleExtends && obj instanceof ThemeHandle;
    }

    private boolean handleValidateDrag(Object dragObj) {
        return dragObj != null && (this.handleValidatePalette(dragObj) || this.handleValidateOutline(dragObj) || this.handleValidateInsert(dragObj) || this.handleValidateLibrary(dragObj));
    }

    private boolean handleValidatePalette(Object dragObj) {
        return dragObj instanceof String && (this.getTargetEditPart() == null || ReportCreationTool.handleValidatePalette(dragObj, this.getTargetEditPart()));
    }

    private boolean handleValidateInsert(Object template) {
        return InsertInLayoutUtil.handleValidateInsert(template) && (this.getTargetEditPart() == null || InsertInLayoutUtil.handleValidateInsertToLayout(template, this.getTargetEditPart()));
    }

    private boolean handleValidateOutline(Object dragSource) {
        if (dragSource != null) {
            Object[] dragObjs = dragSource instanceof Object[] ? (Object[])dragSource : new Object[]{dragSource};
            if (dragObjs.length == 0) {
                return false;
            }
            int i = 0;
            if (i < dragObjs.length) {
                return dragObjs[i] instanceof EmbeddedImageHandle && !(((EmbeddedImageHandle)dragObjs[i]).getElementHandle().getRoot() instanceof LibraryHandle);
            }
        }
        return false;
    }

    private boolean handleValidateLibrary(Object dragObj) {
        EditPart targetEditPart = this.getTargetEditPart();
        if (targetEditPart == null) {
            return true;
        }
        if (dragObj != null) {
            Object[] dragObjs = dragObj instanceof Object[] ? (Object[])dragObj : new Object[]{dragObj};
            if (dragObjs.length == 0) {
                return false;
            }
            for (int i = 0; i < dragObjs.length; ++i) {
                dragObj = dragObjs[i];
                if (dragObj instanceof ReportElementHandle) {
                    if (((ReportElementHandle)dragObj).getRoot() instanceof LibraryHandle) {
                        if (dragObj instanceof DataSetHandle || dragObj instanceof ParameterHandle) {
                            return true;
                        }
                        if (DNDUtil.handleValidateTargetCanContain((Object)targetEditPart.getModel(), (Object)dragObj) && DNDUtil.handleValidateTargetCanContainMore((Object)targetEditPart.getModel(), (int)1)) continue;
                        return false;
                    }
                    return false;
                }
                if (dragObj instanceof EmbeddedImageHandle && ((EmbeddedImageHandle)dragObj).getElementHandle().getRoot() instanceof LibraryHandle) {
                    int canContain = DNDUtil.handleValidateTargetCanContain((Object)targetEditPart.getModel(), (Object)dragObj, (boolean)true);
                    return canContain == 1;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public void dragOver(DropTargetEvent event) {
        super.dragOver(event);
        if (!this.handleValidateDrag(TemplateTransfer.getInstance().getTemplate())) {
            event.detail = 0;
        }
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getExtendedData().get("newObject");
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().setFocus();
        ReportCreationTool.selectAddedObject(model, viewer);
    }

    private void selectAddedObject(Request request) {
        Object model = this.getCreateRequest().getExtendedData().get("newObject");
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().setFocus();
        ReportCreationTool.selectAddedObject(model, viewer, request);
    }

    private Object getSingleTransferData(Object template) {
        if (template instanceof Object[]) {
            return ((Object[])template)[0];
        }
        return template;
    }
}

