/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.processor;

import org.eclipse.birt.report.designer.internal.ui.processor.DefaultElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.processor.DynamicTextProcessor;
import org.eclipse.birt.report.designer.internal.ui.processor.ExtenedElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.processor.IElementProcessor;
import org.eclipse.birt.report.designer.internal.ui.processor.ImageItemProcessor;
import org.eclipse.birt.report.designer.internal.ui.processor.TableGridProcessor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;

public class ElementProcessorFactory {
    public static IElementProcessor createProcessor(String elementType) {
        if ("Image".equals(elementType)) {
            return new ImageItemProcessor();
        }
        if ("Grid".equals(elementType) || "Table".equals(elementType)) {
            return new TableGridProcessor(elementType);
        }
        if ("TextData".equals(elementType)) {
            return new DynamicTextProcessor(elementType);
        }
        if (DesignEngine.getMetaDataDictionary().getExtension(elementType) != null) {
            return new ExtenedElementProcessor(elementType);
        }
        return new DefaultElementProcessor(elementType);
    }

    public static IElementProcessor createProcessor(DesignElementHandle handle) {
        return ElementProcessorFactory.createProcessor(handle.getDefn().getName());
    }
}

