/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.resourcelocator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.BaseResourceEntity;
import org.eclipse.birt.report.designer.internal.ui.resourcelocator.ResourceEntry;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class FragmentResourceEntry
extends BaseResourceEntity {
    private static Bundle bundle;
    private String name;
    private String displayName;
    private FragmentResourceEntry parent;
    private String path;
    private List children;
    private LibraryHandle library;
    private boolean isRoot;
    private boolean isFile;

    public FragmentResourceEntry() {
        this(null);
    }

    public FragmentResourceEntry(String[] filePattern) {
        block10: {
            this(Messages.getString((String)"FragmentResourceEntry.RootName"), "/", null, false);
            this.isRoot = true;
            this.displayName = Messages.getString((String)"FragmentResourceEntry.RootDisplayName");
            bundle = Platform.getBundle((String)"org.eclipse.birt.resources");
            if (bundle == null) break block10;
            if (filePattern != null && filePattern.length > 0) {
                for (int i = 0; i < filePattern.length; ++i) {
                    String[] patterns = filePattern[i].split(";");
                    for (int j = 0; j < patterns.length; ++j) {
                        Enumeration enumeration = bundle.findEntries("/", patterns[j], true);
                        while (enumeration != null && enumeration.hasMoreElements()) {
                            URL element = (URL)enumeration.nextElement();
                            String[] path = element.getPath().split("/");
                            FragmentResourceEntry parent = this;
                            for (int m = 0; m < path.length; ++m) {
                                if (path[m].equals("")) continue;
                                FragmentResourceEntry child = parent.getChild(path[m]);
                                if (child == null) {
                                    child = new FragmentResourceEntry(path[m], (parent.path.equals("/") ? "" : parent.path) + "/" + path[m], parent, m == path.length - 1);
                                }
                                parent = child;
                            }
                        }
                    }
                }
            } else {
                Enumeration enumeration = bundle.findEntries("/", "*", true);
                while (enumeration != null && enumeration.hasMoreElements()) {
                    URL element = (URL)enumeration.nextElement();
                    String[] path = element.getPath().split("/");
                    FragmentResourceEntry parent = this;
                    for (int i = 0; i < path.length; ++i) {
                        if (path[i].equals("")) continue;
                        FragmentResourceEntry child = parent.getChild(path[i]);
                        if (child == null) {
                            child = new FragmentResourceEntry(path[i], path[i], parent, i == path.length - 1);
                        }
                        parent = child;
                    }
                }
            }
        }
    }

    private FragmentResourceEntry(String name, String path, FragmentResourceEntry parent, boolean isFile) {
        this.children = new ArrayList();
        this.name = name;
        this.path = path;
        this.parent = parent;
        if (parent != null) {
            parent.addChild(this);
        }
        this.isFile = isFile;
    }

    private void addChild(FragmentResourceEntry entry) {
        this.children.add(entry);
    }

    private FragmentResourceEntry getChild(String name) {
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            FragmentResourceEntry entry = (FragmentResourceEntry)iter.next();
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public ResourceEntry[] getChildren() {
        return this.children.toArray(new ResourceEntry[this.children.size()]);
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Image getImage() {
        if (this.isRoot || this.getChildren().length > 0) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        return super.getImage();
    }

    public ResourceEntry getParent() {
        return this.parent;
    }

    public URL getURL() {
        if (bundle != null) {
            return bundle.getResource(this.path);
        }
        return null;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void dispose() {
        if (this.library != null) {
            this.library.close();
            this.library = null;
        }
        ResourceEntry[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
    }

    public Object getAdapter(Class adapter) {
        if (adapter == LibraryHandle.class) {
            if (this.getChildren().length == 0 && this.library == null) {
                try {
                    this.library = SessionHandleAdapter.getInstance().getSessionHandle().openLibrary(this.getURL().toString());
                }
                catch (DesignFileException designFileException) {
                    // empty catch block
                }
            }
            return this.library;
        }
        return super.getAdapter(adapter);
    }
}

