/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public final class Utility {
    private Utility() {
    }

    public static void setProperty(Object obj, String propertyName, Object value) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        PropertyDescriptor descriptor = Utility.getPropertyDescriptor(obj, propertyName);
        if (descriptor != null && (method = descriptor.getWriteMethod()) != null) {
            method.invoke(obj, value);
        }
    }

    public static Object getProperty(Object obj, String propertyName) throws IntrospectionException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method method;
        Object value = null;
        PropertyDescriptor descriptor = Utility.getPropertyDescriptor(obj, propertyName);
        if (descriptor != null && (method = descriptor.getReadMethod()) != null) {
            value = method.invoke(obj, null);
        }
        return value;
    }

    private static PropertyDescriptor getPropertyDescriptor(Object obj, String propertyName) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Utility.getPropertyDescriptors(obj);
        for (int n = 0; n < descriptors.length; ++n) {
            if (!descriptors[n].getName().equals(propertyName)) continue;
            return descriptors[n];
        }
        return null;
    }

    private static PropertyDescriptor[] getPropertyDescriptors(Object obj) throws IntrospectionException {
        BeanInfo info = Introspector.getBeanInfo(obj.getClass());
        return info.getPropertyDescriptors();
    }

    public static String getUniqueDataSetName(String baseName) {
        String finalName = baseName;
        int n = 1;
        while (HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSetName(finalName)) {
            finalName = baseName + n++;
        }
        return finalName;
    }

    public static String getUniqueDataSourceName(String baseName) {
        String finalName = baseName;
        int n = 1;
        while (HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().checkDataSourceName(finalName)) {
            finalName = baseName + n++;
        }
        return finalName;
    }

    public static boolean doesDataSourceModelExtensionExist(String extensionName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.model.odaDriverModel");
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                if (!elements[n].getName().equals("odaDataSource") || !extensionName.equals(elements[n].getAttribute("extensionName"))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doesDataSetModelExtensionExist(String extensionName) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.birt.report.model.odaDriverModel");
        if (elements != null) {
            for (int n = 0; n < elements.length; ++n) {
                if (!elements[n].getName().equals("odaDataSet") || !extensionName.equals(elements[n].getAttribute("extensionName"))) continue;
                return true;
            }
        }
        return false;
    }
}

