/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views;

import java.util.Iterator;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.ContextMenuProvider;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;

public class ViewContextMenuProvider
extends ContextMenuProvider {
    public ViewContextMenuProvider(ISelectionProvider viewer) {
        super(viewer);
    }

    public void buildContextMenu(IMenuManager menu) {
        Object[] inputs;
        menu.add((IContributionItem)new Separator("additions"));
        TreeViewer treeViewer = (TreeViewer)this.getViewer();
        IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
        Object input = treeViewer.getInput();
        if (input instanceof Object[] && (inputs = (Object[])input).length == 1 && inputs[0] instanceof ReportDesignHandle) {
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                if (!this.isIncludedLibrary(iter.next())) continue;
                return;
            }
        }
        if (selection.size() == 1) {
            Object obj = selection.getFirstElement();
            ProviderFactory.createProvider(obj).createContextMenu(treeViewer, obj, menu);
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Views) >> Shows for " + ProviderFactory.createProvider(obj).getNodeDisplayName(obj));
            }
        } else {
            ProviderFactory.getDefaultProvider().createContextMenu(treeViewer, selection, menu);
            if (Policy.TRACING_MENU_SHOW) {
                System.out.println("Menu(for Views) >> Shows for multi-selcetion.");
            }
        }
    }

    private boolean isIncludedLibrary(Object model) {
        if (model instanceof ReportElementHandle) {
            if (((ReportElementHandle)model).getModuleHandle() instanceof LibraryHandle) {
                return true;
            }
        } else if (model instanceof ReportElementModel) {
            return ((ReportElementModel)model).getElementHandle().getModuleHandle() instanceof LibraryHandle;
        }
        return false;
    }
}

