/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import java.io.File;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.internal.ui.views.actions.ExportToLibraryAction;
import org.eclipse.birt.report.designer.internal.ui.wizards.ExportReportWizardPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.command.LibraryChangeEvent;
import org.eclipse.birt.report.model.api.command.ResourceChangeEvent;
import org.eclipse.birt.report.model.api.util.ElementExportUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ExportToLibraryAction
extends AbstractViewAction {
    private static String windowTitle = Messages.getString((String)"ExportToLibraryAction.wizard.windowTitle");
    private static final String DISPLAY_TEXT = Messages.getString((String)"ExportToLibraryAction.action.text");
    public static final String PREF_KEY = "ExportToLibraryAction.Pref";
    public static final int PREF_OVERWRITE = 1;
    public static final int PREF_NOT_OVERWRITE = 2;
    public static final int PREF_PROMPT = 0;
    private static final String DIALOG_TITLE = Messages.getString((String)"ExportToLibraryAction.Dialog.Title");
    private static final String DIALOG_MESSAGE = Messages.getString((String)"ExportToLibraryAction.Dialog.Message");
    private static final String BUTTON_YES = Messages.getString((String)"ExportToLibraryAction.Button.Yes");
    private static final String BUTTON_NO = Messages.getString((String)"ExportToLibraryAction.Button.No");
    private static final String BUTTON_CANCEL = Messages.getString((String)"ExportToLibraryAction.Button.Cancel");
    private static final String REMEMBER_DECISION = Messages.getString((String)"ExportToLibraryAction.Message.RememberDecision");
    private boolean saveDecision;
    private int pref;

    public ExportToLibraryAction(Object selectedObject) {
        super(selectedObject, DISPLAY_TEXT);
    }

    public boolean isEnabled() {
        return this.getSelection() instanceof ReportDesignHandle;
    }

    public void run() {
        ExportReportWizard exportReportWizard = new ExportReportWizard();
        WizardDialog wDialog = new WizardDialog(UIUtil.getDefaultShell(), (IWizard)exportReportWizard);
        wDialog.setPageSize(500, 250);
        wDialog.open();
    }

    private void fireDesigFileChangeEvent(String filename) {
        SessionHandleAdapter.getInstance().getSessionHandle().fireResourceChange((ResourceChangeEvent)new LibraryChangeEvent(filename));
    }

    static /* synthetic */ String access$700() {
        return REMEMBER_DECISION;
    }

    static /* synthetic */ boolean access$1002(ExportToLibraryAction x0, boolean x1) {
        x0.saveDecision = x1;
        return x0.saveDecision;
    }

    static /* synthetic */ boolean access$1000(ExportToLibraryAction x0) {
        return x0.saveDecision;
    }

    public class ExportReportWizard
    extends Wizard {
        private ExportReportWizardPage page;

        public ExportReportWizard() {
            this.setWindowTitle(windowTitle);
            this.page = new ExportReportWizardPage("");
            this.addPage((IWizardPage)this.page);
        }

        public Image getDefaultPageImage() {
            return ReportPlugin.getImage("/icons/wizban/create_project_wizard.gif");
        }

        public boolean performFinish() {
            try {
                String filename = this.page.getFullName();
                if (!filename.endsWith(".rptlibrary")) {
                    filename = filename + ".rptlibrary";
                }
                ExportToLibraryAction.this.pref = ReportPlugin.getDefault().getPreferenceStore().getInt(ExportToLibraryAction.PREF_KEY);
                if (filename != null) {
                    MessageDialog prefDialog;
                    if (ExportToLibraryAction.this.pref == 0 && new File(filename).exists() && (prefDialog = new MessageDialog(this, UIUtil.getDefaultShell(), DIALOG_TITLE, null, DIALOG_MESSAGE, 2, new String[]{BUTTON_YES, BUTTON_NO, BUTTON_CANCEL}, 0){
                        private final /* synthetic */ ExportReportWizard this$1;
                        {
                            this.this$1 = this$1;
                            super(x0, x1, x2, x3, x4, x5, x6);
                        }

                        protected Control createCustomArea(Composite parent) {
                            Composite container = new Composite(parent, 0);
                            GridLayout gridLayout = new GridLayout();
                            gridLayout.marginWidth = 20;
                            container.setLayout((Layout)gridLayout);
                            Button chkbox = new Button(container, 32);
                            chkbox.setText(ExportToLibraryAction.access$700());
                            chkbox.addSelectionListener(new SelectionListener(this){
                                private final /* synthetic */ 1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                public void widgetSelected(SelectionEvent e) {
                                    ExportToLibraryAction.access$1002(ExportReportWizard.access$900(1.access$800(this.this$2)), !ExportToLibraryAction.access$1000(ExportReportWizard.access$900(1.access$800(this.this$2))));
                                }

                                public void widgetDefaultSelected(SelectionEvent e) {
                                    ExportToLibraryAction.access$1002(ExportReportWizard.access$900(1.access$800(this.this$2)), false);
                                }
                            });
                            return super.createCustomArea(parent);
                        }

                        protected void buttonPressed(int buttonId) {
                            switch (buttonId) {
                                case 0: {
                                    ExportToLibraryAction.access$102(ExportReportWizard.access$900(this.this$1), 1);
                                    break;
                                }
                                case 1: {
                                    ExportToLibraryAction.access$102(ExportReportWizard.access$900(this.this$1), 2);
                                    break;
                                }
                            }
                            if (ExportToLibraryAction.access$1000(ExportReportWizard.access$900(this.this$1))) {
                                ReportPlugin.getDefault().getPreferenceStore().setValue("ExportToLibraryAction.Pref", ExportToLibraryAction.access$100(ExportReportWizard.access$900(this.this$1)));
                            }
                            super.buttonPressed(buttonId);
                        }

                        static /* synthetic */ ExportReportWizard access$800(1 x0) {
                            return x0.this$1;
                        }
                    }).open() == 2) {
                        return true;
                    }
                    if (ExportToLibraryAction.this.getSelection() instanceof ReportDesignHandle) {
                        ElementExportUtil.exportDesign((ReportDesignHandle)((ReportDesignHandle)ExportToLibraryAction.this.getSelection()), (String)filename, (ExportToLibraryAction.this.pref == 1 ? 1 : 0) != 0, (boolean)true);
                    } else {
                        ElementExportUtil.exportElement((DesignElementHandle)((DesignElementHandle)ExportToLibraryAction.this.getSelection()), (String)filename, (ExportToLibraryAction.this.pref == 1 ? 1 : 0) != 0);
                    }
                    ExportToLibraryAction.this.fireDesigFileChangeEvent(filename);
                }
            }
            catch (Exception e) {
                ExceptionHandler.handle(e);
            }
            return true;
        }

        static /* synthetic */ ExportToLibraryAction access$900(ExportReportWizard x0) {
            return x0.ExportToLibraryAction.this;
        }
    }
}

