/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.actions;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.actions.AbstractViewAction;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class RefreshModuleHandleAction
extends AbstractViewAction {
    public static final String ID = "org.eclipse.birt.report.designer.internal.ui.views.actions.RefreshModuleHandleAction";
    public static final String ACTION_TEXT = Messages.getString((String)"RefreshModuleHandleAction.Action.Text");

    public RefreshModuleHandleAction(Object selectedObject) {
        super(selectedObject, ACTION_TEXT);
    }

    public RefreshModuleHandleAction(Object selectedObject, String text) {
        super(selectedObject, text);
    }

    public boolean isEnabled() {
        return this.getSelection() instanceof ReportDesignHandle || this.getSelection() instanceof LibraryHandle;
    }

    public void run() {
        Object obj = this.getSelection();
        if (obj instanceof LibraryHandle && ((LibraryHandle)obj).getHostHandle() != obj) {
            ModuleHandle host = ((LibraryHandle)obj).getHostHandle();
            if (host == null || !host.isInclude((LibraryHandle)obj)) {
                return;
            }
            try {
                host.reloadLibrary((LibraryHandle)obj);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                return;
            }
            catch (DesignFileException e) {
                ExceptionHandler.handle(e);
                return;
            }
        } else {
            this.reloadAllLibraries(obj);
        }
    }

    private Boolean reloadAllLibraries(Object obj) {
        boolean retBoolean = true;
        if (obj instanceof ReportDesignHandle || obj instanceof LibraryHandle) {
            ModuleHandle moduleHandle = (ModuleHandle)obj;
            try {
                moduleHandle.reloadLibraries();
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
                retBoolean = false;
            }
            catch (DesignFileException e) {
                ExceptionHandler.handle(e);
                retBoolean = false;
            }
        }
        return new Boolean(retBoolean);
    }
}

