/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.Set;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ImageBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReferencePage
extends AttributePage {
    private Text text;
    private Button button;
    private PropertyProcessor processor;
    private PropertyProcessor processorURI;
    private PropertyProcessor processorEmbed;
    private PropertyProcessor processorExpr;

    public ReferencePage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.setLayout((Layout)WidgetUtil.createGridLayout(2));
        Label sourceLab = new Label((Composite)this, 0);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        sourceLab.setLayoutData((Object)data);
        this.processorEmbed = new PropertyProcessor("Image", "imageName");
        this.processorURI = new PropertyProcessor("Image", "uri");
        this.processorExpr = new PropertyProcessor("Image", "valueExpr");
        sourceLab.setText(Messages.getString((String)"ReferencePage.Label.Source"));
        this.text = new Text((Composite)this, 2056);
        data = new GridData();
        data.widthHint = 400;
        this.text.setLayoutData((Object)data);
        this.button = new Button((Composite)this, 8);
        this.button.setText(Messages.getString((String)"ReferencePage.Button.Edit"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
                ImageBuilder dialog = new ImageBuilder(ReferencePage.this.button.getShell(), ImageBuilder.DLG_TITLE_EDIT);
                dialog.setInput(ReferencePage.this.input.get(0));
                stack.startTrans(Messages.getString((String)"ImageEditPart.trans.editImage"));
                if (0 == dialog.open()) {
                    stack.commit();
                } else {
                    stack.rollback();
                }
            }
        });
    }

    protected void refreshValues(Set propertiesSet) {
        String source = ((ImageHandle)this.input.get(0)).getSource();
        this.processor = source.equals("embed") ? this.processorEmbed : (source.equals("expr") ? this.processorExpr : this.processorURI);
        String value = this.processor.getStringValue(this.input);
        this.button.setEnabled(value != null);
        this.text.setText(value == null ? "" : value);
    }
}

