/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.ModulePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.ui.dialogs.ThumbnailBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ReportPage
extends ModulePage {
    public ReportPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        super.buildUI();
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "ReportDesign", "layoutPreference", 3, 480);
        WidgetUtil.createGridPlaceholder(this, 1, true);
        WidgetUtil.buildGridControl((Composite)this, (Map)this.propertiesMap, "ReportDesign", "iconFile", 1, 330);
        final Text prvImageText = (Text)((IPropertyDescriptor)this.propertiesMap.get("iconFile")).getControl();
        Button thumbnail = new Button((Composite)this, 8);
        thumbnail.setText("...");
        GridData data = new GridData();
        data.widthHint = Math.max(thumbnail.computeSize((int)-1, (int)-1).x, 60);
        data.horizontalAlignment = 3;
        thumbnail.setLayoutData((Object)data);
        thumbnail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ThumbnailBuilder dialog = new ThumbnailBuilder();
                dialog.setImageName(prvImageText.getText());
                ReportDesignHandle handle = (ReportDesignHandle)SessionHandleAdapter.getInstance().getReportDesignHandle();
                dialog.setReportDesignHandle(handle);
                if (dialog.open() != 0) {
                    Image image = dialog.getImage();
                    if (image != null) {
                        image.dispose();
                        image = null;
                    }
                    return;
                }
                if (dialog.shouldSetThumbnail()) {
                    Image image = dialog.getImage();
                    ImageData imageData = image.getImageData();
                    ImageLoader imageLoader = new ImageLoader();
                    imageLoader.data = new ImageData[1];
                    imageLoader.data[0] = imageData;
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    imageLoader.save((OutputStream)outputStream, 0);
                    try {
                        handle.setThumbnail(outputStream.toByteArray());
                    }
                    catch (SemanticException e1) {
                        ExceptionHandler.handle(e1);
                    }
                    if (image != null) {
                        image.dispose();
                        image = null;
                    }
                    prvImageText.setText(dialog.getImageName());
                    prvImageText.setFocus();
                } else {
                    if (handle.getThumbnail() != null && handle.getThumbnail().length != 0) {
                        try {
                            handle.deleteThumbnail();
                        }
                        catch (SemanticException e1) {
                            ExceptionHandler.handle(e1);
                        }
                    }
                    prvImageText.setText("");
                    prvImageText.setFocus();
                }
            }
        });
    }
}

