/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.page;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.AttributePage;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ExpressionComposite;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GroupElementFactory;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class VisibilityPage
extends AttributePage {
    private static final String All_Title = Messages.getString((String)"VisibilityPage.Label.DetailAll");
    private static final String Spec_Title = Messages.getString((String)"VisibilityPage.Label.DetailSpecific");
    Button hideCheckbox;
    Button allRadio;
    Button specRadio;
    Group group;
    Composite allContainer;
    Composite specContainer;
    ExpressionComposite allExpression;
    HashMap specExpressions;
    HashMap specCheckButtons;
    SelectionListener listener;
    String[] typeInfo;

    public VisibilityPage(Composite parent, int style) {
        super(parent, style);
    }

    protected void buildUI() {
        this.listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VisibilityPage.this.setOutputEnable(VisibilityPage.this.hideCheckbox.getSelection());
                if (VisibilityPage.this.hideCheckbox.getSelection()) {
                    VisibilityPage.this.saveHideInfo();
                } else {
                    Iterator iter = VisibilityPage.this.input.iterator();
                    while (iter.hasNext()) {
                        DesignElementHandle handle = (DesignElementHandle)iter.next();
                        VisibilityPage.this.clearProperty(handle);
                    }
                }
            }
        };
        this.setLayout((Layout)WidgetUtil.createGridLayout(4));
        this.hideCheckbox = new Button((Composite)this, 32);
        this.hideCheckbox.setText(Messages.getString((String)"VisibilityPage.Check.HideElement"));
        GridData data = new GridData();
        data.verticalAlignment = 1;
        this.hideCheckbox.setLayoutData((Object)data);
        this.hideCheckbox.addSelectionListener(this.listener);
        WidgetUtil.createGridPlaceholder(this, 3, true);
        WidgetUtil.createHorizontalLine(this, 4);
        this.allRadio = new Button((Composite)this, 16);
        this.allRadio.setText(Messages.getString((String)"VisibilityPage.Radio.AllOutputs"));
        this.allRadio.addSelectionListener(this.listener);
        WidgetUtil.createGridPlaceholder(this, 3, true);
        this.specRadio = new Button((Composite)this, 16);
        this.specRadio.setText(Messages.getString((String)"VisibilityPage.Radio.SpecificOutputs"));
        WidgetUtil.createGridPlaceholder(this, 3, true);
        this.group = new Group((Composite)this, 0);
        this.group.setLayout((Layout)new StackLayout());
        data = new GridData();
        data.verticalSpan = 4;
        data.verticalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.group.setLayoutData((Object)data);
        this.allContainer = this.buildUIForAlloutput((Composite)this.group);
        this.specContainer = this.buildUIForSpecific((Composite)this.group);
        this.allRadio.setSelection(true);
        this.allContainer.setVisible(false);
        this.specContainer.setVisible(false);
        this.setOutputInfo();
    }

    private Composite buildUIForAlloutput(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(Messages.getString((String)"VisibilityPage.Label.Expression"));
        this.allExpression = new ExpressionComposite(container);
        this.allExpression.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                VisibilityPage.this.saveHideInfo();
            }
        });
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.allExpression.setLayoutData(data);
        return container;
    }

    private Composite buildUIForSpecific(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        container.setLayout((Layout)layout);
        ReportEngine engine = new ReportEngine(new EngineConfig());
        this.typeInfo = engine.getSupportedFormats();
        this.specCheckButtons = new HashMap();
        this.specExpressions = new HashMap();
        for (int i = 0; i < this.typeInfo.length; ++i) {
            Button btn = new Button(container, 32);
            btn.setText(this.typeInfo[i]);
            btn.setSelection(false);
            Label label = new Label(container, 0);
            label.setText(Messages.getString((String)"VisibilityPage.Label.Expression"));
            ExpressionComposite expression = new ExpressionComposite(container);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 4;
            expression.setLayoutData(data);
            this.specCheckButtons.put(this.typeInfo[i], btn);
            this.specExpressions.put(this.typeInfo[i], expression);
            btn.addSelectionListener(this.listener);
            expression.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    VisibilityPage.this.saveHideInfo();
                }
            });
        }
        return container;
    }

    public void setInput(List elements) {
        this.resetUI();
        super.setInput(elements);
    }

    private void setExpressionProvider(DesignElementHandle handle) {
        ExpressionProvider provider = new ExpressionProvider(handle);
        this.allExpression.setExpressionProvider(provider);
        for (int i = 0; i < this.typeInfo.length; ++i) {
            ((ExpressionComposite)((Object)this.specExpressions.get(this.typeInfo[i]))).setExpressionProvider(provider);
        }
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        this.refreshValues(null);
    }

    protected void refreshValues(Set propertiesSet) {
        if (this.shareSameVisibility(this.input)) {
            this.doLoad(this.getFirstElementHandle());
        } else {
            this.doLoad(null);
        }
    }

    private void doLoad(DesignElementHandle itemHandle) {
        this.setExpressionProvider(itemHandle);
        this.hideCheckbox.setEnabled(true);
        if (itemHandle == null) {
            this.hideCheckbox.setSelection(false);
            this.setOutputEnable(false);
            return;
        }
        Iterator visibilities = this.visibilityRulesIterator(itemHandle);
        this.hideCheckbox.setSelection(visibilities != null && visibilities.hasNext());
        this.setOutputEnable(this.hideCheckbox.getSelection());
        if (visibilities == null) {
            return;
        }
        while (visibilities.hasNext()) {
            HideRuleHandle ruleHandle = (HideRuleHandle)visibilities.next();
            String format = ruleHandle.getFormat();
            String expression = ruleHandle.getExpression();
            if (expression == null) {
                expression = "";
            }
            if ("all".equalsIgnoreCase(format)) {
                this.allRadio.setSelection(true);
                this.allExpression.setText(expression);
                this.specRadio.setSelection(false);
                break;
            }
            this.allRadio.setSelection(false);
            this.specRadio.setSelection(true);
            if (this.specCheckButtons.containsKey(format)) {
                ((Button)this.specCheckButtons.get(format)).setSelection(true);
            }
            if (!this.specExpressions.containsKey(format)) continue;
            ((ExpressionComposite)((Object)this.specExpressions.get(format))).setText(expression);
        }
        for (int i = 0; i < this.typeInfo.length; ++i) {
            ExpressionComposite expr = (ExpressionComposite)((Object)this.specExpressions.get(this.typeInfo[i]));
            Button check = (Button)this.specCheckButtons.get(this.typeInfo[i]);
            expr.setEnabled(check.getEnabled() && check.getSelection());
        }
        this.setOutputInfo();
    }

    private boolean shareSameVisibility(List input) {
        return GroupElementFactory.newGroupElement((ModuleHandle)SessionHandleAdapter.getInstance().getReportDesignHandle(), (List)input).shareSameValue("visibility");
    }

    private void resetUI() {
        this.allRadio.setSelection(true);
        this.specRadio.setSelection(false);
        this.allContainer.setVisible(false);
        this.specContainer.setVisible(false);
        this.setOutputInfo();
        for (int i = 0; i < this.typeInfo.length; ++i) {
            ((Button)this.specCheckButtons.get(this.typeInfo[i])).setSelection(false);
            ((ExpressionComposite)((Object)this.specExpressions.get(this.typeInfo[i]))).setText("true");
        }
        this.allExpression.setText("true");
    }

    private void setOutputEnable(boolean enable) {
        int i;
        this.allRadio.setEnabled(enable);
        this.specRadio.setEnabled(enable);
        this.group.setEnabled(enable);
        Composite container = this.allContainer.isVisible() ? this.allContainer : this.specContainer;
        Control[] children = container.getChildren();
        for (i = 0; i < children.length; ++i) {
            children[i].setEnabled(enable);
        }
        for (i = 0; i < this.typeInfo.length; ++i) {
            ((ExpressionComposite)((Object)this.specExpressions.get(this.typeInfo[i]))).setEnabled(((Button)this.specCheckButtons.get(this.typeInfo[i])).getSelection());
        }
    }

    private void setOutputInfo() {
        if (this.allRadio.getSelection() && !this.allContainer.isVisible()) {
            this.group.setText(All_Title);
            ((StackLayout)this.group.getLayout()).topControl = this.allContainer;
            this.group.layout();
        } else if (this.specRadio.getSelection() && !this.specContainer.isVisible()) {
            this.group.setText(Spec_Title);
            ((StackLayout)this.group.getLayout()).topControl = this.specContainer;
            this.group.layout();
        }
    }

    protected void saveHideInfo() {
        this.setOutputInfo();
        CommandStack stack = this.getActionStack();
        stack.startTrans(Messages.getString((String)"VisibilityPage.menu.SaveHides"));
        if (this.allRadio.getSelection()) {
            Iterator iter = this.input.iterator();
            while (iter.hasNext()) {
                DesignElementHandle element = (DesignElementHandle)iter.next();
                Iterator visibilities = this.visibilityRulesIterator(element);
                if (visibilities != null && visibilities.hasNext() && this.getHideRuleHandle(element, "all") == null && !this.clearProperty(element)) {
                    stack.rollback();
                }
                this.updateHideRule(element, "all", true, this.allExpression.getText());
            }
        } else {
            Iterator iter = this.input.iterator();
            while (iter.hasNext()) {
                DesignElementHandle element = (DesignElementHandle)iter.next();
                boolean hideForAll = false;
                for (int i = 0; i < this.typeInfo.length; ++i) {
                    boolean selection = ((Button)this.specCheckButtons.get(this.typeInfo[i])).getSelection();
                    String expression = ((ExpressionComposite)((Object)this.specExpressions.get(this.typeInfo[i]))).getText();
                    if (selection) {
                        hideForAll = true;
                    }
                    if (this.updateHideRule(element, this.typeInfo[i], selection, expression)) continue;
                    stack.rollback();
                }
                if (hideForAll && !this.updateHideRule(element, "all", false, null)) {
                    stack.rollback();
                }
                this.hideCheckbox.setSelection(true);
                this.setOutputEnable(true);
            }
        }
        stack.commit();
    }

    private boolean updateHideRule(DesignElementHandle element, String format, boolean checked, String expression) {
        if (checked) {
            HideRuleHandle hideHandle = this.getHideRuleHandle(element, format);
            if (hideHandle == null) {
                try {
                    hideHandle = this.createHideRuleHandle(element, format, expression);
                }
                catch (SemanticException e) {
                    WidgetUtil.processError(this.getShell(), (Exception)((Object)e));
                    return false;
                }
            } else if (!(expression.equals(hideHandle.getExpression()) || expression.equals("") && hideHandle.getExpression() == null)) {
                hideHandle.setExpression(expression);
            }
        } else {
            Iterator visibilities = this.visibilityRulesIterator(element);
            if (visibilities == null) {
                return true;
            }
            while (visibilities.hasNext()) {
                HideRuleHandle handle = (HideRuleHandle)visibilities.next();
                if (!format.equalsIgnoreCase(handle.getFormat())) continue;
                try {
                    this.getVisibilityPropertyHandle(element).removeItem(handle.getStructure());
                }
                catch (PropertyValueException e) {
                    WidgetUtil.processError(this.getShell(), (Exception)((Object)e));
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private HideRuleHandle getHideRuleHandle(DesignElementHandle handle, String format) {
        Iterator visibilities = this.visibilityRulesIterator(handle);
        if (visibilities == null) {
            return null;
        }
        while (visibilities.hasNext()) {
            HideRuleHandle hideHandle = (HideRuleHandle)visibilities.next();
            if (!format.equalsIgnoreCase(hideHandle.getFormat())) continue;
            return hideHandle;
        }
        return null;
    }

    private HideRuleHandle createHideRuleHandle(DesignElementHandle element, String format, String expression) throws SemanticException {
        PropertyHandle propertyHandle = this.getVisibilityPropertyHandle(element);
        HideRule hide = StructureFactory.createHideRule();
        hide.setFormat(format);
        hide.setExpression(expression);
        propertyHandle.addItem((IStructure)hide);
        return (HideRuleHandle)hide.getHandle((SimpleValueHandle)propertyHandle);
    }

    private boolean clearProperty(DesignElementHandle handle) {
        if (this.visibilityRulesIterator(handle) != null) {
            try {
                if (handle instanceof ReportItemHandle) {
                    handle.clearProperty("visibility");
                } else if (handle instanceof RowHandle) {
                    handle.clearProperty("visibility");
                } else if (handle instanceof ColumnHandle) {
                    handle.clearProperty("visibility");
                }
            }
            catch (SemanticException e) {
                WidgetUtil.processError(this.getShell(), (Exception)((Object)e));
                return false;
            }
        }
        return true;
    }

    private DesignElementHandle getFirstElementHandle() {
        Object obj = this.input.get(0);
        if (obj instanceof ReportItemHandle) {
            return (ReportItemHandle)obj;
        }
        if (obj instanceof RowHandle) {
            return (RowHandle)obj;
        }
        if (obj instanceof ColumnHandle) {
            return (ColumnHandle)obj;
        }
        return null;
    }

    private PropertyHandle getVisibilityPropertyHandle(DesignElementHandle handle) {
        if (handle == null) {
            return null;
        }
        if (handle instanceof ReportItemHandle) {
            return handle.getPropertyHandle("visibility");
        }
        if (handle instanceof RowHandle) {
            return handle.getPropertyHandle("visibility");
        }
        if (handle instanceof ColumnHandle) {
            return handle.getPropertyHandle("visibility");
        }
        return null;
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    private Iterator visibilityRulesIterator(DesignElementHandle handle) {
        Iterator visibilities = null;
        if (handle instanceof ReportItemHandle) {
            visibilities = ((ReportItemHandle)handle).visibilityRulesIterator();
        } else if (handle instanceof RowHandle) {
            visibilities = ((RowHandle)handle).visibilityRulesIterator();
        } else if (handle instanceof ColumnHandle) {
            visibilities = ((ColumnHandle)handle).visibilityRulesIterator();
        }
        return visibilities;
    }
}

