/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FontSizeBuilder
extends Composite {
    protected Combo valueCombo;
    protected Combo unitCombo;
    private IChoiceSet units;
    private IChoiceSet preValues;
    private String fontSizeValue;
    private static final String[] PRE_INT_TABLE = new String[]{"9", "10", "12", "14", "16", "18", "24", "36"};
    private static final String DEFAULT_CHOICE = Messages.getString((String)"FontSizeBuilder.displayname.Auto");
    private String defaultUnit = null;

    public FontSizeBuilder(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)WidgetUtil.createSpaceGridLayout(2, 0));
        ((GridLayout)this.getLayout()).horizontalSpacing = 2;
        this.valueCombo = new Combo((Composite)this, 4);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        this.valueCombo.setLayoutData((Object)data);
        this.unitCombo = new Combo((Composite)this, 12);
        data = new GridData();
        data.widthHint = Platform.getOS().equals("linux") ? 80 : 40;
        data.horizontalAlignment = 128;
        this.unitCombo.setLayoutData((Object)data);
        this.valueCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                FontSizeBuilder.this.valueCombo.notifyListeners(14, null);
            }
        });
        this.valueCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }
        });
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String val = FontSizeBuilder.this.valueCombo.getText();
                FontSizeBuilder.this.unitCombo.setEnabled((FontSizeBuilder.this.isInPreIntTable(val) || !FontSizeBuilder.this.isPredefinedValue(val)) && DEUtil.isValidNumber((String)val));
                if (!FontSizeBuilder.this.unitCombo.isEnabled()) {
                    FontSizeBuilder.this.unitCombo.deselectAll();
                } else if (FontSizeBuilder.this.unitCombo.getSelectionIndex() < 0) {
                    String unit = FontSizeBuilder.this.getDefaultUnit();
                    if (unit != null) {
                        if (!StringUtil.isBlank((String)unit)) {
                            unit = FontSizeBuilder.this.units.findChoice(unit).getDisplayName();
                        }
                        FontSizeBuilder.this.unitCombo.setText(unit);
                    } else {
                        FontSizeBuilder.this.unitCombo.setText(FontSizeBuilder.this.unitCombo.getItem(0));
                    }
                }
            }
        });
        this.unitCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                FontSizeBuilder.this.processAction();
            }
        });
        this.initChoice();
    }

    public void setDefaultUnit(String defaultUnit) {
        this.defaultUnit = defaultUnit;
    }

    private String getDefaultUnit() {
        return this.defaultUnit;
    }

    protected void initChoice() {
        int i;
        this.preValues = ChoiceSetFactory.getElementChoiceSet("Style", "fontSize");
        this.valueCombo.add(DEFAULT_CHOICE);
        for (int i2 = 0; i2 < PRE_INT_TABLE.length; ++i2) {
            this.valueCombo.add(PRE_INT_TABLE[i2]);
        }
        String[] cvs = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.preValues);
        for (i = 0; i < cvs.length; ++i) {
            this.valueCombo.add(cvs[i]);
        }
        this.units = ChoiceSetFactory.getDimensionChoiceSet("Style", "fontSize");
        cvs = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.units);
        for (i = 0; i < cvs.length; ++i) {
            this.unitCombo.add(cvs[i]);
        }
    }

    private boolean isPredefinedValue(String val) {
        if (DEFAULT_CHOICE.equals(val)) {
            return true;
        }
        if (this.isInPreIntTable(val)) {
            return true;
        }
        return this.preValues.findChoiceByDisplayName(val) != null;
    }

    private boolean isPredefinedNameValue(String val) {
        if (DEFAULT_CHOICE.equals(val)) {
            return true;
        }
        if (this.isInPreIntTable(val)) {
            return true;
        }
        return this.preValues.contains(val);
    }

    private boolean isInPreIntTable(String val) {
        if (val == null) {
            return false;
        }
        for (int i = 0; i < PRE_INT_TABLE.length; ++i) {
            if (!PRE_INT_TABLE[i].equals(val)) continue;
            return true;
        }
        return false;
    }

    private String getUnitsValue(String val) {
        IChoice ci = this.units.findChoiceByDisplayName(val);
        if (ci != null) {
            return ci.getName();
        }
        return null;
    }

    protected void processAction() {
        String val = this.valueCombo.getText();
        this.fontSizeValue = val == null || val.length() == 0 || DEFAULT_CHOICE.equals(val) ? null : (this.isPredefinedValue(val) ? (this.isInPreIntTable(val) ? val + DEUtil.resolveNull((String)this.getUnitsValue(this.unitCombo.getText())) : this.preValues.findChoiceByDisplayName(val).getName()) : val + DEUtil.resolveNull((String)this.getUnitsValue(this.unitCombo.getText())));
        this.notifyListeners(24, null);
    }

    public void setFontSizeValue(String size) {
        if (size == null || size.equals(DEFAULT_CHOICE)) {
            this.valueCombo.setText(DEFAULT_CHOICE);
            this.processAction();
            return;
        }
        String[] sp = DEUtil.splitString((String)size);
        if (sp[0] == null && sp[1] == null) {
            this.valueCombo.setText(DEFAULT_CHOICE);
            this.processAction();
            return;
        }
        if (sp[0] == null) {
            if (this.isPredefinedNameValue(sp[1])) {
                if (this.preValues.contains(sp[1])) {
                    this.valueCombo.setText(this.preValues.findChoice(sp[1]).getDisplayName());
                } else {
                    this.valueCombo.setText(sp[1]);
                }
            } else {
                this.valueCombo.setText("");
            }
        } else {
            this.valueCombo.setText(sp[0]);
            if (this.units.contains(sp[1])) {
                this.unitCombo.setText(this.units.findChoice(sp[1]).getDisplayName());
            }
        }
        this.processAction();
    }

    public String getFontSizeValue() {
        return this.fontSizeValue;
    }

    public void setEnabled(boolean enabled) {
        this.valueCombo.setEnabled(enabled);
        if (enabled) {
            String val = this.valueCombo.getText();
            this.unitCombo.setEnabled((this.isInPreIntTable(val) || !this.isPredefinedValue(val)) && DEUtil.isValidNumber((String)val));
        } else {
            this.unitCombo.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        Point pt = super.computeSize(wHint, hHint, changed);
        if (pt.x < 150) {
            pt.x = 150;
        }
        return pt;
    }
}

