/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontSizeBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class FontSizePropertyDescriptor
extends AbstractPropertyDescriptor {
    private FontSizeBuilder builder;
    private boolean processing = false;

    public FontSizePropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        String strValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = strValue == null == this.builder.getEnabled();
        if (stateFlag) {
            this.builder.setEnabled(strValue != null);
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.builder.setEnabled(false);
        }
        this.builder.setFontSizeValue(strValue);
    }

    public Control getControl() {
        return this.builder;
    }

    public Control createControl(Composite parent) {
        this.builder = new FontSizeBuilder(parent, 0);
        this.builder.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (!FontSizePropertyDescriptor.this.processing) {
                    FontSizePropertyDescriptor.this.processing = true;
                    FontSizePropertyDescriptor.this.builder.setDefaultUnit(FontSizePropertyDescriptor.this.getPropertyProcessor().getDefaultUnit(FontSizePropertyDescriptor.this.getModelList()));
                    FontSizePropertyDescriptor.this.processAction();
                    FontSizePropertyDescriptor.this.processing = false;
                }
            }
        });
        return this.builder;
    }

    private void processAction() {
        String oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        String sizeValue = this.builder.getFontSizeValue();
        if (!(sizeValue != null && sizeValue.length() != 0 || oldValue != null && oldValue.length() != 0)) {
            return;
        }
        if (sizeValue != null && sizeValue.equals(oldValue)) {
            return;
        }
        try {
            this.getPropertyProcessor().setStringValue(sizeValue, this.getModelList());
        }
        catch (SemanticException e) {
            WidgetUtil.processError(this.builder.getShell(), (Exception)((Object)e));
            this.builder.setFontSizeValue(oldValue);
            return;
        }
        if (sizeValue == null || sizeValue.length() == 0) {
            String sizeString = this.getPropertyProcessor().getStringValue(this.getModelList());
            this.builder.setFontSizeValue(sizeString);
        }
    }
}

