/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MarignPropertyDescriptor
extends AbstractPropertyDescriptor {
    private static final String ERROR_MESSAGE = Messages.getString((String)"MarignPropertyDescriptor.error.message");
    private static final String ERROR_BOX_TITLE = Messages.getString((String)"MarignPropertyDescriptor.error.title");
    protected Combo valueCombo;
    protected Combo unitCombo;
    protected Composite container;
    protected IChoiceSet unitChoiceSet;
    protected IChoiceSet valueChoiceSet;
    private String deMesurementValue;
    private String deUnitValue;
    private boolean hasError = false;

    public MarignPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public Control createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        this.container.setLayout((Layout)layout);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MarignPropertyDescriptor.this.processAction();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                MarignPropertyDescriptor.this.processAction();
            }
        };
        this.valueCombo = new Combo(this.container, 2048);
        this.valueCombo.addSelectionListener(listener);
        this.valueCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MarignPropertyDescriptor.this.unitCombo.setEnabled(MarignPropertyDescriptor.this.valueCombo.indexOf(MarignPropertyDescriptor.this.valueCombo.getText()) == -1);
                if (MarignPropertyDescriptor.this.unitCombo.isEnabled() && MarignPropertyDescriptor.this.unitCombo.getItemCount() > 0 && (MarignPropertyDescriptor.this.unitCombo.getText() == null || MarignPropertyDescriptor.this.unitCombo.getText().length() == 0)) {
                    String unit = MarignPropertyDescriptor.this.getPropertyProcessor().getDefaultUnit(MarignPropertyDescriptor.this.getModelList());
                    if (unit != null) {
                        if (!StringUtil.isBlank((String)unit)) {
                            unit = MarignPropertyDescriptor.this.getUnitChoiceSet().findChoice(unit).getDisplayName();
                        }
                        MarignPropertyDescriptor.this.unitCombo.setText(unit);
                    } else {
                        MarignPropertyDescriptor.this.unitCombo.setText(MarignPropertyDescriptor.this.unitCombo.getItem(0));
                    }
                }
            }
        });
        this.valueCombo.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (!MarignPropertyDescriptor.this.hasError) {
                    MarignPropertyDescriptor.this.processAction();
                }
            }
        });
        this.unitCombo = new Combo(this.container, 2056);
        this.unitCombo.addSelectionListener(listener);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        this.valueCombo.setLayoutData((Object)data);
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.widthHint = this.valueCombo.getSize().x;
        this.unitCombo.setLayoutData((Object)data);
        return this.container;
    }

    protected boolean validateDimensionValue() {
        if (this.unitCombo.isEnabled() && this.unitCombo.getSelectionIndex() != -1) {
            String value = this.valueCombo.getText();
            String unit = this.getUnitChoiceSet().findChoiceByDisplayName(this.unitCombo.getText()).getName();
            boolean val = true;
            try {
                val = this.getPropertyProcessor().validateDimensionValue(value + unit, this.getModelList());
            }
            catch (PropertyValueException e1) {
                // empty catch block
            }
            return val;
        }
        return true;
    }

    private void processAction() {
        if (!this.validateDimensionValue()) {
            this.setError();
            ExceptionHandler.openErrorMessageBox(ERROR_BOX_TITLE, ERROR_MESSAGE);
            this.resetUIData();
            this.clearError();
            return;
        }
        String value = this.valueCombo.getText();
        if (value.equals("")) {
            value = null;
        } else if (this.valueChoiceSet != null) {
            IChoice ci = this.valueChoiceSet.findChoiceByDisplayName(value);
            if (ci == null) {
                String unit = this.getUnitChoiceSet().findChoiceByDisplayName(this.unitCombo.getText()).getName();
                value = value + unit;
            } else {
                value = ci.getName();
            }
        }
        try {
            this.getPropertyProcessor().setStringValue(value, this.getModelList());
        }
        catch (SemanticException e) {
            this.valueCombo.setText(this.deMesurementValue);
            this.unitCombo.setText(this.deUnitValue);
            WidgetUtil.processError(this.unitCombo.getShell(), (Exception)((Object)e));
        }
    }

    public Control getControl() {
        return this.container;
    }

    public void resetUIData() {
        String[] displayNames;
        boolean stateFlag;
        String value;
        this.deMesurementValue = value = this.getPropertyProcessor().getStringValue(this.getModelList());
        if (value == null) {
            this.valueCombo.deselectAll();
            this.valueCombo.setEnabled(false);
            this.unitCombo.deselectAll();
            this.unitCombo.setEnabled(false);
            return;
        }
        boolean bl = stateFlag = value == null == this.valueCombo.getEnabled();
        if (stateFlag) {
            this.valueCombo.setEnabled(value != null);
            this.unitCombo.setEnabled(value != null);
        }
        if (this.valueChoiceSet == null) {
            this.valueChoiceSet = ChoiceSetFactory.getElementChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.valueChoiceSet);
            this.valueCombo.setItems(displayNames);
        }
        if (this.unitChoiceSet == null) {
            this.unitChoiceSet = ChoiceSetFactory.getDimensionChoiceSet(this.getPropertyProcessor().getElementName(), this.getPropertyProcessor().getProperty());
            displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.unitChoiceSet);
            this.unitCombo.setItems(displayNames);
        }
        IChoice choice = null;
        if (this.valueChoiceSet != null) {
            choice = this.valueChoiceSet.findChoice(value);
        }
        if (choice != null) {
            this.valueCombo.setText(choice.getDisplayName());
            this.deMesurementValue = choice.getDisplayName();
            this.unitCombo.deselectAll();
            this.unitCombo.setEnabled(false);
            return;
        }
        this.deUnitValue = this.getPropertyProcessor().getUnit(this.getModelList());
        if (this.unitChoiceSet != null) {
            choice = this.unitChoiceSet.findChoice(this.deUnitValue);
        }
        if (choice != null) {
            this.unitCombo.setText(choice.getDisplayName());
            this.deUnitValue = choice.getDisplayName();
        }
        this.deMesurementValue = this.getPropertyProcessor().getMeasureValue(this.getModelList());
        this.valueCombo.setText(this.deMesurementValue);
    }

    private void setError() {
        this.hasError = true;
    }

    private void clearError() {
        this.hasError = false;
    }
}

