/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ComboPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class ResourceFileDescriptor
extends ComboPropertyDescriptor {
    private static final String RESOURCE_FILE_EXTENSION = ".properties";
    private static final String[] COUNTRIES = ULocale.getISOCountries();
    private static final String[] LANGUAGES = ULocale.getISOLanguages();

    private static boolean isValidIsoCountry(String cout) {
        if (cout != null) {
            for (int i = 0; i < COUNTRIES.length; ++i) {
                if (!COUNTRIES[i].equalsIgnoreCase(cout)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isValidIsoLanguage(String lang) {
        if (lang != null) {
            for (int i = 0; i < LANGUAGES.length; ++i) {
                if (!LANGUAGES[i].equalsIgnoreCase(lang)) continue;
                return true;
            }
        }
        return false;
    }

    public ResourceFileDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        String fileName = SessionHandleAdapter.getInstance().getReportDesignHandle().getFileName();
        File file = new File(fileName);
        String[] fileNames = file.getParentFile().list(new FilenameFilter(){

            public boolean accept(File arg0, String arg1) {
                return arg1.endsWith(ResourceFileDescriptor.RESOURCE_FILE_EXTENSION);
            }
        });
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < fileNames.length; ++i) {
            String baseName = this.getBaseName(fileNames[i]);
            if (baseName == null || list.contains(baseName)) continue;
            list.add(baseName);
        }
        this.combo.setEnabled(true);
        this.oldValue = this.getPropertyProcessor().getStringValue(this.getModelList());
        if (list.isEmpty()) {
            if (StringUtil.isBlank((String)this.oldValue)) {
                this.combo.setEnabled(false);
            } else {
                this.combo.setText(this.oldValue);
            }
            return;
        }
        if (this.getPropertyProcessor().isReadOnly(this.getModelList())) {
            this.combo.setEnabled(false);
        }
        Collections.sort(list);
        String[] items = new String[list.size() + 1];
        items[0] = ChoiceSetFactory.CHOICE_NONE;
        System.arraycopy(list.toArray(new String[0]), 0, items, 1, list.size());
        this.combo.setItems(items);
        if (!list.contains(this.oldValue)) {
            this.combo.deselectAll();
            if (this.oldValue != null && this.oldValue.length() > 0) {
                this.combo.setText(this.oldValue);
            } else {
                this.combo.select(0);
            }
            return;
        }
        this.combo.select(Arrays.asList(this.combo.getItems()).indexOf(this.oldValue));
    }

    private String getBaseName(String fileName) {
        if (fileName.indexOf(" ") != -1) {
            return null;
        }
        int index = (fileName = fileName.substring(0, fileName.length() - RESOURCE_FILE_EXTENSION.length())).lastIndexOf("_");
        if (index > 0) {
            String suffix = fileName.substring(index + 1);
            int sep = suffix.indexOf("-");
            if (sep != -1) {
                String lang = suffix.substring(0, sep);
                String cout = suffix.substring(sep + 1);
                if (ResourceFileDescriptor.isValidIsoCountry(cout) && ResourceFileDescriptor.isValidIsoLanguage(lang)) {
                    return fileName.substring(0, index);
                }
            } else {
                if (ResourceFileDescriptor.isValidIsoLanguage(suffix)) {
                    return fileName.substring(0, index);
                }
                if (ResourceFileDescriptor.isValidIsoCountry(suffix)) {
                    int sIndex = fileName.lastIndexOf("_", index - 1);
                    if (sIndex == -1) {
                        return fileName.substring(0, index);
                    }
                    String ss = fileName.substring(sIndex + 1, index);
                    if (ResourceFileDescriptor.isValidIsoLanguage(ss)) {
                        return fileName.substring(0, sIndex);
                    }
                    return fileName.substring(0, index);
                }
            }
        }
        return fileName;
    }
}

