/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.IComboProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class StyleComboProvider
implements IComboProvider {
    private static final String LINE_STYLE_NONE;
    private Object[] items;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Object[] getItems() {
        return this.items;
    }

    public void setItems(Object[] items) {
        this.items = items;
    }

    public Image getImage(Object item, int width, int height, Control control, Control parent) {
        if (!$assertionsDisabled && control == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && parent == null) {
            throw new AssertionError();
        }
        Color foreground = parent.getForeground();
        Color background = parent.getBackground();
        Color rectColor = control.getBackground();
        Display display = parent.getDisplay();
        Color shadowColor = display.getSystemColor(18);
        Color hShadowColor = display.getSystemColor(20);
        PaletteData palette = new PaletteData(new RGB[]{foreground.getRGB(), background.getRGB(), shadowColor.getRGB(), hShadowColor.getRGB(), rectColor.getRGB()});
        ImageData imageData = new ImageData(width - 2, height, 8, palette);
        imageData.transparentPixel = 1;
        Image image = new Image((Device)display, imageData);
        GC gc = new GC((Drawable)image);
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(rectColor);
        Rectangle r = image.getBounds();
        gc.setLineWidth(4);
        gc.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        gc.setLineWidth(1);
        gc.setForeground(foreground);
        String key = null;
        if (item instanceof String) {
            key = (String)item;
        } else if (item instanceof IChoice) {
            key = ((IChoice)item).getName();
        }
        if ("none".equals(key)) {
            Point textSize = gc.textExtent(item.toString());
            gc.drawString(LINE_STYLE_NONE, 5, (height - textSize.y) / 2);
        } else if ("double".equals(key)) {
            gc.drawLine(4, height / 2 - 1, width - 4, height / 2 - 1);
            gc.drawLine(4, height / 2 + 1, width - 4, height / 2 + 1);
        } else {
            if ("dotted".equals(key)) {
                gc.setLineStyle(3);
            } else if ("dashed".equals(key)) {
                gc.setLineStyle(2);
            } else if ("solid".equals(key)) {
                gc.setLineStyle(1);
            } else if ("thin".equals(key)) {
                gc.setLineWidth(1);
            } else if ("medium".equals(key)) {
                gc.setLineWidth(2);
            } else if ("thick".equals(key)) {
                gc.setLineWidth(3);
            }
            gc.drawLine(4, height / 2, width - 4, height / 2);
        }
        gc.dispose();
        return image;
    }

    static {
        $assertionsDisabled = !StyleComboProvider.class.desiredAssertionStatus();
        LINE_STYLE_NONE = Messages.getString((String)"StyleComboProvider.LineStyle.None");
    }
}

