/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.AbstractPropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TogglePropertyDescriptor
extends AbstractPropertyDescriptor {
    Button button;
    protected String defaultValue = "";
    protected String toggleValue = "";

    public TogglePropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        String value = this.getPropertyProcessor().getStringValue(this.getModelList());
        boolean bl = stateFlag = value == null == this.button.getEnabled();
        if (stateFlag) {
            this.button.setEnabled(value != null);
        }
        String imageName = this.getPropertyProcessor().getProperty();
        if (!this.button.isEnabled()) {
            imageName = imageName + "DIS";
        }
        this.button.setImage(ReportPlatformUIImages.getImage(imageName));
        boolean boolValue = this.toggleValue.equals(value);
        if (this.button.getSelection() != boolValue) {
            this.button.setSelection(boolValue);
        }
    }

    public void setAllowedValues(String defaultValue, String toggleValue) {
        this.defaultValue = null;
        this.toggleValue = toggleValue;
    }

    public Control getControl() {
        return this.button;
    }

    public Control createControl(Composite parent) {
        this.button = new Button(parent, 2);
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = TogglePropertyDescriptor.this.button.getSelection() ? TogglePropertyDescriptor.this.toggleValue : TogglePropertyDescriptor.this.defaultValue;
                try {
                    TogglePropertyDescriptor.this.getPropertyProcessor().setStringValue(value, TogglePropertyDescriptor.this.getModelList());
                }
                catch (SemanticException e1) {
                    WidgetUtil.processError(TogglePropertyDescriptor.this.button.getShell(), (Exception)((Object)e1));
                }
            }
        });
        if (this.toggleValue.equals("bold")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Bold"));
        }
        if (this.toggleValue.equals("italic")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Italic"));
        }
        if (this.toggleValue.equals("underline")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Underline"));
        }
        if (this.toggleValue.equals("line-through")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Text_Line_Through"));
        }
        if (this.toggleValue.equals("bold")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Bold"));
        }
        if (this.toggleValue.equals("italic")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Italic"));
        }
        if (this.toggleValue.equals("underline")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Underline"));
        }
        if (this.toggleValue.equals("line-through")) {
            this.button.setToolTipText(Messages.getString((String)"TogglePropertyDescriptor.toolTipText.Text_Line_Through"));
        }
        return this.button;
    }
}

