/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public abstract class DataViewPage
extends Page
implements ISelectionProvider,
IColleague {
    private TreeViewer treeViewer;
    private ListenerList selectionChangedListeners = new ListenerList();

    public void createControl(Composite parent) {
        this.treeViewer = this.createTreeViewer(parent);
        this.getTreeViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DataViewPage.this.treeSelect(event);
            }
        });
        this.configTreeViewer();
        this.hookTreeViewer();
        this.initPage();
        SessionHandleAdapter.getInstance().getMediator().addColleague((IColleague)this);
    }

    protected void initPage() {
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    public Control getControl() {
        if (this.treeViewer == null) {
            return null;
        }
        return this.treeViewer.getControl();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void configTreeViewer() {
    }

    protected abstract TreeViewer createTreeViewer(Composite var1);

    protected void hookTreeViewer() {
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void treeSelect(SelectionChangedEvent event) {
        this.fireSelectionChanged(event.getSelection());
    }

    protected void fireSelectionChanged(ISelection selection) {
        final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        ReportRequest request = new ReportRequest((Object)this);
        List list = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            list = ((IStructuredSelection)selection).toList();
        }
        request.setSelectionObject(list);
        request.setType((Object)"selection");
        SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
        Object[] listeners = this.selectionChangedListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer() == null) {
            return StructuredSelection.EMPTY;
        }
        return this.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() != null) {
            this.getTreeViewer().setSelection(selection);
        }
    }

    public void dispose() {
        this.selectionChangedListeners.clear();
        this.treeViewer = null;
        SessionHandleAdapter.getInstance().getMediator().removeColleague((IColleague)this);
        super.dispose();
    }

    public void performRequest(ReportRequest request) {
        if ("selection".equals(request.getType())) {
            this.handleSelectionChange(request);
        }
        if ("create element".equals(request.getType())) {
            this.handleSelectionChange(request);
            if (this.canSetSelection(request.getSelectionModelList())) {
                this.fireSelectionChanged((ISelection)new StructuredSelection(request.getSelectionModelList()));
            }
        }
    }

    protected void handleSelectionChange(ReportRequest request) {
        if (request.getSource() == this) {
            return;
        }
        List list = request.getSelectionModelList();
        if (this.canSetSelection(list)) {
            this.setSelection((ISelection)new StructuredSelection(list));
        }
    }

    private boolean canSetSelection(List list) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!UIUtil.containElement((AbstractTreeViewer)this.getTreeViewer(), element)) continue;
            return true;
        }
        return false;
    }
}

