/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.views.outline.ReportElementModel;
import org.eclipse.birt.report.designer.core.util.mediator.IColleague;
import org.eclipse.birt.report.designer.core.util.mediator.request.IRequestConvert;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.AbstractModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.ReportEventRunnable;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedElementUIPoint;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.views.DesignerOutlineEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.views.NonGEFSynchronizerWithTreeView;
import org.eclipse.birt.report.designer.internal.ui.views.RenameListener;
import org.eclipse.birt.report.designer.internal.ui.views.ViewContextMenuProvider;
import org.eclipse.birt.report.designer.internal.ui.views.ViewsTreeProvider;
import org.eclipse.birt.report.designer.internal.ui.views.actions.GlobalActionFactory;
import org.eclipse.birt.report.designer.internal.ui.views.outline.ItemSorter;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDragListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.DesignerDropListener;
import org.eclipse.birt.report.designer.internal.ui.views.outline.dnd.IDropConstraint;
import org.eclipse.birt.report.designer.ui.views.ProviderFactory;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterGroupHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.command.ContentEvent;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.ValidationEvent;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class DesignerOutlinePage
extends ContentOutlinePage
implements IValidationListener,
AbstractModelEventProcessor.IModelEventFactory {
    private ModuleHandle reportHandle;
    private NonGEFSynchronizerWithTreeView synchronizer;

    public DesignerOutlinePage(ModuleHandle reportHandle) {
        this.reportHandle = reportHandle;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createContextMenu();
        ViewsTreeProvider provider = new ViewsTreeProvider();
        this.getTreeViewer().setContentProvider((IContentProvider)provider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.getSelectionSynchronizer().setTreeViewer((AbstractTreeViewer)this.getTreeViewer());
        new RenameListener(this.getTreeViewer()).apply();
        this.getTreeViewer().setSorter((ViewerSorter)new ItemSorter());
        this.addDragAndDropListener();
        this.init(this.reportHandle);
        this.getTreeViewer().expandToLevel(2);
        final Tree tree = this.getTreeViewer().getTree();
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if ((e.stateMask & 0x40000) != 0 || (e.stateMask & 0x20000) != 0) {
                    this.setSingleSelection(e);
                }
            }

            private void setSingleSelection(MouseEvent e) {
                IStructuredSelection selection = (IStructuredSelection)DesignerOutlinePage.this.getSelection();
                if (!selection.isEmpty() && selection.size() > 1) {
                    boolean includeCell = false;
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        Object obj = iterator.next();
                        if (!(obj instanceof CellHandle)) continue;
                        if (includeCell) {
                            TreeItem item = DesignerOutlinePage.this.getTreeViewer().getTree().getItem(new Point(e.x, e.y));
                            if (item == null) break;
                            DesignerOutlinePage.this.getTreeViewer().getTree().setSelection(new TreeItem[]{item});
                            break;
                        }
                        includeCell = true;
                    }
                }
            }
        });
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                if (DesignerOutlinePage.this.getSelection() instanceof StructuredSelection) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(((StructuredSelection)DesignerOutlinePage.this.getSelection()).getFirstElement());
                    ReportRequest r = new ReportRequest();
                    r.setType((Object)"open editor");
                    r.setRequestConvert(new IRequestConvert(this){
                        private final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public List convertSelectionToModelLisr(List list) {
                            ArrayList<Object> lst = new ArrayList<Object>();
                            Iterator<E> itr = list.iterator();
                            while (itr.hasNext()) {
                                E obj = itr.next();
                                if (obj instanceof ReportElementModel) {
                                    lst.add(((ReportElementModel)obj).getSlotHandle());
                                    continue;
                                }
                                lst.add(obj);
                            }
                            return lst;
                        }
                    });
                    r.setSelectionObject(list);
                    SessionHandleAdapter.getInstance().getMediator().notifyRequest(r);
                }
            }
        });
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                Widget widget = event.widget;
                if (widget == tree) {
                    Point pt = new Point(event.x, event.y);
                    TreeItem item = tree.getItem(pt);
                    if (item == null || item.getData() == null) {
                        tree.setToolTipText(null);
                    } else {
                        tree.setToolTipText(DesignerOutlinePage.this.getTooltip(item.getData()));
                    }
                }
            }
        });
        SessionHandleAdapter.getInstance().getMediator().addColleague((IColleague)this.getSelectionSynchronizer());
    }

    protected void addDragAndDropListener() {
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TemplateTransfer.getInstance()};
        this.getTreeViewer().addDragSupport(ops, transfers, (DragSourceListener)new DesignerDragListener((StructuredViewer)this.getTreeViewer()));
        transfers = new Transfer[]{TemplateTransfer.getInstance()};
        DesignerDropListener dropListener = new DesignerDropListener(this.getTreeViewer());
        dropListener.addDropConstraint(CascadingParameterGroupHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                return -1;
            }
        });
        dropListener.addDropConstraint(ScalarParameterHandle.class, new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle targetParameter;
                if (target instanceof ScalarParameterHandle && (targetParameter = (ScalarParameterHandle)target).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        });
        IDropConstraint cascadingParameterGroupChildrenConstraint = new IDropConstraint(){

            public int validate(Object transfer, Object target) {
                ScalarParameterHandle transferParameter;
                if (transfer instanceof Object[] && ((Object[])transfer).length > 0 && ((Object[])transfer)[0] instanceof ScalarParameterHandle && (transferParameter = (ScalarParameterHandle)((Object[])transfer)[0]).getContainer() instanceof CascadingParameterGroupHandle) {
                    return -1;
                }
                return 0;
            }
        };
        dropListener.addDropConstraint(ScalarParameterHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ParameterGroupHandle.class, cascadingParameterGroupChildrenConstraint);
        dropListener.addDropConstraint(ReportElementModel.class, cascadingParameterGroupChildrenConstraint);
        this.getTreeViewer().addDropSupport(ops, transfers, (DropTargetListener)dropListener);
    }

    public void dispose() {
        this.reportHandle.removeValidationListener((IValidationListener)this);
        SessionHandleAdapter.getInstance().getMediator().removeColleague((IColleague)this.getSelectionSynchronizer());
        super.dispose();
    }

    private void createContextMenu() {
        ViewContextMenuProvider menuManager = new ViewContextMenuProvider((ISelectionProvider)this.getTreeViewer());
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getSite().registerContextMenu("outlinemenu", (MenuManager)menuManager, this.getSite().getSelectionProvider());
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
    }

    public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
        if (this.getTreeViewer().getTree().isDisposed()) {
            return;
        }
        this.getTreeViewer().refresh();
        this.expandNodeAfterCreation(ev);
    }

    protected void expandNodeAfterCreation(NotificationEvent ev) {
        IDesignElement element;
        if (ev instanceof ContentEvent && ev.getEventType() == 0 && (element = ((ContentEvent)ev).getContent()) != null) {
            this.getTreeViewer().expandToLevel((Object)element.getHandle(this.getRoot().getModule()), 0);
        }
    }

    public ModuleHandle getRoot() {
        return this.reportHandle;
    }

    public void setRoot(ModuleHandle reportHandle) {
        reportHandle.removeValidationListener((IValidationListener)this);
        this.reportHandle = reportHandle;
        this.init(reportHandle);
    }

    private void init(ModuleHandle reportHandle) {
        this.setTreeInput(reportHandle);
        reportHandle.addValidationListener((IValidationListener)this);
        this.handleGlobalAction();
    }

    private void setTreeInput(ModuleHandle reportHandle) {
        this.getTreeViewer().setInput((Object)new Object[]{reportHandle});
    }

    public NonGEFSynchronizerWithTreeView getSelectionSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new NonGEFSynchronizerWithTreeView();
            this.synchronizer.setSource(this);
        }
        return this.synchronizer;
    }

    private void handleGlobalAction() {
        String id;
        int i;
        for (i = 0; i < GlobalActionFactory.GLOBAL_SELECTION_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_SELECTION_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, (ISelectionProvider)this));
        }
        for (i = 0; i < GlobalActionFactory.GLOBAL_INSERT_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_INSERT_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, (ISelectionProvider)this));
        }
        for (i = 0; i < GlobalActionFactory.GLOBAL_ELEMENT_ACTIONS.length; ++i) {
            id = GlobalActionFactory.GLOBAL_ELEMENT_ACTIONS[i];
            this.getSite().getActionBars().setGlobalActionHandler(id, GlobalActionFactory.createSelectionAction(id, (ISelectionProvider)this));
        }
        List list = ExtensionPointManager.getInstance().getExtendedElementPoints();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ExtendedElementUIPoint point = (ExtendedElementUIPoint)iter.next();
            String id2 = point.getExtensionName();
            this.getSite().getActionBars().setGlobalActionHandler(id2, GlobalActionFactory.createSelectionAction(id2, (ISelectionProvider)this));
        }
        for (int i2 = 0; i2 < GlobalActionFactory.GLOBAL_STACK_ACTIONS.length; ++i2) {
            String id3 = GlobalActionFactory.GLOBAL_STACK_ACTIONS[i2];
            this.getSite().getActionBars().setGlobalActionHandler(id3, GlobalActionFactory.createStackAction(id3, this.getRoot().getCommandStack()));
        }
        this.getSite().getActionBars().updateActionBars();
    }

    public void performRequest(ReportRequest request) {
    }

    public void elementValidated(DesignElementHandle targetElement, ValidationEvent ev) {
        this.getTreeViewer().refresh();
    }

    private String getTooltip(Object element) {
        return ProviderFactory.createProvider(element).getNodeTooltip(element);
    }

    public IModelEventProcessor getModelProcessor() {
        return new DesignerOutlineEventProcessor(this);
    }

    public Runnable createModelEventRunnable(Object focus, int type, Map args) {
        switch (type) {
            case 0: {
                return new ReportEventRunnable(focus, type, args){

                    public void run() {
                        if (DesignerOutlinePage.this.isDispose()) {
                            return;
                        }
                        DesignerOutlinePage.this.getTreeViewer().refresh();
                        Object obj = this.getArgs().get(DesignerOutlineEventProcessor.EVENT_CONTENT);
                        DesignerOutlinePage.this.expandNodeAfterCreation(obj);
                    }
                };
            }
        }
        return new ReportEventRunnable(focus, type, args){

            public void run() {
                if (DesignerOutlinePage.this.isDispose()) {
                    return;
                }
                DesignerOutlinePage.this.getTreeViewer().refresh();
            }
        };
    }

    protected void expandNodeAfterCreation(Object obj) {
        if (obj instanceof IDesignElement) {
            IDesignElement element = (IDesignElement)obj;
            this.getTreeViewer().expandToLevel((Object)element.getHandle(this.getRoot().getModule()), 0);
        }
    }

    public boolean isDispose() {
        return this.getTreeViewer().getTree().isDisposed();
    }
}

