/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardReportSettingPage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class PublishTemplateWizard
extends Wizard {
    private static final String windowTitle = Messages.getString((String)"PublishTemplateAction.wizard.title");
    private static final String PAGE_TITLE = Messages.getString((String)"PublishTemplateAction.wizard.page.title");
    private static final String PAGE_DESC = Messages.getString((String)"PublishTemplateAction.wizard.page.desc");
    private WizardReportSettingPage page;
    private ReportDesignHandle handle;
    private static final String[] IMAGE_TYPES = new String[]{".bmp", ".jpg", ".jpeg", ".jpe", ".jfif", ".gif", ".png", ".tif", ".tiff", ".ico", ".svg"};

    public PublishTemplateWizard(ReportDesignHandle handle) {
        this.setWindowTitle(windowTitle);
        this.handle = handle;
    }

    public void addPages() {
        this.page = new WizardReportSettingPage(this.handle);
        this.page.setTitle(PAGE_TITLE);
        this.page.setMessage(PAGE_DESC);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        int overwrite;
        block13: {
            File targetFile;
            String templateFolderPath = ReportPlugin.getDefault().getTemplatePreference();
            String filePath = this.handle.getFileName();
            if (!new File(filePath).exists()) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message.SourceFileNotExist"));
                return true;
            }
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            File targetFolder = new File(templateFolderPath);
            if (!targetFolder.isDirectory()) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.notvalidfolder"));
                return true;
            }
            if (!targetFolder.exists()) {
                targetFolder.mkdirs();
            }
            String targetFileName = fileName;
            if (ReportPlugin.getDefault().isReportDesignFile(fileName)) {
                int index = fileName.lastIndexOf(".");
                targetFileName = fileName.substring(0, index) + ".rpttemplate";
            }
            if (new File(filePath).compareTo(targetFile = new File(targetFolder, targetFileName)) == 0) {
                ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message"));
                return true;
            }
            overwrite = 0;
            try {
                if (targetFile.exists()) {
                    String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                    String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                    MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                    overwrite = d.open();
                }
                if (overwrite != 0 || !targetFile.exists() && (targetFile.exists() || !targetFile.createNewFile())) break block13;
                this.copyFile(filePath, targetFile);
                try {
                    this.setDesignFile(targetFile.getAbsolutePath());
                }
                catch (DesignFileException e) {
                    ExceptionHandler.handle(e);
                    return false;
                }
                catch (SemanticException e) {
                    ExceptionHandler.handle(e);
                    return false;
                }
                catch (IOException e) {
                    ExceptionHandler.handle(e);
                    return false;
                }
            }
            catch (IOException e) {
                ExceptionHandler.handle(e);
            }
        }
        if (overwrite == 0 && this.page.getPreviewImagePath() != null && this.page.getPreviewImagePath().trim().length() != 0) {
            this.copyIconFile(this.page.getPreviewImagePath().trim());
        }
        return overwrite != 1;
    }

    private int copyIconFile(String filePath) {
        String templateFolderPath = ReportPlugin.getDefault().getTemplatePreference();
        if (!new File(filePath).exists()) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message.PreviewImageNotExist"));
            return 1;
        }
        String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
        File targetFolder = new File(templateFolderPath);
        String targetFileName = fileName;
        if (!this.checkExtensions(fileName)) {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"PublishTemplateAction.wizard.errorTitle"), Messages.getString((String)"PublishTemplateAction.wizard.message.PreviewImageNotValid"));
            return 1;
        }
        File targetFile = new File(targetFolder, targetFileName);
        if (new File(filePath).compareTo(targetFile) == 0) {
            return 0;
        }
        int overwrite = 0;
        try {
            if (targetFile.exists()) {
                String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
                String question = Messages.getFormattedString((String)"SaveAsDialog.overwriteQuestion", (Object[])new Object[]{targetFile.getAbsolutePath()});
                MessageDialog d = new MessageDialog(this.getShell(), Messages.getString((String)"SaveAsDialog.Question"), null, question, 3, buttons, 0);
                overwrite = d.open();
            }
            if (overwrite == 0 && (targetFile.exists() || !targetFile.exists() && targetFile.createNewFile())) {
                this.copyFile(filePath, targetFile);
            }
        }
        catch (IOException e) {
            ExceptionHandler.handle(e);
        }
        return overwrite;
    }

    private void setDesignFile(String fileName) throws DesignFileException, SemanticException, IOException {
        ReportDesignHandle handle = SessionHandleAdapter.getInstance().getSessionHandle().openDesign(fileName);
        if (!this.page.getDisplayName().equals("")) {
            handle.setDisplayName(this.page.getDisplayName());
        }
        handle.setProperty("description", (Object)this.page.getDescription());
        if (!this.page.getPreviewImagePath().equals("")) {
            String shortName = UIUtil.getSimpleFileName(this.page.getPreviewImagePath());
            handle.setIconFile(shortName);
        } else {
            handle.setIconFile("");
        }
        handle.save();
        handle.close();
    }

    private void copyFile(String in, File targetFile) throws IOException {
        FileInputStream fis = new FileInputStream(in);
        FileOutputStream fos = new FileOutputStream(targetFile);
        byte[] buf = new byte[1024];
        int i = 0;
        while ((i = fis.read(buf)) != -1) {
            fos.write(buf, 0, i);
        }
        fis.close();
        fos.close();
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    private boolean checkExtensions(String fileName) {
        for (int i = 0; i < IMAGE_TYPES.length; ++i) {
            if (!fileName.toLowerCase().endsWith(IMAGE_TYPES[i])) continue;
            return true;
        }
        return false;
    }
}

