/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui;

import com.ibm.icu.util.StringTokenizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.birt.report.designer.core.CorePlugin;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ReportPlugin
extends AbstractUIPlugin {
    private List ignore = new ArrayList();
    public static final String REPORT_UI = "org.eclipse.birt.report.designer.ui";
    private static ReportPlugin plugin;
    private Cursor cellLeftCursor;
    private Cursor cellRightCursor;
    public static final String PREFERENCE_DELIMITER = ";";
    public static final String SPACE = " ";
    public static final String DEFAULT_NAME_PREFERENCE = "designer.preview.preference.elementname.defaultname.preferencestore";
    public static final String CUSTOM_NAME_PREFERENCE = "designer.preview.preference.elementname.customname.preferencestore";
    public static final String DESCRIPTION_PREFERENCE = "designer.preview.preference.elementname.description.preferencestore";
    public static final String LIBRARY_PREFERENCE = "designer.library.preference.libraries.description.preferencestore";
    public static final String TEMPLATE_PREFERENCE = "designer.preview.preference.template.description.preferencestore";
    public static final String RESOURCE_PREFERENCE = "org.eclipse.birt.report.designer.ui.preferences.resourcestore";
    public static final String COMMENT_PREFERENCE = "org.eclipse.birt.report.designer.ui.preference.comment.description.preferencestore";
    public static final String ENABLE_COMMENT_PREFERENCE = "org.eclipse.birt.report.designer.ui.preference.enable.comment.description.preferencestore";
    public static final String BIRT_RESOURCE = "resources";
    private int nameCount = 0;
    private static final List elementToFilte;
    private List reportExtensionNames;

    public ReportPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getPreferenceStore().setDefault("Dock location", 130);
        this.getPreferenceStore().setDefault("Palette state", 2);
        this.initCellCursor();
        this.setDefaultElementNamePreference(this.getPreferenceStore());
        this.setDefaultLibraryPreference();
        this.setDefaultTemplatePreference();
        this.setDefaultResourcePreference();
        this.setDefaultCommentPreference();
        this.setDefaultEnableCommentPreference();
        PlatformUI.getWorkbench().getContextSupport().setKeyFilterEnabled(true);
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.editors.ReportEditor");
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.editors.TemplateEditor");
        this.addIgnoreViewID("org.eclipse.ui.views.ContentOutline");
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.attributes.AttributeView");
        this.addIgnoreViewID("org.eclipse.gef.ui.palette_view");
        this.addIgnoreViewID("org.eclipse.birt.report.designer.ui.views.data.DataView");
        CorePlugin.RESOURCE_FOLDER = this.getResourcePreference();
        SessionHandleAdapter.getInstance().getSessionHandle();
        SessionHandle.setBirtResourcePath((String)this.getResourcePreference());
        SessionHandleAdapter.getInstance().getSessionHandle().setResourceFolder(this.getResourcePreference());
    }

    public static String getVersion() {
        return (String)ReportPlugin.getDefault().getBundle().getHeaders().get("Bundle-Version");
    }

    public static String getBuildInfo() {
        return ReportPlugin.getResourceString("Build");
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = Platform.getResourceBundle((Bundle)ReportPlugin.getDefault().getBundle());
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    private void initCellCursor() {
        ImageData source = ReportPlugin.getImageDescriptor("icons/point/cellcursor.bmp").getImageData();
        ImageData mask = ReportPlugin.getImageDescriptor("icons/point/cellcursormask.bmp").getImageData();
        this.cellLeftCursor = new Cursor(null, source, mask, 16, 16);
        source = ReportPlugin.getImageDescriptor("icons/point/cellrightcursor.bmp").getImageData();
        mask = ReportPlugin.getImageDescriptor("icons/point/cellrightcursormask.bmp").getImageData();
        this.cellRightCursor = new Cursor(null, source, mask, 16, 16);
    }

    public Cursor getLeftCellCursor() {
        return this.cellLeftCursor;
    }

    public Cursor getRightCellCursor() {
        return this.cellRightCursor;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.cellLeftCursor.dispose();
    }

    public static ReportPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        ImageRegistry imageRegistry = ReportPlugin.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key);
        if (imageDescriptor == null) {
            URL url = ReportPlugin.getDefault().find((IPath)new Path(key));
            if (null != url) {
                imageDescriptor = ImageDescriptor.createFromURL((URL)url);
            }
            if (imageDescriptor == null) {
                imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            }
            imageRegistry.put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public static Image getImage(String key) {
        ImageRegistry imageRegistry = ReportPlugin.getDefault().getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            URL url = ReportPlugin.getDefault().find((IPath)new Path(key));
            if (url == null) {
                try {
                    url = new URL("file:///" + key);
                }
                catch (MalformedURLException e) {
                    // empty catch block
                }
            }
            if (null != url) {
                image = ImageDescriptor.createFromURL((URL)url).createImage();
            }
            if (image == null) {
                image = ImageDescriptor.getMissingImageDescriptor().createImage();
            }
            imageRegistry.put(key, image);
        }
        return image;
    }

    public static boolean readCheatSheetPreference() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            String property = workspace.getRoot().getPersistentProperty(new QualifiedName("org.eclipse.birt.property", "showCheatSheet"));
            if (property != null) {
                return Boolean.valueOf(property);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void writeCheatSheetPreference(boolean value) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        try {
            workspace.getRoot().setPersistentProperty(new QualifiedName("org.eclipse.birt.property", "showCheatSheet"), String.valueOf(value));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void setDefaultElementNamePreference(IPreferenceStore store) {
        List tmpList = DesignEngine.getMetaDataDictionary().getElements();
        StringBuffer bufferDefaultName = new StringBuffer();
        StringBuffer bufferCustomName = new StringBuffer();
        StringBuffer bufferPreference = new StringBuffer();
        for (int i = 0; i < tmpList.size(); ++i) {
            IElementDefn elementDefn = (IElementDefn)tmpList.get(i);
            int nameOption = elementDefn.getNameOption();
            if (nameOption == 0 || this.filteName(elementDefn)) continue;
            ++this.nameCount;
            bufferDefaultName.append(elementDefn.getName());
            bufferDefaultName.append(PREFERENCE_DELIMITER);
            bufferCustomName.append("");
            bufferCustomName.append(PREFERENCE_DELIMITER);
            this.appendDefaultPreference(elementDefn.getName(), bufferPreference);
        }
        store.setDefault(DEFAULT_NAME_PREFERENCE, bufferDefaultName.toString());
        store.setDefault(CUSTOM_NAME_PREFERENCE, bufferCustomName.toString());
        store.setDefault(DESCRIPTION_PREFERENCE, bufferPreference.toString());
    }

    private boolean filteName(IElementDefn elementDefn) {
        return elementToFilte.indexOf(elementDefn.getName()) != -1;
    }

    private void appendDefaultPreference(String defaultName, StringBuffer preference) {
        if (defaultName.equals("Data")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.dataReportItem"));
        } else if (defaultName.equals("Grid")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.gridReportItem"));
        } else if (defaultName.equals("Image")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.imageReportItem"));
        } else if (defaultName.equals("Label")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.labelReportItem"));
        } else if (defaultName.equals("List")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.listReportItem"));
        } else if (defaultName.equals("Table")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.tableReportItem"));
        } else if (defaultName.equals("Text")) {
            preference.append(Messages.getString((String)"DesignerPaletteFactory.toolTip.textReportItem"));
        } else if (defaultName.equalsIgnoreCase("Chart")) {
            preference.append("Insert chart");
        } else {
            preference.append("");
        }
        preference.append(PREFERENCE_DELIMITER);
    }

    public String[] getDefaultDefaultNamePreference() {
        return this.convert(this.getPreferenceStore().getDefaultString(DEFAULT_NAME_PREFERENCE));
    }

    public String[] getDefaultCustomNamePreference() {
        return this.convert(this.getPreferenceStore().getDefaultString(CUSTOM_NAME_PREFERENCE));
    }

    public String[] getDefaultDescriptionPreference() {
        return this.convert(this.getPreferenceStore().getDefaultString(DESCRIPTION_PREFERENCE));
    }

    public String[] getDefaultNamePreference() {
        return this.convert(this.getPreferenceStore().getString(DEFAULT_NAME_PREFERENCE));
    }

    public String[] getCustomNamePreference() {
        return this.convert(this.getPreferenceStore().getString(CUSTOM_NAME_PREFERENCE));
    }

    public String[] getDescriptionPreference() {
        return this.convert(this.getPreferenceStore().getString(DESCRIPTION_PREFERENCE));
    }

    public String getCustomName(String defaultName) {
        String[] customNameArray;
        String[] defaultNameArray = this.getDefaultNamePreference();
        if (defaultNameArray.length != (customNameArray = this.getCustomNamePreference()).length) {
            return null;
        }
        for (int i = 0; i < defaultNameArray.length; ++i) {
            if (!defaultNameArray[i].trim().equals(defaultName)) continue;
            if (customNameArray[i].equals("")) {
                return null;
            }
            return new String(customNameArray[i]);
        }
        return null;
    }

    private String[] convert(String preferenceValue) {
        String preferenceValueCopy = new String();
        preferenceValueCopy = new String(PREFERENCE_DELIMITER) + preferenceValue;
        String replaceString = new String(PREFERENCE_DELIMITER) + new String(PREFERENCE_DELIMITER);
        String regrex = new String(PREFERENCE_DELIMITER) + SPACE + new String(PREFERENCE_DELIMITER);
        while (preferenceValueCopy.indexOf(replaceString) != -1) {
            preferenceValueCopy = preferenceValueCopy.replaceFirst(replaceString, regrex);
        }
        StringTokenizer tokenizer = new StringTokenizer(preferenceValueCopy, PREFERENCE_DELIMITER);
        int tokenCount = tokenizer.countTokens();
        String[] elements = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            elements[i] = tokenizer.nextToken().trim();
        }
        return elements;
    }

    public String convertStrArray2Str(String[] elements) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i]);
            buffer.append(PREFERENCE_DELIMITER);
        }
        return buffer.toString();
    }

    public void setDefaultNamePreference(String[] elements) {
        this.getPreferenceStore().setValue(DEFAULT_NAME_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setDefaultNamePreference(String element) {
        this.getPreferenceStore().setValue(DEFAULT_NAME_PREFERENCE, element);
    }

    public void setCustomNamePreference(String[] elements) {
        this.getPreferenceStore().setValue(CUSTOM_NAME_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setCustomNamePreference(String element) {
        this.getPreferenceStore().setValue(CUSTOM_NAME_PREFERENCE, element);
    }

    public void setDescriptionPreference(String[] elements) {
        this.getPreferenceStore().setValue(DESCRIPTION_PREFERENCE, this.convertStrArray2Str(elements));
    }

    public void setDescriptionPreference(String element) {
        this.getPreferenceStore().setValue(DESCRIPTION_PREFERENCE, element);
    }

    public int getCount() {
        return this.nameCount;
    }

    public void setLibraryPreference(String[] elements) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < elements.length; ++i) {
            buffer.append(elements[i]);
            buffer.append(PREFERENCE_DELIMITER);
        }
        this.getPreferenceStore().setValue(LIBRARY_PREFERENCE, buffer.toString());
    }

    public String[] getLibraryPreference() {
        return this.convert(this.getPreferenceStore().getString(LIBRARY_PREFERENCE));
    }

    public void setDefaultLibraryPreference() {
        this.getPreferenceStore().setDefault(LIBRARY_PREFERENCE, "");
    }

    public String[] getDefaultLibraryPreference() {
        return this.convert(this.getPreferenceStore().getDefaultString(LIBRARY_PREFERENCE));
    }

    public String getDefaultTemplatePreference() {
        return this.getPreferenceStore().getDefaultString(TEMPLATE_PREFERENCE);
    }

    public void setDefaultTemplatePreference() {
        String defaultDir = new String(UIUtil.getHomeDirectory());
        this.getPreferenceStore().setDefault(TEMPLATE_PREFERENCE, defaultDir);
    }

    public String getTemplatePreference() {
        return this.getPreferenceStore().getString(TEMPLATE_PREFERENCE);
    }

    public void setTemplatePreference(String preference) {
        this.getPreferenceStore().setValue(TEMPLATE_PREFERENCE, preference);
    }

    public void setDefaultResourcePreference() {
        this.getPreferenceStore().setDefault(RESOURCE_PREFERENCE, "");
    }

    public String getDefaultResourcePreference() {
        return this.getPreferenceStore().getDefaultString(RESOURCE_PREFERENCE);
    }

    public String getResourcePreference() {
        return this.getPreferenceStore().getString(RESOURCE_PREFERENCE);
    }

    public void setResourcePreference(String preference) {
        this.getPreferenceStore().setValue(RESOURCE_PREFERENCE, preference);
        CorePlugin.RESOURCE_FOLDER = preference;
    }

    public void addIgnoreViewID(String str) {
        this.ignore.add(str);
    }

    public void removeIgnoreViewID(String str) {
        this.ignore.remove(str);
    }

    public boolean containIgnoreViewID(String str) {
        return this.ignore.contains(str);
    }

    public void setDefaultCommentPreference() {
        this.getPreferenceStore().setDefault(COMMENT_PREFERENCE, Messages.getString((String)"org.eclipse.birt.report.designer.ui.preference.commenttemplates.defaultcomment"));
    }

    public String getDefaultCommentPreference() {
        return this.getPreferenceStore().getDefaultString(COMMENT_PREFERENCE);
    }

    public String getCommentPreference() {
        return this.getPreferenceStore().getString(COMMENT_PREFERENCE);
    }

    public void setCommentPreference(String preference) {
        this.getPreferenceStore().setValue(COMMENT_PREFERENCE, preference);
    }

    public void setDefaultEnableCommentPreference() {
        this.getPreferenceStore().setDefault(ENABLE_COMMENT_PREFERENCE, true);
    }

    public boolean getDefaultEnabelCommentPreference() {
        return this.getPreferenceStore().getDefaultBoolean(ENABLE_COMMENT_PREFERENCE);
    }

    public boolean getEnableCommentPreference() {
        return this.getPreferenceStore().getBoolean(ENABLE_COMMENT_PREFERENCE);
    }

    public void setEnableCommentPreference(boolean preference) {
        this.getPreferenceStore().setValue(ENABLE_COMMENT_PREFERENCE, preference);
    }

    public List getReportExtensionNameList() {
        if (this.reportExtensionNames == null) {
            this.reportExtensionNames = new ArrayList();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.ui.editors");
            for (int i = 0; i < elements.length; ++i) {
                String id = elements[i].getAttribute("id");
                if (!"org.eclipse.birt.report.designer.ui.editors.ReportEditor".equals(id)) continue;
                String[] extensionNames = elements[i].getAttribute("extensions").split(",");
                for (int j = 0; j < extensionNames.length; ++j) {
                    extensionNames[j] = extensionNames[j].trim();
                    if (this.reportExtensionNames.contains(extensionNames[j])) continue;
                    this.reportExtensionNames.add(extensionNames[j]);
                }
            }
        }
        return this.reportExtensionNames;
    }

    public boolean isReportDesignFile(String filename) {
        if (filename != null) {
            Iterator iter = ReportPlugin.getDefault().getReportExtensionNameList().iterator();
            while (iter.hasNext()) {
                if (!filename.endsWith("." + (String)iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public String getResourceFolder() {
        String resourceFolder = SessionHandleAdapter.getInstance().getSessionHandle().getResourceFolder();
        if ((resourceFolder == null || resourceFolder.equals("")) && SessionHandleAdapter.getInstance().getReportDesignHandle() != null && SessionHandleAdapter.getInstance().getReportDesignHandle().getResourceFolder() != null) {
            resourceFolder = SessionHandleAdapter.getInstance().getReportDesignHandle().getResourceFolder();
        }
        return resourceFolder;
    }

    static {
        elementToFilte = Arrays.asList("AutoText", "DataSet", "DataSource", "ExtendedItem", "FreeForm", "GraphicMasterPage", "JointDataSet", "Line", "MasterPage", "OdaDataSet", "OdaDataSource", "Parameter", "Rectangle", "ReportItem", "ScriptDataSet", "ScriptDataSource", "SimpleDataSet", "TemplateDataSet", "TemplateElement", "TemplateParameterDefinition");
    }
}

