/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.core.util.mediator.request.ReportRequest;
import org.eclipse.birt.report.designer.data.ui.dataset.DataSetEditor;
import org.eclipse.birt.report.designer.data.ui.dataset.JointDataSetWizard;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewJointDataSetAction
extends Action {
    public static final String ID = "org.eclipse.birt.report.designer.ui.actions.NewJointDataSetAction";
    private DataSetHandle dataSetHandle;

    public NewJointDataSetAction() {
        this.setId(ID);
    }

    public NewJointDataSetAction(String text) {
        super(text);
        this.setId(ID);
    }

    public NewJointDataSetAction(String text, int style) {
        super(text, style);
        this.setId(ID);
    }

    public NewJointDataSetAction(String text, ImageDescriptor image) {
        super(text, image);
        this.setId(ID);
    }

    public void run() {
        List existingDataSets;
        if (Policy.TRACING_ACTIONS) {
            System.out.println("New joint data set action >> Run ...");
        }
        if ((existingDataSets = this.getDataSets()).isEmpty()) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString((String)"JointDataSetPage.error.nodataset.title"), (String)Messages.getString((String)"JointDataSetPage.error.nodataset.title"));
            this.notifyResult(false);
        } else {
            HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().startPersistentTrans(Messages.getString((String)"dataset.message.create"));
            JointDataSetWizard wizard = new JointDataSetWizard();
            wizard.setWindowTitle(Messages.getString((String)"dataset.new"));
            WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                List newDataSets = this.getDataSets();
                this.editDataSet(existingDataSets, newDataSets);
                HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().commit();
                ReportRequest request = new ReportRequest("create element");
                ArrayList<DataSetHandle> selectionObjects = new ArrayList<DataSetHandle>();
                selectionObjects.add(this.dataSetHandle);
                request.setSelectionObject(selectionObjects);
                SessionHandleAdapter.getInstance().getMediator().notifyRequest(request);
                this.notifyResult(true);
            } else {
                HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getCommandStack().rollback();
                this.notifyResult(false);
            }
        }
    }

    private List getDataSets() {
        List dataSets = HandleAdapterFactory.getInstance().getReportDesignHandleAdapter().getModuleHandle().getVisibleDataSets();
        return dataSets;
    }

    private boolean editDataSet(List existingDataSets, List newDataSets) {
        if (existingDataSets == null || newDataSets == null) {
            return false;
        }
        if (newDataSets.size() <= existingDataSets.size()) {
            return false;
        }
        this.dataSetHandle = this.findNewDataSet(existingDataSets, newDataSets);
        if (this.dataSetHandle == null) {
            return false;
        }
        if (this.dataSetHandle instanceof ScriptDataSetHandle) {
            return false;
        }
        DataSetEditor dialog = new DataSetEditor(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.dataSetHandle, false);
        return dialog.open() == 0;
    }

    private DataSetHandle findNewDataSet(List existingDataSets, List newDataSets) {
        for (int i = 0; i < newDataSets.size(); ++i) {
            if (existingDataSets.contains(newDataSets.get(i))) continue;
            return (DataSetHandle)newDataSets.get(i);
        }
        return null;
    }
}

