/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PopupSelectionList;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class FilterConditionBuilder
extends BaseDialog {
    public static final String DLG_TITLE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    private transient String[] popupItems = null;
    private static String[] actions = new String[]{Messages.getString((String)"ExpressionValueCellEditor.selectValueAction"), Messages.getString((String)"ExpressionValueCellEditor.buildExpressionAction")};
    static final String[][] OPERATOR;
    private transient String bindingName;
    private ParamBindingHandle[] bindingParams = null;
    private transient boolean refreshItems = true;
    private transient ReportElementHandle currentItem = null;
    private static String[] EMPTY_ARRAY;
    private List columnList;
    private static final String[] EMPTY;
    private FilterConditionHandle inputHandle;
    private Combo expression;
    private Combo operator;
    private Button valBuilder1;
    private Button valBuilder2;
    private Text value1;
    private Text value2;
    private Label andLable;
    private DesignElementHandle designHandle;
    private static final String VALUE_OF_THIS_DATA_ITEM;
    private Listener ComboModify = new Listener(){

        public void handleEvent(Event e) {
            Assert.isLegal((boolean)(e.widget instanceof Combo));
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            String value = DEUtil.getExpression((Object)FilterConditionBuilder.this.getResultSetColumn(newValue));
            if (value != null) {
                newValue = value;
            }
            combo.setText(newValue);
            FilterConditionBuilder.this.updateButtons();
        }
    };

    public void setReportElement(ReportElementHandle reportItem) {
        this.currentItem = reportItem;
    }

    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public void setBindingParams(ParamBindingHandle[] params) {
        this.bindingParams = params;
    }

    public FilterConditionBuilder(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public FilterConditionBuilder(Shell parentShell, String title) {
        super(parentShell, title);
    }

    public static String getValueForOperator(String name) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][0].equals(name)) continue;
            return OPERATOR[i][1];
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return OPERATOR[i][0];
        }
        return "";
    }

    static int getIndexForOperatorValue(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return i;
        }
        return 0;
    }

    public FilterConditionBuilder(Shell parentShell, String title, FilterHandleProvider provider) {
        super(parentShell, title);
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
        }
        return values;
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditFilterCondition_ID");
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        FilterConditionBuilder.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        Label lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"FilterConditionBuilder.text.Condition"));
        Composite condition = new Composite(innerParent, 0);
        condition.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout(4, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        this.expression.setLayoutData((Object)gdata);
        this.expression.addListener(13, this.ComboModify);
        this.expression.setItems(this.getDataSetColumns());
        if (this.expression.getItemCount() == 0) {
            this.expression.add(DEUtil.resolveNull(null));
        }
        this.expression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilterConditionBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && FilterConditionBuilder.this.designHandle instanceof DataItemHandle) {
                    FilterConditionBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)FilterConditionBuilder.this.designHandle).getResultSetColumn()));
                }
                FilterConditionBuilder.this.updateButtons();
            }
        });
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FilterConditionBuilder.this.updateButtons();
            }
        });
        Button expBuilder = new Button(condition, 8);
        expBuilder.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        expBuilder.setLayoutData((Object)gdata);
        expBuilder.setToolTipText(Messages.getString((String)"FilterConditionBuilder.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterConditionBuilder.this.editValue((Control)FilterConditionBuilder.this.expression);
            }
        });
        this.operator = new Combo(condition, 8);
        for (int i = 0; i < OPERATOR.length; ++i) {
            this.operator.add(OPERATOR[i][0]);
        }
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = FilterConditionBuilder.getValueForOperator(FilterConditionBuilder.this.operator.getText());
                int vv = FilterConditionBuilder.determineValueVisible(value);
                if (vv == 0) {
                    FilterConditionBuilder.this.value1.setVisible(false);
                    FilterConditionBuilder.this.valBuilder1.setVisible(false);
                    FilterConditionBuilder.this.value2.setVisible(false);
                    FilterConditionBuilder.this.valBuilder2.setVisible(false);
                    FilterConditionBuilder.this.andLable.setVisible(false);
                } else if (vv == 1) {
                    FilterConditionBuilder.this.value1.setVisible(true);
                    FilterConditionBuilder.this.valBuilder1.setVisible(true);
                    FilterConditionBuilder.this.value2.setVisible(false);
                    FilterConditionBuilder.this.valBuilder2.setVisible(false);
                    FilterConditionBuilder.this.andLable.setVisible(false);
                } else if (vv == 2) {
                    FilterConditionBuilder.this.value1.setVisible(true);
                    FilterConditionBuilder.this.valBuilder1.setVisible(true);
                    FilterConditionBuilder.this.value2.setVisible(true);
                    FilterConditionBuilder.this.valBuilder2.setVisible(true);
                    FilterConditionBuilder.this.andLable.setVisible(true);
                }
                FilterConditionBuilder.this.updateButtons();
            }
        });
        ExpressionValue expressionValue1 = new ExpressionValue(condition, 0, this.expression);
        this.value1 = expressionValue1.getValueText();
        this.valBuilder1 = expressionValue1.getPopupButton();
        this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"FilterConditionBuilder.text.AND"));
        this.andLable.setVisible(false);
        this.createDummy(condition, 3);
        ExpressionValue expressionValue2 = new ExpressionValue(condition, 0, this.expression);
        this.value2 = expressionValue2.getValueText();
        this.valBuilder2 = expressionValue2.getPopupButton();
        this.value2.setVisible(false);
        this.valBuilder2.setVisible(false);
        if (this.operator.getItemCount() > 0) {
            this.operator.select(0);
        }
        Composite space = new Composite(innerParent, 0);
        gdata = new GridData(768);
        gdata.heightHint = 15;
        space.setLayoutData((Object)gdata);
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        if (this.inputHandle != null) {
            this.syncViewProperties();
        }
        this.updateButtons();
        return composite;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    public void updateHandle(FilterConditionHandle handle, int handleCount) {
        this.inputHandle = handle;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        this.inilializeColumnList(this.designHandle);
    }

    private void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    public FilterConditionHandle getInputHandle() {
        return this.inputHandle;
    }

    private void updateButtons() {
        this.enableInput(this.isExpressionOK());
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private void enableInput(boolean val) {
        this.operator.setEnabled(val);
        this.value1.setEnabled(val);
        this.value2.setEnabled(val);
        this.valBuilder1.setEnabled(val);
        this.valBuilder2.setEnabled(val);
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.value1.getVisible() && (this.value1.getText() == null || this.value1.getText().trim().length() == 0)) {
            return false;
        }
        return !this.value2.getVisible() || this.value2.getText() != null && this.value2.getText().trim().length() != 0;
    }

    private void syncViewProperties() {
        this.expression.setText(DEUtil.resolveNull((String)this.inputHandle.getExpr()));
        this.operator.select(FilterConditionBuilder.getIndexForOperatorValue(this.inputHandle.getOperator()));
        this.value1.setText(DEUtil.resolveNull((String)this.inputHandle.getValue1()));
        this.value2.setText(DEUtil.resolveNull((String)this.inputHandle.getValue2()));
        int vv = FilterConditionBuilder.determineValueVisible(this.inputHandle.getOperator());
        if (vv == 0) {
            this.value1.setVisible(false);
            this.valBuilder1.setVisible(false);
            this.value2.setVisible(false);
            this.valBuilder2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (vv == 1) {
            this.value1.setVisible(true);
            this.valBuilder1.setVisible(true);
            this.value2.setVisible(false);
            this.valBuilder2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (vv == 2) {
            this.value1.setVisible(true);
            this.valBuilder1.setVisible(true);
            this.value2.setVisible(true);
            this.valBuilder2.setVisible(true);
            this.andLable.setVisible(true);
        }
    }

    protected void okPressed() {
        try {
            if (this.inputHandle == null) {
                FilterCondition filter = StructureFactory.createFilterCond();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                filter.setProperty("value1", (Object)DEUtil.resolveNull((String)this.value1.getText()));
                filter.setProperty("value2", (Object)DEUtil.resolveNull((String)this.value2.getText()));
                filter.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
                PropertyHandle propertyHandle = this.designHandle.getPropertyHandle("filter");
                propertyHandle.addItem((IStructure)filter);
            } else {
                this.inputHandle.setOperator(DEUtil.resolveNull((String)FilterConditionBuilder.getValueForOperator(this.operator.getText())));
                if (this.value1.getVisible()) {
                    this.inputHandle.setValue1(DEUtil.resolveNull((String)this.value1.getText()));
                } else {
                    this.inputHandle.setValue1("");
                }
                if (this.value2.getVisible()) {
                    this.inputHandle.setValue2(DEUtil.resolveNull((String)this.value2.getText()));
                } else {
                    this.inputHandle.setValue2("");
                }
                this.inputHandle.setExpr(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    private void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    public void setInput(Object inputHandle) {
        this.inputHandle = inputHandle instanceof FilterConditionHandle ? (FilterConditionHandle)inputHandle : null;
    }

    private void refreshList() {
        if (this.refreshItems) {
            ArrayList<String> finalItems = new ArrayList<String>(10);
            for (int n = 0; n < actions.length; ++n) {
                finalItems.add(actions[n]);
            }
            if (this.currentItem != null) {
                // empty if block
            }
            this.popupItems = finalItems.toArray(EMPTY_ARRAY);
        }
        this.refreshItems = false;
    }

    private List getSelectValueList() throws BirtException {
        ArrayList selectValueList = new ArrayList();
        ReportItemHandle reportItem = DEUtil.getBindingHolder((DesignElementHandle)this.currentItem);
        if (this.bindingName != null && reportItem != null) {
            DataRequestSession session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, reportItem.getModuleHandle()));
            selectValueList.addAll(session.getColumnValueSet(reportItem.getDataSet(), reportItem.paramBindingsIterator(), reportItem.columnBindingsIterator(), this.bindingName));
            session.shutdown();
        } else {
            ExceptionHandler.openErrorMessageBox(Messages.getString((String)"SelectValueDialog.errorRetrievinglist"), Messages.getString((String)"SelectValueDialog.noExpressionSet"));
        }
        return selectValueList;
    }

    static /* synthetic */ void access$1500(FilterConditionBuilder x0) {
        x0.refreshList();
    }

    static /* synthetic */ String[] access$1600(FilterConditionBuilder x0) {
        return x0.popupItems;
    }

    static /* synthetic */ String access$1702(FilterConditionBuilder x0, String x1) {
        x0.bindingName = x1;
        return x0.bindingName;
    }

    static /* synthetic */ List access$1800(FilterConditionBuilder x0) {
        return x0.columnList;
    }

    static /* synthetic */ String[] access$1900() {
        return actions;
    }

    static /* synthetic */ String access$1700(FilterConditionBuilder x0) {
        return x0.bindingName;
    }

    static /* synthetic */ List access$2000(FilterConditionBuilder x0) throws BirtException {
        return x0.getSelectValueList();
    }

    static /* synthetic */ ParamBindingHandle[] access$2100(FilterConditionBuilder x0) {
        return x0.bindingParams;
    }

    static {
        EMPTY_ARRAY = new String[0];
        EMPTY = new String[0];
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("MapRule", "operator");
        IChoice[] chs = chset.getChoices();
        OPERATOR = new String[chs.length][2];
        for (int i = 0; i < chs.length; ++i) {
            FilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            FilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"FilterConditionBuilder.choice.ValueOfThisDataItem");
    }

    private class ExpressionValue {
        Text valueText;
        Button btnPopup;

        Text getValueText() {
            return this.valueText;
        }

        Button getPopupButton() {
            return this.btnPopup;
        }

        ExpressionValue(Composite parent, int style, Combo expressionText) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new ExpressionLayout());
            GridData gdata = new GridData(3);
            gdata.widthHint = 120;
            gdata.heightHint = 20;
            composite.setLayoutData((Object)gdata);
            this.valueText = FilterConditionBuilder.this.createText(composite);
            this.valueText.addModifyListener(new ModifyListener(this){
                private final /* synthetic */ ExpressionValue this$1;
                {
                    this.this$1 = this$1;
                }

                public void modifyText(ModifyEvent e) {
                    FilterConditionBuilder.access$300(ExpressionValue.access$1400(this.this$1));
                }
            });
            this.btnPopup = new Button(composite, 1028);
            this.btnPopup.addSelectionListener(new SelectionListener(this, expressionText){
                private final /* synthetic */ Combo val$expressionText;
                private final /* synthetic */ ExpressionValue this$1;
                {
                    this.this$1 = this$1;
                    this.val$expressionText = val$expressionText;
                }

                public void widgetSelected(SelectionEvent e) {
                    FilterConditionBuilder.access$1500(ExpressionValue.access$1400(this.this$1));
                    Rectangle textBounds = this.this$1.valueText.getBounds();
                    Point pt = this.this$1.valueText.toDisplay(textBounds.x, textBounds.y);
                    Rectangle rect = new Rectangle(pt.x, pt.y, this.this$1.valueText.getParent().getBounds().width, textBounds.height);
                    PopupSelectionList popup = new PopupSelectionList(this.this$1.valueText.getParent().getShell());
                    popup.setItems(FilterConditionBuilder.access$1600(ExpressionValue.access$1400(this.this$1)));
                    String value = popup.open(rect);
                    int selectionIndex = popup.getSelectionIndex();
                    FilterConditionBuilder.access$1702(ExpressionValue.access$1400(this.this$1), null);
                    Iterator<E> iter = FilterConditionBuilder.access$1800(ExpressionValue.access$1400(this.this$1)).iterator();
                    while (iter.hasNext()) {
                        String columnName = ((ComputedColumnHandle)iter.next()).getName();
                        if (!DEUtil.getColumnExpression((String)columnName).equals(this.val$expressionText.getText())) continue;
                        FilterConditionBuilder.access$1702(ExpressionValue.access$1400(this.this$1), columnName);
                        break;
                    }
                    if (value != null) {
                        String newValue = null;
                        if (value.equals(FilterConditionBuilder.access$1900()[0])) {
                            if (FilterConditionBuilder.access$1700(ExpressionValue.access$1400(this.this$1)) != null) {
                                try {
                                    List selectValueList = FilterConditionBuilder.access$2000(ExpressionValue.access$1400(this.this$1));
                                    SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), Messages.getString((String)"ExpressionValueCellEditor.title"));
                                    dialog.setSelectedValueList(selectValueList);
                                    if (FilterConditionBuilder.access$2100(ExpressionValue.access$1400(this.this$1)) != null) {
                                        dialog.setBindingParams(FilterConditionBuilder.access$2100(ExpressionValue.access$1400(this.this$1)));
                                    }
                                    if (dialog.open() == 0) {
                                        newValue = dialog.getSelectedExprValue();
                                    }
                                }
                                catch (Exception ex) {
                                    MessageDialog.openError(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)(Messages.getString((String)"SelectValueDialog.messages.error.selectVauleUnavailable") + "\n" + ex.getMessage()));
                                }
                            } else {
                                MessageDialog.openInformation(null, (String)Messages.getString((String)"SelectValueDialog.selectValue"), (String)Messages.getString((String)"SelectValueDialog.messages.info.selectVauleUnavailable"));
                            }
                        } else if (value.equals(FilterConditionBuilder.access$1900()[1])) {
                            ExpressionBuilder dialog = new ExpressionBuilder(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.this$1.valueText.getText());
                            dialog.setExpressionProvier(new ExpressionProvider(FilterConditionBuilder.access$200(ExpressionValue.access$1400(this.this$1))));
                            if (dialog.open() == 0) {
                                newValue = dialog.getResult();
                            }
                        } else if (selectionIndex > 3) {
                            newValue = "params[\"" + value + "\"]";
                        }
                        if (newValue != null) {
                            this.this$1.valueText.setText(newValue);
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }

        static /* synthetic */ FilterConditionBuilder access$1400(ExpressionValue x0) {
            return x0.FilterConditionBuilder.this;
        }

        private class ExpressionLayout
        extends Layout {
            private ExpressionLayout() {
            }

            public void layout(Composite editor, boolean force) {
                Rectangle bounds = editor.getClientArea();
                Point size = ExpressionValue.this.btnPopup.computeSize(-1, -1, force);
                ExpressionValue.this.valueText.setBounds(0, 0, bounds.width - size.x, bounds.height);
                ExpressionValue.this.btnPopup.setBounds(bounds.width - size.x, 0, size.x, bounds.height);
            }

            public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
                if (wHint != -1 && hHint != -1) {
                    return new Point(wHint, hHint);
                }
                Point contentsSize = ExpressionValue.this.valueText.computeSize(-1, -1, force);
                Point buttonSize = ExpressionValue.this.btnPopup.computeSize(-1, -1, force);
                Point result = new Point(buttonSize.x, Math.max(contentsSize.y, buttonSize.y));
                return result;
            }
        }
    }
}

