/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.Comparator;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.PreviewLabel;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.HighlightHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.ColorBuilder;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.FontSizeBuilder;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.HighlightRuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class HighlightRuleBuilder
extends BaseDialog {
    public static final String[][] OPERATOR;
    private HighlightRuleHandle handle;
    private HighlightHandleProvider provider;
    private int handleCount;
    private Combo expression;
    private Combo operator;
    private Text value1;
    private Text value2;
    private Label andLable;
    private Button valBuilder1;
    private Button valBuilder2;
    private Combo font;
    private FontSizeBuilder size;
    private ColorBuilder color;
    private ColorBuilder backColor;
    private Button bold;
    private Button italic;
    private Button underline;
    private Button linethrough;
    private PreviewLabel previewLabel;
    private DesignElementHandle designHandle;
    private boolean isBoldChanged;
    private boolean isItalicChanged;
    private boolean isUnderlineChanged;
    private boolean isLinethroughChanged;
    private static final String DEFAULT_CHOICE;
    private static final String[] SYSTEM_FONT_LIST;
    private static final String VALUE_OF_THIS_DATA_ITEM;

    public static String getValueForOperator(String name) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][0].equals(name)) continue;
            return OPERATOR[i][1];
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return OPERATOR[i][0];
        }
        return "";
    }

    public static int getIndexForOperatorValue(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return i;
        }
        return 0;
    }

    public HighlightRuleBuilder(Shell parentShell, String title, HighlightHandleProvider provider) {
        super(parentShell, title);
        this.provider = provider;
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        HighlightRuleBuilder.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        Label lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Condition"));
        Composite condition = new Composite(innerParent, 0);
        condition.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout(5, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        this.expression.setLayoutData((Object)gdata);
        this.fillExpression(this.expression);
        this.expression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HighlightRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && HighlightRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    HighlightRuleBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)HighlightRuleBuilder.this.designHandle).getResultSetColumn()));
                }
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        Button expBuilder = new Button(condition, 8);
        expBuilder.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        expBuilder.setLayoutData((Object)gdata);
        expBuilder.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editValue((Control)HighlightRuleBuilder.this.expression);
            }
        });
        this.operator = new Combo(condition, 8);
        for (int i = 0; i < OPERATOR.length; ++i) {
            this.operator.add(OPERATOR[i][0]);
        }
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = HighlightRuleBuilder.getValueForOperator(HighlightRuleBuilder.this.operator.getText());
                int vv = HighlightRuleBuilder.determineValueVisible(value);
                if (vv == 0) {
                    HighlightRuleBuilder.this.value1.setVisible(false);
                    HighlightRuleBuilder.this.value2.setVisible(false);
                    HighlightRuleBuilder.this.valBuilder1.setVisible(false);
                    HighlightRuleBuilder.this.valBuilder2.setVisible(false);
                    HighlightRuleBuilder.this.andLable.setVisible(false);
                } else if (vv == 1) {
                    HighlightRuleBuilder.this.value1.setVisible(true);
                    HighlightRuleBuilder.this.valBuilder1.setVisible(true);
                    HighlightRuleBuilder.this.value2.setVisible(false);
                    HighlightRuleBuilder.this.valBuilder2.setVisible(false);
                    HighlightRuleBuilder.this.andLable.setVisible(false);
                } else if (vv == 2) {
                    HighlightRuleBuilder.this.value1.setVisible(true);
                    HighlightRuleBuilder.this.value2.setVisible(true);
                    HighlightRuleBuilder.this.valBuilder1.setVisible(true);
                    HighlightRuleBuilder.this.valBuilder2.setVisible(true);
                    HighlightRuleBuilder.this.andLable.setVisible(true);
                }
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.value1 = this.createText(condition);
        this.value1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.valBuilder1 = new Button(condition, 8);
        this.valBuilder1.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        this.valBuilder1.setLayoutData((Object)gdata);
        this.valBuilder1.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        this.valBuilder1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editValue((Control)HighlightRuleBuilder.this.value1);
            }
        });
        this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.AND"));
        this.andLable.setVisible(false);
        this.createDummy(condition, 1);
        this.createDummy(condition, 3);
        this.value2 = this.createText(condition);
        this.value2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                HighlightRuleBuilder.this.updateButtons();
            }
        });
        this.value2.setVisible(false);
        this.valBuilder2 = new Button(condition, 8);
        this.valBuilder2.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        this.valBuilder2.setLayoutData((Object)gdata);
        this.valBuilder2.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        this.valBuilder2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.editValue((Control)HighlightRuleBuilder.this.value2);
            }
        });
        this.valBuilder2.setVisible(false);
        if (this.operator.getItemCount() > 0) {
            this.operator.select(0);
        }
        lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Format"));
        Composite format = new Composite(innerParent, 0);
        format.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout(7, false);
        format.setLayout((Layout)glayout);
        lb = new Label(format, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Font"));
        lb = new Label(format, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Size"));
        lb = new Label(format, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Color"));
        this.createDummy(format, 4);
        this.font = new Combo(format, 8);
        gdata = new GridData();
        gdata.widthHint = 100;
        this.font.setLayoutData((Object)gdata);
        IChoiceSet fontSet = ChoiceSetFactory.getElementChoiceSet("Style", "fontFamily");
        this.font.setData((Object)fontSet);
        this.font.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(fontSet, (Comparator)new AlphabeticallyComparator()));
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            for (int i = 0; i < SYSTEM_FONT_LIST.length; ++i) {
                this.font.add(SYSTEM_FONT_LIST[i]);
            }
        }
        this.font.add(DEFAULT_CHOICE, 0);
        this.font.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        if (this.font.getItemCount() > 0) {
            this.font.select(0);
        }
        this.size = new FontSizeBuilder(format, 0);
        if (this.designHandle != null) {
            this.size.setDefaultUnit(this.designHandle.getPropertyHandle("fontSize").getDefaultUnit());
        }
        gdata = new GridData();
        gdata.widthHint = 120;
        this.size.setLayoutData(gdata);
        this.size.setFontSizeValue(null);
        this.size.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.color = new ColorBuilder(format, 0);
        gdata = new GridData();
        gdata.widthHint = 50;
        this.color.setLayoutData(gdata);
        this.color.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "color"));
        this.color.setRGB(null);
        this.color.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setForeground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.color.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        Composite fstyle = new Composite(format, 0);
        gdata = new GridData();
        gdata.horizontalSpan = 4;
        fstyle.setLayoutData((Object)gdata);
        fstyle.setLayout((Layout)new GridLayout(4, false));
        this.bold = this.createToggleButton(fstyle);
        this.bold.setImage(ReportPlatformUIImages.getImage("fontWeight"));
        this.bold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isBoldChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.bold.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Bold"));
        this.italic = this.createToggleButton(fstyle);
        this.italic.setImage(ReportPlatformUIImages.getImage("fontStyle"));
        this.italic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isItalicChanged = true;
                HighlightRuleBuilder.this.updatePreview();
            }
        });
        this.italic.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Italic"));
        this.underline = this.createToggleButton(fstyle);
        this.underline.setImage(ReportPlatformUIImages.getImage("textUnderline"));
        this.underline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isUnderlineChanged = true;
                HighlightRuleBuilder.this.previewLabel.setUnderline(HighlightRuleBuilder.this.underline.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.underline.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Underline"));
        this.linethrough = this.createToggleButton(fstyle);
        this.linethrough.setImage(ReportPlatformUIImages.getImage("textLineThrough"));
        this.linethrough.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HighlightRuleBuilder.this.isLinethroughChanged = true;
                HighlightRuleBuilder.this.previewLabel.setLinethrough(HighlightRuleBuilder.this.linethrough.getSelection());
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        this.linethrough.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.Text_Line_Through"));
        Composite back = new Composite(innerParent, 0);
        back.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout(1, false);
        back.setLayout((Layout)glayout);
        lb = new Label(back, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.BackgroundColor"));
        this.backColor = new ColorBuilder(back, 0);
        gdata = new GridData();
        gdata.widthHint = 50;
        this.backColor.setLayoutData(gdata);
        this.backColor.setChoiceSet(ChoiceSetFactory.getElementChoiceSet("Style", "backgroundColor"));
        this.backColor.setRGB(null);
        this.backColor.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                HighlightRuleBuilder.this.previewLabel.setBackground(ColorManager.getColor((RGB)HighlightRuleBuilder.this.backColor.getRGB()));
                HighlightRuleBuilder.this.previewLabel.redraw();
            }
        });
        Composite preview = new Composite(innerParent, 0);
        glayout = new GridLayout();
        preview.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        preview.setLayoutData((Object)gdata);
        lb = new Label(preview, 0);
        lb.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Preview"));
        Composite previewPane = new Composite(preview, 2048);
        glayout = new GridLayout();
        glayout.marginWidth = 0;
        glayout.marginHeight = 0;
        previewPane.setLayout((Layout)glayout);
        gdata = new GridData(1808);
        gdata.heightHint = 60;
        previewPane.setLayoutData((Object)gdata);
        this.previewLabel = new PreviewLabel(previewPane, 0);
        this.previewLabel.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.PreviewContent"));
        gdata = new GridData(1808);
        this.previewLabel.setLayoutData(gdata);
        this.updatePreview();
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        this.syncViewProperties();
        this.updatePreview();
        this.updateButtons();
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.Title"));
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.HighlightRuleBuilder_ID");
        return titleArea;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Button createToggleButton(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        wrapper.setLayout((Layout)layout);
        Button btn = new Button(wrapper, 2);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.heightHint = 22;
        btn.setLayoutData((Object)gdata);
        return btn;
    }

    private void updatePreview() {
        String familyValue = this.getFontFamily();
        int sizeValue = this.getFontSize();
        this.previewLabel.setFontFamily(familyValue);
        this.previewLabel.setFontSize(sizeValue);
        this.previewLabel.setBold(this.bold.getSelection());
        this.previewLabel.setItalic(this.italic.getSelection());
        this.previewLabel.setForeground(ColorManager.getColor((RGB)this.color.getRGB()));
        this.previewLabel.setBackground(ColorManager.getColor((RGB)this.backColor.getRGB()));
        this.previewLabel.setUnderline(this.underline.getSelection());
        this.previewLabel.setLinethrough(this.linethrough.getSelection());
        this.previewLabel.updateView();
    }

    public void updateHandle(HighlightRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
    }

    public HighlightRuleHandle getHandle() {
        return this.handle;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    private void fillExpression(Combo control) {
        String te = "";
        if (this.handle != null) {
            te = this.handle.getTestExpression();
        }
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getResultSetColumn() != null) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        control.add(DEUtil.resolveNull((String)te));
        control.select(control.getItemCount() - 1);
    }

    private void updateButtons() {
        this.enableInput(this.isExpressionOK());
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private void enableInput(boolean val) {
        this.operator.setEnabled(val);
        this.value1.setEnabled(val);
        this.value2.setEnabled(val);
        this.valBuilder1.setEnabled(val);
        this.valBuilder2.setEnabled(val);
        this.font.setEnabled(val);
        this.size.setEnabled(val);
        this.color.setEnabled(val);
        this.bold.setEnabled(val);
        this.italic.setEnabled(val);
        this.underline.setEnabled(val);
        this.linethrough.setEnabled(val);
        this.backColor.setEnabled(val);
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.value1.getVisible() && (this.value1.getText() == null || this.value1.getText().length() == 0)) {
            return false;
        }
        return !this.value2.getVisible() || this.value2.getText() != null && this.value2.getText().length() != 0;
    }

    private void syncViewProperties() {
        if (this.handle != null) {
            this.expression.setText(DEUtil.resolveNull((String)this.handle.getTestExpression()));
            this.operator.select(HighlightRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
            this.value1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
            this.value2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
            int vv = HighlightRuleBuilder.determineValueVisible(this.handle.getOperator());
            if (vv == 0) {
                this.value1.setVisible(false);
                this.value2.setVisible(false);
                this.valBuilder1.setVisible(false);
                this.valBuilder2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 1) {
                this.value1.setVisible(true);
                this.value2.setVisible(false);
                this.valBuilder1.setVisible(true);
                this.valBuilder2.setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 2) {
                this.value1.setVisible(true);
                this.value2.setVisible(true);
                this.valBuilder1.setVisible(true);
                this.valBuilder2.setVisible(true);
                this.andLable.setVisible(true);
            }
        }
        this.syncFamily();
        this.syncSize();
        if (this.handle != null) {
            if (this.handle.getColor().isSet()) {
                this.color.setRGB(DEUtil.getRGBValue((int)this.handle.getColor().getRGB()));
            }
            if (this.handle.getBackgroundColor().isSet()) {
                this.backColor.setRGB(DEUtil.getRGBValue((int)this.handle.getBackgroundColor().getRGB()));
            }
            this.bold.setSelection("bold".equals(this.handle.getFontWeight()));
            this.italic.setSelection("italic".equals(this.handle.getFontStyle()));
            this.underline.setSelection("underline".equals(this.handle.getTextUnderline()));
            this.linethrough.setSelection("line-through".equals(this.handle.getTextLineThrough()));
        }
    }

    private void syncFamily() {
        String fm;
        if (this.handle != null && this.innerSyncFamily(fm = DEUtil.RemoveQuote((String)this.handle.getFontFamilyHandle().getDisplayValue()))) {
            return;
        }
    }

    private boolean innerSyncFamily(String fm) {
        String[] items = this.font.getItems();
        int idx = this.getSelectionIndex(fm, items);
        if (idx >= 0) {
            this.font.select(idx);
            return true;
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            for (int i = 0; i < SYSTEM_FONT_LIST.length; ++i) {
                if (!SYSTEM_FONT_LIST[i].equals(fm)) continue;
                this.font.select(items.length + i);
                return true;
            }
        }
        return false;
    }

    private int getSelectionIndex(String fm, String[] items) {
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equalsIgnoreCase(fm)) continue;
            return i;
        }
        return 0;
    }

    private void syncSize() {
        if (this.handle != null) {
            this.size.setFontSizeValue(this.handle.getFontSize().getStringValue());
        }
    }

    private String getFontFamily() {
        String rfm = this.getRawFontFamily();
        if (rfm == null) {
            rfm = this.designHandle != null ? (this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontFamilyHandle().getStringValue() : this.designHandle.getPrivateStyle().getFontFamilyHandle().getStringValue()) : "serif";
        }
        return HighlightHandleProvider.getFontFamily(rfm);
    }

    private String getRawFontFamily() {
        String ftName = this.font.getText();
        IChoiceSet cs = (IChoiceSet)this.font.getData();
        IChoice ci = cs.findChoiceByDisplayName(ftName);
        if (ci != null) {
            return ci.getName();
        }
        if (SYSTEM_FONT_LIST != null && SYSTEM_FONT_LIST.length > 0) {
            for (int i = 0; i < SYSTEM_FONT_LIST.length; ++i) {
                if (!SYSTEM_FONT_LIST[i].equals(ftName)) continue;
                return DEUtil.AddQuote((String)ftName);
            }
        }
        return null;
    }

    private int getFontSize() {
        String rfs = this.getRawFontSize();
        if (rfs == null && this.designHandle != null) {
            rfs = this.designHandle instanceof StyleHandle ? ((StyleHandle)this.designHandle).getFontSize().getStringValue() : this.designHandle.getPrivateStyle().getFontSize().getStringValue();
        }
        return DEUtil.getFontSize((String)rfs);
    }

    private String getRawFontSize() {
        return this.size.getFontSizeValue();
    }

    protected void okPressed() {
        try {
            String lingthroughValue;
            String familyValue = this.getRawFontFamily();
            String sizeValue = this.getRawFontSize();
            int colorValue = DEUtil.getRGBInt((RGB)this.color.getRGB());
            int backColorValue = DEUtil.getRGBInt((RGB)this.backColor.getRGB());
            String italicValue = this.italic.getSelection() ? "italic" : "normal";
            String weightValue = this.bold.getSelection() ? "bold" : "normal";
            String underlineValue = this.underline.getSelection() ? "underline" : "none";
            String string = lingthroughValue = this.linethrough.getSelection() ? "line-through" : "none";
            if (this.handle == null) {
                HighlightRule rule = StructureFactory.createHighlightRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                rule.setProperty("value1", (Object)DEUtil.resolveNull((String)this.value1.getText()));
                rule.setProperty("value2", (Object)DEUtil.resolveNull((String)this.value2.getText()));
                if (this.color.getRGB() != null) {
                    rule.setProperty("color", (Object)new Integer(colorValue));
                }
                if (this.backColor.getRGB() != null) {
                    rule.setProperty("backgroundColor", (Object)new Integer(backColorValue));
                }
                if (familyValue != null) {
                    rule.setProperty("fontFamily", (Object)familyValue);
                }
                if (sizeValue != null) {
                    rule.setProperty("fontSize", (Object)sizeValue);
                }
                if (this.isItalicChanged) {
                    rule.setProperty("fontStyle", (Object)italicValue);
                }
                if (this.isBoldChanged) {
                    rule.setProperty("fontWeight", (Object)weightValue);
                }
                if (this.isLinethroughChanged) {
                    rule.setProperty("textLineThrough", (Object)lingthroughValue);
                }
                if (this.isUnderlineChanged) {
                    rule.setProperty("textUnderline", (Object)underlineValue);
                }
                rule.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                this.handle.setOperator(DEUtil.resolveNull((String)HighlightRuleBuilder.getValueForOperator(this.operator.getText())));
                this.handle.setValue1(DEUtil.resolveNull((String)this.value1.getText()));
                if (this.handle.getOperator().equals("between") || this.handle.getOperator().equals("not-between")) {
                    this.handle.setValue2(DEUtil.resolveNull((String)this.value2.getText()));
                }
                this.handle.getFontFamilyHandle().setStringValue(DEUtil.resolveNull((String)familyValue));
                this.handle.getFontSize().setStringValue(DEUtil.resolveNull((String)sizeValue));
                if (this.color.getRGB() != null) {
                    this.handle.getColor().setRGB(colorValue);
                } else {
                    this.handle.getColor().setValue(null);
                }
                if (this.backColor.getRGB() != null) {
                    this.handle.getBackgroundColor().setRGB(backColorValue);
                } else {
                    this.handle.getBackgroundColor().setValue(null);
                }
                if (this.isItalicChanged) {
                    this.handle.setFontStyle(italicValue);
                }
                if (this.isBoldChanged) {
                    this.handle.setFontWeight(weightValue);
                }
                if (this.isUnderlineChanged) {
                    this.handle.setTextUnderline(underlineValue);
                }
                if (this.isLinethroughChanged) {
                    this.handle.setTextLineThrough(lingthroughValue);
                }
                this.handle.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    private void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("HighlightRule", "operator");
        IChoice[] chs = chset.getChoices();
        OPERATOR = new String[chs.length][2];
        for (int i = 0; i < chs.length; ++i) {
            HighlightRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            HighlightRuleBuilder.OPERATOR[i][1] = chs[i].getName();
        }
        DEFAULT_CHOICE = Messages.getString((String)"HighlightRuleBuilderDialog.text.Default");
        SYSTEM_FONT_LIST = DEUtil.getSystemFontNames();
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
    }
}

