/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.MapHandleProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MapRuleBuilder
extends BaseDialog {
    public static final String DLG_TITLE_NEW = Messages.getString((String)"MapRuleBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"MapRuleBuilder.DialogTitle.Edit");
    static final String[][] OPERATOR;
    private MapRuleHandle handle;
    private MapHandleProvider provider;
    private int handleCount;
    private Combo expression;
    private Combo operator;
    private Button valBuilder1;
    private Button valBuilder2;
    private Text value1;
    private Text value2;
    private Text display;
    private Label andLable;
    private DesignElementHandle designHandle;
    private static final String VALUE_OF_THIS_DATA_ITEM;

    public static String getValueForOperator(String name) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][0].equals(name)) continue;
            return OPERATOR[i][1];
        }
        return null;
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        return 1;
    }

    public static String getNameForOperator(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return OPERATOR[i][0];
        }
        return "";
    }

    static int getIndexForOperatorValue(String value) {
        for (int i = 0; i < OPERATOR.length; ++i) {
            if (!OPERATOR[i][1].equals(value)) continue;
            return i;
        }
        return 0;
    }

    public MapRuleBuilder(Shell parentShell, String title, MapHandleProvider provider) {
        super(parentShell, title);
        this.provider = provider;
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditMapRule_ID");
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        MapRuleBuilder.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        Label lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Condition"));
        Composite condition = new Composite(innerParent, 0);
        condition.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout(5, false);
        condition.setLayout((Layout)glayout);
        this.expression = new Combo(condition, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 100;
        this.expression.setLayoutData((Object)gdata);
        this.fillExpression(this.expression);
        this.expression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MapRuleBuilder.this.expression.getText().equals(VALUE_OF_THIS_DATA_ITEM) && MapRuleBuilder.this.designHandle instanceof DataItemHandle) {
                    MapRuleBuilder.this.expression.setText(DEUtil.getColumnExpression((String)((DataItemHandle)MapRuleBuilder.this.designHandle).getResultSetColumn()));
                }
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.expression.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        Button expBuilder = new Button(condition, 8);
        expBuilder.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        expBuilder.setLayoutData((Object)gdata);
        expBuilder.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        expBuilder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editValue((Control)MapRuleBuilder.this.expression);
            }
        });
        this.operator = new Combo(condition, 8);
        for (int i = 0; i < OPERATOR.length; ++i) {
            this.operator.add(OPERATOR[i][0]);
        }
        this.operator.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = MapRuleBuilder.getValueForOperator(MapRuleBuilder.this.operator.getText());
                int vv = MapRuleBuilder.determineValueVisible(value);
                if (vv == 0) {
                    MapRuleBuilder.this.value1.setVisible(false);
                    MapRuleBuilder.this.value2.setVisible(false);
                    MapRuleBuilder.this.valBuilder1.setVisible(false);
                    MapRuleBuilder.this.valBuilder2.setVisible(false);
                    MapRuleBuilder.this.andLable.setVisible(false);
                } else if (vv == 1) {
                    MapRuleBuilder.this.value1.setVisible(true);
                    MapRuleBuilder.this.valBuilder1.setVisible(true);
                    MapRuleBuilder.this.value2.setVisible(false);
                    MapRuleBuilder.this.valBuilder2.setVisible(false);
                    MapRuleBuilder.this.andLable.setVisible(false);
                } else if (vv == 2) {
                    MapRuleBuilder.this.value1.setVisible(true);
                    MapRuleBuilder.this.value2.setVisible(true);
                    MapRuleBuilder.this.valBuilder1.setVisible(true);
                    MapRuleBuilder.this.valBuilder2.setVisible(true);
                    MapRuleBuilder.this.andLable.setVisible(true);
                }
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.value1 = this.createText(condition);
        this.value1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.valBuilder1 = new Button(condition, 8);
        this.valBuilder1.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        this.valBuilder1.setLayoutData((Object)gdata);
        this.valBuilder1.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        this.valBuilder1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editValue((Control)MapRuleBuilder.this.value1);
            }
        });
        this.createDummy(condition, 3);
        this.andLable = new Label(condition, 0);
        this.andLable.setText(Messages.getString((String)"HighlightRuleBuilderDialog.text.AND"));
        this.andLable.setVisible(false);
        this.createDummy(condition, 1);
        this.createDummy(condition, 3);
        this.value2 = this.createText(condition);
        this.value2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MapRuleBuilder.this.updateButtons();
            }
        });
        this.value2.setVisible(false);
        this.valBuilder2 = new Button(condition, 8);
        this.valBuilder2.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        this.valBuilder2.setLayoutData((Object)gdata);
        this.valBuilder2.setToolTipText(Messages.getString((String)"HighlightRuleBuilderDialog.tooltip.ExpBuilder"));
        this.valBuilder2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MapRuleBuilder.this.editValue((Control)MapRuleBuilder.this.value2);
            }
        });
        this.valBuilder2.setVisible(false);
        if (this.operator.getItemCount() > 0) {
            this.operator.select(0);
        }
        lb = new Label(innerParent, 0);
        lb.setText(Messages.getString((String)"MapRuleBuilderDialog.text.Display"));
        Composite format = new Composite(innerParent, 0);
        format.setLayoutData((Object)new GridData(768));
        glayout = new GridLayout();
        format.setLayout((Layout)glayout);
        this.display = new Text(format, 2048);
        gdata = new GridData();
        gdata.widthHint = 300;
        this.display.setLayoutData((Object)gdata);
        Composite space = new Composite(innerParent, 0);
        gdata = new GridData(768);
        gdata.heightHint = 20;
        space.setLayoutData((Object)gdata);
        lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        if (this.handle != null) {
            this.syncViewProperties();
        }
        this.updateButtons();
        return composite;
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    private Composite createDummy(Composite parent, int colSpan) {
        Composite dummy = new Composite(parent, 0);
        GridData gdata = new GridData();
        gdata.widthHint = 22;
        gdata.horizontalSpan = colSpan;
        gdata.heightHint = 10;
        dummy.setLayoutData((Object)gdata);
        return dummy;
    }

    private Text createText(Composite parent) {
        Text txt = new Text(parent, 2048);
        GridData gdata = new GridData(768);
        gdata.widthHint = 100;
        txt.setLayoutData((Object)gdata);
        return txt;
    }

    public void updateHandle(MapRuleHandle handle, int handleCount) {
        this.handle = handle;
        this.handleCount = handleCount;
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
    }

    public MapRuleHandle getHandle() {
        return this.handle;
    }

    private void fillExpression(Combo control) {
        String te = "";
        if (this.handle != null) {
            te = this.handle.getTestExpression();
        }
        if (this.designHandle instanceof DataItemHandle && ((DataItemHandle)this.designHandle).getColumnBindings().iterator().hasNext()) {
            control.add(VALUE_OF_THIS_DATA_ITEM);
        }
        control.add(DEUtil.resolveNull((String)te));
        control.select(control.getItemCount() - 1);
    }

    private void updateButtons() {
        this.enableInput(this.isExpressionOK());
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private void enableInput(boolean val) {
        this.operator.setEnabled(val);
        this.value1.setEnabled(val);
        this.value2.setEnabled(val);
        this.valBuilder1.setEnabled(val);
        this.valBuilder2.setEnabled(val);
        this.display.setEnabled(val);
    }

    private boolean isExpressionOK() {
        if (this.expression == null) {
            return false;
        }
        return this.expression.getText() != null && this.expression.getText().length() != 0;
    }

    private boolean isConditionOK() {
        if (this.expression == null) {
            return false;
        }
        if (!this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    private boolean checkValues() {
        if (this.value1.getVisible() && (this.value1.getText() == null || this.value1.getText().length() == 0)) {
            return false;
        }
        return !this.value2.getVisible() || this.value2.getText() != null && this.value2.getText().length() != 0;
    }

    private void syncViewProperties() {
        this.expression.setText(DEUtil.resolveNull((String)this.handle.getTestExpression()));
        this.operator.select(MapRuleBuilder.getIndexForOperatorValue(this.handle.getOperator()));
        this.value1.setText(DEUtil.resolveNull((String)this.handle.getValue1()));
        this.value2.setText(DEUtil.resolveNull((String)this.handle.getValue2()));
        int vv = MapRuleBuilder.determineValueVisible(this.handle.getOperator());
        if (vv == 0) {
            this.value1.setVisible(false);
            this.value2.setVisible(false);
            this.valBuilder1.setVisible(false);
            this.valBuilder2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (vv == 1) {
            this.value1.setVisible(true);
            this.value2.setVisible(false);
            this.valBuilder1.setVisible(true);
            this.valBuilder2.setVisible(false);
            this.andLable.setVisible(false);
        } else if (vv == 2) {
            this.value1.setVisible(true);
            this.value2.setVisible(true);
            this.valBuilder1.setVisible(true);
            this.valBuilder2.setVisible(true);
            this.andLable.setVisible(true);
        }
        this.display.setText(DEUtil.resolveNull((String)this.handle.getDisplay()));
    }

    protected void okPressed() {
        try {
            if (this.handle == null) {
                MapRule rule = StructureFactory.createMapRule();
                rule.setProperty("operator", (Object)DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                rule.setProperty("value1", (Object)DEUtil.resolveNull((String)this.value1.getText()));
                rule.setProperty("value2", (Object)DEUtil.resolveNull((String)this.value2.getText()));
                rule.setProperty("display", (Object)DEUtil.resolveNull((String)this.display.getText()));
                rule.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
                this.handle = this.provider.doAddItem(rule, this.handleCount);
            } else {
                this.handle.setOperator(DEUtil.resolveNull((String)MapRuleBuilder.getValueForOperator(this.operator.getText())));
                this.handle.setValue1(DEUtil.resolveNull((String)this.value1.getText()));
                this.handle.setValue2(DEUtil.resolveNull((String)this.value2.getText()));
                this.handle.setDisplay(DEUtil.resolveNull((String)this.display.getText()));
                this.handle.setTestExpression(DEUtil.resolveNull((String)this.expression.getText()));
            }
        }
        catch (Exception e) {
            WidgetUtil.processError(this.getShell(), e);
        }
        super.okPressed();
    }

    private void editValue(Control control) {
        String initValue = null;
        if (control instanceof Text) {
            initValue = ((Text)control).getText();
        } else if (control instanceof Combo) {
            initValue = ((Combo)control).getText();
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder(this.getShell(), initValue);
        if (this.designHandle != null) {
            expressionBuilder.setExpressionProvier(new ExpressionProvider(this.designHandle));
        }
        if (expressionBuilder.open() == 0) {
            String result = DEUtil.resolveNull((String)expressionBuilder.getResult());
            if (control instanceof Text) {
                ((Text)control).setText(result);
            } else if (control instanceof Combo) {
                ((Combo)control).setText(result);
            }
        }
        this.updateButtons();
    }

    static {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet("MapRule", "operator");
        IChoice[] chs = chset.getChoices();
        OPERATOR = new String[chs.length][2];
        for (int i = 0; i < chs.length; ++i) {
            MapRuleBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            MapRuleBuilder.OPERATOR[i][1] = chs[i].getName();
        }
        VALUE_OF_THIS_DATA_ITEM = Messages.getString((String)"HighlightRuleBuilderDialog.choice.ValueOfThisDataItem");
    }
}

