/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.DateFormatter;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.core.format.StringFormatter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ImportValueDialog;
import org.eclipse.birt.report.designer.internal.ui.dialogs.SelectionChoiceDialog;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ITableAreaModifier;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.TableArea;
import org.eclipse.birt.report.designer.internal.ui.util.DataUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlatformUIImages;
import org.eclipse.birt.report.designer.ui.actions.NewDataSetAction;
import org.eclipse.birt.report.designer.ui.dialogs.FormatBuilder;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ResultSetColumnHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ParameterDialog
extends BaseDialog {
    private static final String CHOICE_NO_DEFAULT = Messages.getString((String)"ParameterDialog.Choice.NoDefault");
    private static final String CHOICE_NONE = Messages.getString((String)"ParameterDialog.Choice.None");
    private static final String CHOICE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Choice.DisplayText");
    private static final String CHOICE_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Choice.ValueColumn");
    private static final String CHOICE_ASCENDING = Messages.getString((String)"ParameterDialog.Choice.ASCENDING");
    private static final String CHOICE_DESCENDING = Messages.getString((String)"ParameterDialog.Choice.DESCENDING");
    private static final String GROUP_MORE_OPTION = Messages.getString((String)"ParameterDialog.Group.MoreOption");
    private static final String LABEL_NAME = Messages.getString((String)"ParameterDialog.Label.Name");
    private static final String LABEL_DATETIME_PROMPT = Messages.getFormattedString((String)"ParameterDialog.datetime.prompt", (Object[])new String[]{"MM/DD/YYYY hh:mm:ss AM/PM"});
    private static final String LABEL_PROMPT_TEXT = Messages.getString((String)"ParameterDialog.Label.PromptText");
    private static final String LABEL_PARAM_DATA_TYPE = Messages.getString((String)"ParameterDialog.Label.DataType");
    private static final String LABEL_DISPALY_TYPE = Messages.getString((String)"ParameterDialog.Label.DisplayType");
    private static final String LABEL_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.Label.DefaultValue");
    private static final String LABEL_HELP_TEXT = Messages.getString((String)"ParameterDialog.Label.HelpText");
    private static final String LABEL_LIST_OF_VALUE = Messages.getString((String)"ParameterDialog.Label.ListOfValue");
    private static final String LABEL_SORT_GROUP = Messages.getString((String)"ParameterDialog.Label.SortGroup");
    private static final String LABEL_VALUES = Messages.getString((String)"ParameterDialog.Label.Value");
    private static final String LABEL_FORMAT = Messages.getString((String)"ParameterDialog.Label.Format");
    private static final String LABEL_LIST_LIMIT = Messages.getString((String)"ParameterDialog.Label.Listlimit");
    private static final String LABEL_NULL = Messages.getString((String)"ParameterDialog.Label.Null");
    private static final String LABEL_SELECT_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.SelectDisplayText");
    private static final String LABEL_SELECT_VALUE_COLUMN = Messages.getString((String)"ParameterDialog.Label.SelectValueColumn");
    private static final String LABEL_SELECT_DATA_SET = Messages.getString((String)"ParameterDialog.Label.SelectDataSet");
    private static final String LABEL_PREVIEW = Messages.getString((String)"ParameterDialog.Label.Preview");
    private static final String CHECKBOX_ALLOW_NULL = Messages.getString((String)"ParameterDialog.CheckBox.AllowNull");
    private static final String CHECKBOX_ALLOW_BLANK = Messages.getString((String)"ParameterDialog.CheckBox.AllowBlank");
    private static final String LABEL_SORT_KEY = Messages.getString((String)"ParameterDialog.Label.SortKey");
    private static final String LABEL_SORT_DIRECTION = Messages.getString((String)"ParameterDialog.Label.SortDirection");
    private static final String CHECKBOX_DO_NOT_ECHO = Messages.getString((String)"ParameterDialog.CheckBox.DoNotEchoInput");
    private static final String CHECKBOX_HIDDEN = Messages.getString((String)"ParameterDialog.CheckBox.Hidden");
    private static final String CHECKBOX_DISTINCT = Messages.getString((String)"ParameterDialog.CheckBox.Distinct");
    private static final String BUTTON_LABEL_CHANGE_FORMAT = Messages.getString((String)"ParameterDialog.Button.ChangeFormat");
    private static final String BUTTON_LABEL_IMPORT = Messages.getString((String)"ParameterDialog.Button.ImportValue");
    private static final String BUTTON_LABEL_SET_DEFAULT = Messages.getString((String)"ParameterDialog.Button.SetDefault");
    private static final String BUTTON_LABEL_REMOVE_DEFAULT = Messages.getString((String)"ParameterDialog.Button.RemoveDefault");
    private static final String BUTTON_CREATE_DATA_SET = Messages.getString((String)"ParameterDialog.Button.CreateDataSet");
    private static final String RADIO_DYNAMIC = Messages.getString((String)"ParameterDialog.Radio.Dynamic");
    private static final String RADIO_STATIC = Messages.getString((String)"ParameterDialog.Radio.Static");
    private static final String ERROR_TITLE_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorTitle.InvalidListLimit");
    private static final String ERROR_MSG_CANNOT_BE_BLANK = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeBlank");
    private static final String ERROR_MSG_CANNOT_BE_NULL = Messages.getString((String)"ParameterDialog.ErrorMessage.CanootBeNull");
    private static final String ERROR_MSG_DUPLICATED_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedValue");
    private static final String ERROR_MSG_DUPLICATED_LABEL = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedLabel");
    private static final String ERROR_MSG_MISMATCH_DATA_TYPE = Messages.getString((String)"ParameterDialog.ErrorMessage.MismatchDataType");
    private static final String ERROR_MSG_DUPLICATED_NAME = Messages.getString((String)"ParameterDialog.ErrorMessage.DuplicatedName");
    private static final String ERROR_MSG_NAME_IS_EMPTY = Messages.getString((String)"ParameterDialog.ErrorMessage.EmptyName");
    private static final String ERROR_MSG_NO_DEFAULT_VALUE = Messages.getString((String)"ParameterDialog.ErrorMessage.NoDefaultValue");
    private static final String ERROR_MSG_NO_AVAILABLE_COLUMN = Messages.getString((String)"ParameterDialog.ErrorMessage.NoAvailableColumn");
    private static final String ERROR_MSG_INVALID_LIST_LIMIT = Messages.getString((String)"ParameterDialog.ErrorMessage.InvalidListLimit");
    private static final String FLAG_DEFAULT = Messages.getString((String)"ParameterDialog.Flag.Default");
    private static final String COLUMN_VALUE = Messages.getString((String)"ParameterDialog.Column.Value");
    private static final String COLUMN_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Column.DisplayText");
    private static final String COLUMN_IS_DEFAULT = Messages.getString((String)"ParameterDialog.Column.Default");
    private static final String BOOLEAN_TRUE = Messages.getString((String)"ParameterDialog.Boolean.True");
    private static final String BOOLEAN_FALSE = Messages.getString((String)"ParameterDialog.Boolean.False");
    private static final String PARAM_CONTROL_LIST = "list-box/List";
    private static final String PARAM_CONTROL_COMBO = "list-box/Combo";
    private static final String DISPLAY_NAME_CONTROL_LIST = Messages.getString((String)"ParameterDialog.DisplayLabel.List");
    private static final String DISPLAY_NAME_CONTROL_COMBO = Messages.getString((String)"ParameterDialog.DisplayLabel.Combo");
    private static final String NONE_DISPLAY_TEXT = Messages.getString((String)"ParameterDialog.Label.None");
    private static final Image DEFAULT_ICON = ReportPlatformUIImages.getImage("Default");
    private static final Image ERROR_ICON = ReportPlatformUIImages.getImage("IMG_OBJS_ERROR_TSK");
    private static final String STANDARD_DATE_TIME_PATTERN = "MM/dd/yyyy hh:mm:ss a";
    private HashMap dirtyProperties = new HashMap(5);
    private ArrayList choiceList = new ArrayList();
    private static final IChoiceSet DATA_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getElement("ScalarParameter").getProperty("dataType").getAllowedChoices();
    private static final IChoiceSet CONTROL_TYPE_CHOICE_SET = DEUtil.getMetaDataDictionary().getChoiceSet("paramControl");
    private ScalarParameterHandle inputParameter;
    private boolean loading = true;
    private Text nameEditor;
    private Text promptTextEditor;
    private Text helpTextEditor;
    private Text formatField;
    private Text defaultValueEditor;
    private Label promptMessageLine;
    private CLabel errorMessageLine;
    private Button doNotEcho;
    private Button isHidden;
    private Button allowNull;
    private Button allowBlank;
    private Button distinct;
    private Button importValue;
    private Button changeDefault;
    private Button changeFormat;
    private Button createDataSet;
    private Button dynamicRadio;
    private Button staticRadio;
    private Combo dataTypeChooser;
    private Combo controlTypeChooser;
    private Combo defaultValueChooser;
    private Combo dataSetChooser;
    private Combo columnChooser;
    private Combo displayTextChooser;
    private Combo sortKeyChooser;
    private Combo sortDirectionChooser;
    private Label previewLabel;
    private Label sortKeyLabel;
    private Label sortDirectionLabel;
    private TableViewer valueTable;
    private String lastDataType;
    private String lastControlType;
    private String formatCategroy;
    private String formatPattern;
    private String defaultValue;
    private Composite valueArea;
    private Composite sorttingArea;
    private List columnList;
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = (ArrayList)inputElement;
            ArrayList elementsList = (ArrayList)list.clone();
            return elementsList.toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            SelectionChoice choice;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 4 && columnIndex == 1 && ParameterDialog.this.isDefaultChoice(choice = (SelectionChoice)element)) {
                return DEFAULT_ICON;
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            SelectionChoice choice = (SelectionChoice)element;
            int valueIndex = ParameterDialog.this.valueTable.getColumnProperties().length - 2;
            String text = null;
            if (ParameterDialog.this.valueTable.getColumnProperties().length == 4 && columnIndex == 1) {
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    text = FLAG_DEFAULT;
                }
            } else if (columnIndex == valueIndex) {
                text = choice.getValue();
            } else if (columnIndex == valueIndex + 1 && (text = choice.getLabel()) == null) {
                text = ParameterDialog.this.format(choice.getValue());
            }
            if (text == null) {
                text = "";
            }
            return text;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private final ITableAreaModifier tableAreaModifier = new ITableAreaModifier(){

        public boolean editItem(Object element) {
            SelectionChoice choice = (SelectionChoice)element;
            boolean isDefault = ParameterDialog.this.isDefaultChoice(choice);
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.Edit"));
            dialog.setInput(choice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(this, choice){
                private final /* synthetic */ SelectionChoice val$choice;
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                    this.val$choice = val$choice;
                }

                public String validate(String displayLabel, String value) {
                    return ParameterDialog.access$600(3.access$500(this.this$1), this.val$choice, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                choice.setValue(ParameterDialog.this.convertToStandardFormat(choice.getValue()));
                if (isDefault) {
                    ParameterDialog.this.changeDefaultValue(choice.getValue());
                }
                return true;
            }
            return false;
        }

        public boolean newItem() {
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            SelectionChoiceDialog dialog = new SelectionChoiceDialog(Messages.getString((String)"ParameterDialog.SelectionDialog.New"));
            dialog.setInput(choice);
            dialog.setValidator(new SelectionChoiceDialog.ISelectionChoiceValidator(this){
                private final /* synthetic */ 3 this$1;
                {
                    this.this$1 = this$1;
                }

                public String validate(String displayLabel, String value) {
                    return ParameterDialog.access$600(3.access$500(this.this$1), null, displayLabel, value);
                }
            });
            if (dialog.open() == 0) {
                choice.setValue(ParameterDialog.this.convertToStandardFormat(choice.getValue()));
                ParameterDialog.this.choiceList.add(choice);
                return true;
            }
            return false;
        }

        public boolean removeItem(Object[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                if (ParameterDialog.this.isDefaultChoice((SelectionChoice)elements[i])) {
                    ParameterDialog.this.changeDefaultValue(null);
                }
                ParameterDialog.this.choiceList.remove(elements[i]);
            }
            return true;
        }

        static /* synthetic */ ParameterDialog access$500(3 x0) {
            return x0.ParameterDialog.this;
        }
    };
    private Text listLimit;

    public ParameterDialog(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public ParameterDialog(Shell parentShell, String title) {
        super(parentShell, title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite topComposite = new Composite(parentComposite, 0);
        topComposite.setLayoutData((Object)new GridData(768));
        topComposite.setLayout((Layout)new GridLayout(2, false));
        this.createPropertiesSection(topComposite);
        this.createDisplayOptionsSection(topComposite);
        this.createValuesDefineSection(parentComposite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.ParameterDialog_ID");
        return parentComposite;
    }

    private void createPropertiesSection(Composite composite) {
        Composite propertiesSection = new Composite(composite, 0);
        propertiesSection.setLayout((Layout)new GridLayout());
        GridData gd = new GridData();
        gd.widthHint = 200;
        propertiesSection.setLayoutData((Object)gd);
        this.createLabel(propertiesSection, LABEL_NAME);
        this.nameEditor = new Text(propertiesSection, 2048);
        this.nameEditor.setLayoutData((Object)new GridData(768));
        this.nameEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.updateMessageLine();
            }
        });
        this.createLabel(propertiesSection, LABEL_PROMPT_TEXT);
        this.promptTextEditor = new Text(propertiesSection, 2048);
        this.promptTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel(propertiesSection, LABEL_PARAM_DATA_TYPE);
        this.dataTypeChooser = new Combo(propertiesSection, 12);
        this.dataTypeChooser.setLayoutData((Object)new GridData(768));
        this.dataTypeChooser.setItems(ChoiceSetFactory.getDisplayNamefromChoiceSet(DATA_TYPE_CHOICE_SET));
        this.dataTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeDataType();
                ParameterDialog.this.updateCheckBoxArea();
            }
        });
        this.createLabel(propertiesSection, LABEL_DISPALY_TYPE);
        this.controlTypeChooser = new Combo(propertiesSection, 12);
        this.controlTypeChooser.setLayoutData((Object)new GridData(768));
        this.controlTypeChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.changeControlType();
            }
        });
    }

    private void createDisplayOptionsSection(Composite composite) {
        Group displayOptionSection = new Group(composite, 0);
        displayOptionSection.setText(GROUP_MORE_OPTION);
        displayOptionSection.setLayout((Layout)new GridLayout(2, false));
        displayOptionSection.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_HELP_TEXT);
        this.helpTextEditor = new Text((Composite)displayOptionSection, 2048);
        this.helpTextEditor.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_FORMAT);
        Composite formatSection = new Composite((Composite)displayOptionSection, 0);
        formatSection.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        formatSection.setLayoutData((Object)new GridData(768));
        this.formatField = new Text(formatSection, 2060);
        this.formatField.setLayoutData((Object)new GridData(768));
        this.changeFormat = new Button(formatSection, 8);
        this.changeFormat.setText(BUTTON_LABEL_CHANGE_FORMAT);
        this.setButtonLayoutData(this.changeFormat);
        this.changeFormat.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.popupFormatBuilder(true);
            }
        });
        this.createLabel((Composite)displayOptionSection, null);
        Group previewArea = new Group((Composite)displayOptionSection, 0);
        previewArea.setLayoutData((Object)new GridData(768));
        previewArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        previewArea.setText(LABEL_PREVIEW);
        this.previewLabel = new Label((Composite)previewArea, 0);
        this.previewLabel.setAlignment(0x1000000);
        this.previewLabel.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, LABEL_LIST_LIMIT);
        Composite limitArea = new Composite((Composite)displayOptionSection, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        limitArea.setLayout((Layout)layout);
        GridData data = new GridData(768);
        data.verticalSpan = 1;
        limitArea.setLayoutData((Object)data);
        this.listLimit = new Text(limitArea, 2048);
        data = new GridData();
        data.widthHint = 80;
        this.listLimit.setLayoutData((Object)data);
        this.listLimit.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = "0123456789\u0000\b\u007f".indexOf(e.character) != -1;
            }
        });
        Label values = new Label(limitArea, 0);
        values.setText(Messages.getString((String)"ParameterDialog.Label.values"));
        values.setLayoutData((Object)new GridData(768));
        this.createLabel((Composite)displayOptionSection, null);
        Composite checkBoxArea = new Composite((Composite)displayOptionSection, 0);
        checkBoxArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        checkBoxArea.setLayoutData((Object)new GridData(1808));
        this.allowNull = new Button(checkBoxArea, 32);
        this.allowNull.setText(CHECKBOX_ALLOW_NULL);
        this.addCheckBoxListener(this.allowNull, CHECKBOX_ALLOW_NULL);
        this.allowBlank = new Button(checkBoxArea, 32);
        this.allowBlank.setText(CHECKBOX_ALLOW_BLANK);
        this.addCheckBoxListener(this.allowBlank, CHECKBOX_ALLOW_BLANK);
        this.doNotEcho = new Button(checkBoxArea, 32);
        this.doNotEcho.setText(CHECKBOX_DO_NOT_ECHO);
        this.addCheckBoxListener(this.doNotEcho, CHECKBOX_DO_NOT_ECHO);
        this.isHidden = new Button(checkBoxArea, 32);
        this.isHidden.setText(CHECKBOX_HIDDEN);
        this.addCheckBoxListener(this.isHidden, CHECKBOX_HIDDEN);
    }

    private void createValuesDefineSection(Composite composite) {
        Group valuesDefineSection = new Group(composite, 0);
        valuesDefineSection.setText(LABEL_LIST_OF_VALUE);
        valuesDefineSection.setLayout((Layout)new GridLayout(2, false));
        valuesDefineSection.setLayoutData((Object)new GridData(768));
        Composite choiceArea = new Composite((Composite)valuesDefineSection, 0);
        choiceArea.setLayoutData((Object)new GridData(768));
        choiceArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, true));
        this.staticRadio = new Button(choiceArea, 16);
        this.staticRadio.setText(RADIO_STATIC);
        this.staticRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        this.dynamicRadio = new Button(choiceArea, 16);
        this.dynamicRadio.setText(RADIO_DYNAMIC);
        this.dynamicRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.switchParamterType();
            }
        });
        this.valueArea = new Composite((Composite)valuesDefineSection, 0);
        this.valueArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(2, false));
        GridData gd = new GridData(1808);
        gd.heightHint = 230;
        gd.widthHint = 550;
        gd.horizontalSpan = 2;
        this.valueArea.setLayoutData((Object)gd);
        this.createLabel((Composite)valuesDefineSection, null);
        this.errorMessageLine = new CLabel((Composite)valuesDefineSection, 0);
        GridData msgLineGridData = new GridData(768);
        msgLineGridData.horizontalSpan = 2;
        this.errorMessageLine.setLayoutData((Object)msgLineGridData);
    }

    public void setInput(Object input) {
        Assert.isNotNull((Object)input);
        Assert.isLegal((boolean)(input instanceof ScalarParameterHandle));
        this.inputParameter = (ScalarParameterHandle)input;
    }

    protected boolean initDialog() {
        Assert.isNotNull((Object)this.inputParameter);
        this.nameEditor.setText(this.inputParameter.getName());
        if (!StringUtil.isBlank((String)this.inputParameter.getPromptText())) {
            this.promptTextEditor.setText(this.inputParameter.getPromptText());
        }
        this.helpTextEditor.setText(UIUtil.convertToGUIString(this.inputParameter.getHelpText()));
        if (this.inputParameter.getValueType().equals("static")) {
            this.staticRadio.setSelection(true);
            Iterator iter = this.inputParameter.getPropertyHandle("selectionList").iterator();
            while (iter.hasNext()) {
                SelectionChoiceHandle choiceHandle = (SelectionChoiceHandle)iter.next();
                this.choiceList.add(choiceHandle.getStructure());
            }
        } else {
            this.dynamicRadio.setSelection(true);
        }
        this.defaultValue = this.inputParameter.getDefaultValue();
        if ("dateTime".equals(this.getSelectedDataType())) {
            try {
                this.defaultValue = this.convertToStandardFormat(DataTypeUtil.toDate((Object)this.defaultValue));
            }
            catch (BirtException e) {
                ExceptionHandler.handle(e);
                return false;
            }
        }
        if (this.inputParameter.getPropertyHandle("listLimit").isSet()) {
            this.listLimit.setText(String.valueOf(this.inputParameter.getListlimit()));
        }
        this.isHidden.setSelection(this.inputParameter.isHidden());
        this.allowNull.setSelection(this.inputParameter.allowNull());
        this.allowBlank.setSelection(this.inputParameter.allowBlank());
        this.doNotEcho.setSelection(this.inputParameter.isConcealValue());
        this.changeDataType();
        this.dataTypeChooser.setText(DATA_TYPE_CHOICE_SET.findChoice(this.inputParameter.getDataType()).getDisplayName());
        this.switchParamterType();
        this.loading = false;
        return true;
    }

    private void initValueArea() {
        if (this.isStatic()) {
            if ("check-box".equals(this.getSelectedControlType())) {
                if (this.isValidValue(this.defaultValue) != null) {
                    this.defaultValue = null;
                    this.defaultValueChooser.select(0);
                } else if (Boolean.valueOf(this.defaultValue).booleanValue()) {
                    this.defaultValueChooser.select(1);
                } else {
                    this.defaultValueChooser.select(2);
                }
            } else if ("text-box".equals(this.getSelectedControlType()) && this.defaultValue != null) {
                if (this.defaultValue.equals(Boolean.toString(true)) || this.defaultValue.equals(Boolean.toString(false))) {
                    this.defaultValue = null;
                } else {
                    this.defaultValueEditor.setText(this.defaultValue);
                }
            } else if (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) {
                this.initSorttingArea();
            }
            this.refreshValueTable();
        } else {
            this.refreshDataSets();
            if (this.inputParameter.getDataSetName() != null) {
                this.dataSetChooser.setText(this.inputParameter.getDataSetName());
            }
            this.refreshColumns(false);
            String columnName = this.getColumnName(this.inputParameter.getValueExpr());
            if (columnName != null) {
                this.columnChooser.setText(columnName);
            }
            if ((columnName = this.getColumnName(this.inputParameter.getLabelExpr())) != null) {
                this.displayTextChooser.setText(columnName);
            }
            if (this.defaultValue != null) {
                this.defaultValueEditor.setText(this.defaultValue);
            }
            this.initSorttingArea();
        }
        this.updateMessageLine();
    }

    private void initSorttingArea() {
        if (!this.inputParameter.isFixedOrder()) {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(true);
            this.sortDirectionChooser.setEnabled(true);
            this.distinct.setEnabled(true);
            this.distinct.setSelection(!this.inputParameter.distinct());
            String sortKey = this.inputParameter.getSortBy();
            if (sortKey == null || sortKey.equals("label")) {
                this.sortKeyChooser.setText(CHOICE_DISPLAY_TEXT);
            } else {
                this.sortKeyChooser.setText(CHOICE_VALUE_COLUMN);
            }
            String sortDirection = this.inputParameter.getSortDirection();
            if (sortDirection == null || sortDirection.equals("asc")) {
                this.sortDirectionChooser.setText(CHOICE_ASCENDING);
            } else {
                this.sortDirectionChooser.setText(CHOICE_DESCENDING);
            }
        } else {
            this.sortKeyLabel.setEnabled(true);
            this.sortKeyChooser.setEnabled(true);
            this.sortDirectionLabel.setEnabled(false);
            this.sortDirectionChooser.setEnabled(false);
            this.distinct.setEnabled(false);
        }
    }

    private void initFormatField() {
        String type = this.getSelectedDataType();
        if ("decimal".equals(this.lastControlType) && "float".equals(type) || "float".equals(this.lastControlType) && "decimal".equals(type)) {
            return;
        }
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        if (choiceSet == null) {
            this.formatPattern = null;
            this.formatCategroy = null;
        } else if (!this.loading || this.inputParameter.getCategory() == null && this.inputParameter.getPattern() == null) {
            if ("string".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("dateTime".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
                this.formatCategroy = choiceSet.findChoice("Unformatted").getName();
            }
            this.formatPattern = null;
        } else {
            this.formatCategroy = this.inputParameter.getCategory();
            if (this.formatCategroy == null) {
                this.formatCategroy = "Unformatted";
            }
            this.formatPattern = this.inputParameter.getPattern();
        }
        this.updateFormatField();
    }

    private void refreshDataSets() {
        String selectedDataSetName = this.dataSetChooser.getText();
        String[] oldList = this.dataSetChooser.getItems();
        ArrayList<String> dataSetList = new ArrayList<String>();
        Iterator iterator = this.inputParameter.getModuleHandle().getVisibleDataSets().iterator();
        while (iterator.hasNext()) {
            DataSetHandle DataSetHandle2 = (DataSetHandle)iterator.next();
            dataSetList.add(DataSetHandle2.getQualifiedName());
        }
        if (this.inputParameter.getDataSetName() != null && !dataSetList.contains(this.inputParameter.getDataSetName())) {
            dataSetList.add(0, this.inputParameter.getDataSetName());
        }
        if (oldList.length != dataSetList.size()) {
            this.dataSetChooser.setItems(dataSetList.toArray(new String[0]));
            if (StringUtil.isBlank((String)selectedDataSetName)) {
                this.dataSetChooser.select(0);
                this.refreshColumns(false);
            } else {
                this.dataSetChooser.setText(selectedDataSetName);
            }
        }
    }

    private DataSetHandle getDataSetHandle() {
        return this.inputParameter.getModuleHandle().findDataSet(this.dataSetChooser.getText());
    }

    private void refreshColumns(boolean onlyFilter) {
        Iterator iter;
        if (this.columnChooser == null || this.columnChooser.isDisposed()) {
            return;
        }
        if (!onlyFilter) {
            DataSetHandle dataSetHandle = this.getDataSetHandle();
            try {
                this.columnList = DataUtil.getColumnList(dataSetHandle);
            }
            catch (SemanticException e) {
                ExceptionHandler.handle(e);
            }
            this.displayTextChooser.removeAll();
            this.displayTextChooser.add(NONE_DISPLAY_TEXT);
            iter = this.columnList.iterator();
            while (iter.hasNext()) {
                this.displayTextChooser.add(((ResultSetColumnHandle)iter.next()).getColumnName());
            }
            this.displayTextChooser.setText(NONE_DISPLAY_TEXT);
        }
        String originalSelection = this.columnChooser.getText();
        this.columnChooser.removeAll();
        iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!this.matchDataType(cachedColumn)) continue;
            this.columnChooser.add(cachedColumn.getColumnName());
        }
        if (this.columnChooser.indexOf(originalSelection) != -1) {
            this.columnChooser.setText(originalSelection);
        }
        this.columnChooser.setEnabled(this.columnChooser.getItemCount() > 0);
        this.updateMessageLine();
    }

    private boolean matchDataType(ResultSetColumnHandle column) {
        String type = this.getSelectedDataType();
        if (type.equals("string") || "any".equals(column.getDataType())) {
            return true;
        }
        if ("date-time".equals(column.getDataType())) {
            return type.equals("dateTime");
        }
        if ("decimal".equals(column.getDataType())) {
            return type.equals("decimal");
        }
        if ("float".equals(column.getDataType())) {
            return type.equals("float");
        }
        if ("integer".equals(column.getDataType())) {
            return type.equals("integer");
        }
        return false;
    }

    private String getInputControlType() {
        String type = null;
        type = this.inputParameter.getControlType() == null ? "text-box" : ("list-box".equals(this.inputParameter.getControlType()) ? (this.inputParameter.isMustMatch() ? PARAM_CONTROL_LIST : PARAM_CONTROL_COMBO) : this.inputParameter.getControlType());
        return type;
    }

    private String getSelectedDataType() {
        String type = null;
        if (StringUtil.isBlank((String)this.dataTypeChooser.getText())) {
            type = this.inputParameter.getDataType();
        } else {
            IChoice choice = DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText());
            type = choice.getName();
        }
        return type;
    }

    private String getSelectedControlType() {
        String displayText = this.controlTypeChooser.getText();
        if (StringUtil.isBlank((String)displayText)) {
            return this.getInputControlType();
        }
        if (DISPLAY_NAME_CONTROL_COMBO.equals(displayText)) {
            return PARAM_CONTROL_COMBO;
        }
        if (DISPLAY_NAME_CONTROL_LIST.equals(displayText)) {
            return PARAM_CONTROL_LIST;
        }
        return CONTROL_TYPE_CHOICE_SET.findChoiceByDisplayName(displayText).getName();
    }

    private void changeDataType() {
        String type = this.getSelectedDataType();
        if (type.equals(this.lastDataType)) {
            return;
        }
        if (this.buildControlTypeList(type)) {
            this.changeControlType();
        }
        this.lastDataType = type;
        this.initFormatField();
        if (this.isStatic()) {
            this.makeUniqueAndValid();
            this.refreshValueTable();
        } else {
            this.refreshColumns(true);
        }
        this.updateMessageLine();
    }

    private boolean buildControlTypeList(String type) {
        String[] choices = this.isStatic() ? ("boolean".equals(type) ? new String[3] : new String[4]) : new String[2];
        if (this.controlTypeChooser.getItemCount() != choices.length) {
            String originalSelection = this.controlTypeChooser.getText();
            if (this.isStatic()) {
                if ("boolean".equals(type)) {
                    choices[0] = CONTROL_TYPE_CHOICE_SET.findChoice("check-box").getDisplayName();
                    choices[1] = DISPLAY_NAME_CONTROL_COMBO;
                } else {
                    choices[0] = CONTROL_TYPE_CHOICE_SET.findChoice("text-box").getDisplayName();
                    choices[1] = DISPLAY_NAME_CONTROL_COMBO;
                    choices[2] = DISPLAY_NAME_CONTROL_LIST;
                }
                choices[choices.length - 1] = CONTROL_TYPE_CHOICE_SET.findChoice("radio-button").getDisplayName();
            } else {
                choices[0] = DISPLAY_NAME_CONTROL_COMBO;
                choices[1] = DISPLAY_NAME_CONTROL_LIST;
            }
            this.controlTypeChooser.setItems(choices);
            if (originalSelection.length() == 0) {
                this.controlTypeChooser.setText(this.getInputControlDisplayName());
            } else {
                int index = this.controlTypeChooser.indexOf(originalSelection);
                if (index == -1) {
                    this.controlTypeChooser.select(0);
                    return true;
                }
                this.controlTypeChooser.setText(originalSelection);
            }
        }
        return false;
    }

    private void makeUniqueAndValid() {
        Iterator iter = this.choiceList.iterator();
        while (iter.hasNext()) {
            SelectionChoice choice = (SelectionChoice)iter.next();
            if (this.isValidValue(choice.getValue()) == null && !this.containValue(choice, choice.getValue(), COLUMN_VALUE)) continue;
            iter.remove();
        }
    }

    private void changeControlType() {
        String type;
        if (this.isStatic() && !(type = this.getSelectedControlType()).equals(this.lastControlType)) {
            if ("check-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToCheckBox();
            } else if (PARAM_CONTROL_COMBO.equals(type) || PARAM_CONTROL_LIST.equals(type) || "radio-button".equals(type)) {
                if (!(PARAM_CONTROL_COMBO.equals(this.lastControlType) || PARAM_CONTROL_LIST.equals(this.lastControlType) || "radio-button".equals(this.lastControlType))) {
                    this.clearArea(this.valueArea);
                    this.switchToList();
                }
            } else if ("text-box".equals(type)) {
                this.clearArea(this.valueArea);
                this.switchToText();
            }
            this.valueArea.layout();
            this.initValueArea();
            this.lastControlType = type;
        }
        this.updateCheckBoxArea();
        this.updateMessageLine();
        boolean radioEnable = false;
        if (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) {
            radioEnable = true;
        }
        if (radioEnable != this.staticRadio.isEnabled()) {
            this.staticRadio.setEnabled(radioEnable);
            this.dynamicRadio.setEnabled(radioEnable);
        }
        this.initFormatField();
    }

    private void switchParamterType() {
        this.clearArea(this.valueArea);
        this.lastControlType = null;
        if (this.isStatic()) {
            this.switchToStatic();
        } else {
            this.switchToDynamic();
        }
        this.buildControlTypeList(this.getSelectedDataType());
        this.valueArea.layout();
        this.initValueArea();
        this.updateCheckBoxArea();
    }

    private void switchToCheckBox() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueChooser = new Combo(this.valueArea, 2056);
        this.defaultValueChooser.add(CHOICE_NO_DEFAULT);
        this.defaultValueChooser.add(BOOLEAN_TRUE);
        this.defaultValueChooser.add(BOOLEAN_FALSE);
        this.defaultValueChooser.setLayoutData((Object)new GridData(768));
        this.defaultValueChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                switch (ParameterDialog.this.defaultValueChooser.getSelectionIndex()) {
                    case 0: {
                        ParameterDialog.this.defaultValue = null;
                        break;
                    }
                    case 1: {
                        ParameterDialog.this.defaultValue = Boolean.toString(true);
                        break;
                    }
                    case 2: {
                        ParameterDialog.this.defaultValue = Boolean.toString(false);
                    }
                }
            }
        });
    }

    private void switchToList() {
        this.createLabel(this.valueArea, LABEL_VALUES);
        Composite tableAreaComposite = new Composite(this.valueArea, 0);
        tableAreaComposite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin());
        tableAreaComposite.setLayoutData((Object)new GridData(1808));
        TableArea tableArea = new TableArea(tableAreaComposite, 67588, this.tableAreaModifier);
        tableArea.setLayoutData(new GridData(1808));
        Table table = tableArea.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        String[] columns = new String[]{null, COLUMN_IS_DEFAULT, COLUMN_VALUE, COLUMN_DISPLAY_TEXT};
        int[] columnWidth = new int[]{20, 70, 145, 145};
        for (int i = 0; i < columns.length; ++i) {
            TableColumn column = new TableColumn(table, 16384);
            column.setResizable(columns[i] != null);
            if (columns[i] != null) {
                column.setText(columns[i]);
            }
            column.setWidth(columnWidth[i]);
        }
        this.valueTable = tableArea.getTableViewer();
        this.valueTable.setColumnProperties(columns);
        this.valueTable.setContentProvider((IContentProvider)this.contentProvider);
        this.valueTable.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        tableArea.setInput(this.choiceList);
        this.valueTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterDialog.this.updateTableButtons();
            }
        });
        Composite buttonBar = new Composite(tableAreaComposite, 0);
        buttonBar.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(4, false));
        buttonBar.setLayoutData((Object)new GridData(768));
        this.importValue = new Button(buttonBar, 8);
        this.importValue.setText(BUTTON_LABEL_IMPORT);
        this.setButtonLayoutData(this.importValue);
        this.importValue.setEnabled(!this.inputParameter.getModuleHandle().getVisibleDataSets().isEmpty());
        this.importValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String type = ParameterDialog.this.getSelectedDataType();
                ImportValueDialog dialog = new ImportValueDialog(type);
                if (dialog.open() == 0) {
                    String[] importValues = (String[])dialog.getResult();
                    ArrayList<String> valueToAddList = new ArrayList<String>(importValues.length);
                    for (int i = 0; i < importValues.length; ++i) {
                        if (ParameterDialog.this.containValue(null, importValues[i], COLUMN_VALUE)) continue;
                        valueToAddList.add(importValues[i]);
                    }
                    Iterator iter = valueToAddList.iterator();
                    while (iter.hasNext()) {
                        SelectionChoice choice = StructureFactory.createSelectionChoice();
                        choice.setValue((String)iter.next());
                        ParameterDialog.this.choiceList.add(choice);
                    }
                    ParameterDialog.this.refreshValueTable();
                }
            }
        });
        this.changeDefault = new Button(buttonBar, 2);
        this.changeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectionChoice choice = (SelectionChoice)((IStructuredSelection)ParameterDialog.this.valueTable.getSelection()).getFirstElement();
                if (ParameterDialog.this.isDefaultChoice(choice)) {
                    ParameterDialog.this.changeDefaultValue(null);
                } else {
                    ParameterDialog.this.changeDefaultValue(choice.getValue());
                }
                ParameterDialog.this.refreshValueTable();
                ParameterDialog.this.changeDefault.getParent().layout();
            }
        });
        this.createPromptLine(tableAreaComposite);
        this.updateTableButtons();
        this.createSortingArea(this.valueArea);
    }

    private void switchToText() {
        this.createDefaultEditor();
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
    }

    private void switchToStatic() {
        this.changeControlType();
        this.listLimit.setEditable(false);
    }

    private void switchToDynamic() {
        Composite composite = new Composite(this.valueArea, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(3, false));
        this.createLabel(composite, LABEL_SELECT_DATA_SET);
        this.dataSetChooser = new Combo(composite, 2056);
        this.dataSetChooser.setLayoutData((Object)new GridData(768));
        this.dataSetChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
            }

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.refreshColumns(false);
            }
        });
        this.createDataSet = new Button(composite, 8);
        this.createDataSet.setText(BUTTON_CREATE_DATA_SET);
        this.setButtonLayoutData(this.createDataSet);
        this.createDataSet.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                new NewDataSetAction().run();
                ParameterDialog.this.refreshDataSets();
            }
        });
        this.createLabel(composite, LABEL_SELECT_VALUE_COLUMN);
        this.columnChooser = new Combo(composite, 2056);
        this.columnChooser.setLayoutData((Object)new GridData(768));
        this.columnChooser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.updateButtons();
            }
        });
        this.createLabel(composite, null);
        this.createLabel(composite, LABEL_SELECT_DISPLAY_TEXT);
        this.displayTextChooser = new Combo(composite, 2056);
        this.displayTextChooser.setLayoutData((Object)new GridData(768));
        this.createDefaultEditor();
        this.createSortingArea(this.valueArea);
        this.createLabel(this.valueArea, null);
        this.createPromptLine(this.valueArea);
        this.listLimit.setEditable(true);
    }

    private void createSortingArea(Composite parent) {
        this.sorttingArea = new Composite(parent, 0);
        GridData sorttingAreaGridData = new GridData(776);
        sorttingAreaGridData.horizontalSpan = 2;
        this.sorttingArea.setLayoutData((Object)sorttingAreaGridData);
        this.sorttingArea.setLayout((Layout)UIUtil.createGridLayoutWithoutMargin(1, false));
        Group sortGroup = new Group(this.sorttingArea, 0);
        sortGroup.setText(LABEL_SORT_GROUP);
        sortGroup.setLayout((Layout)new GridLayout(2, false));
        sortGroup.setLayoutData((Object)new GridData(768));
        Composite sortKeyArea = new Composite((Composite)sortGroup, 0);
        sortKeyArea.setLayoutData((Object)new GridData(768));
        sortKeyArea.setLayout((Layout)new GridLayout(2, false));
        this.sortKeyLabel = new Label(sortKeyArea, 0);
        this.sortKeyLabel.setText(LABEL_SORT_KEY);
        this.sortKeyChooser = new Combo(sortKeyArea, 2048);
        this.sortKeyChooser.setLayoutData((Object)new GridData(768));
        this.sortKeyChooser.add(CHOICE_NONE);
        this.sortKeyChooser.add(CHOICE_DISPLAY_TEXT);
        this.sortKeyChooser.add(CHOICE_VALUE_COLUMN);
        this.sortKeyChooser.setText(CHOICE_NONE);
        this.sortKeyChooser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (!((Combo)e.widget).getText().equals(CHOICE_NONE)) {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(true);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(true);
                    ParameterDialog.this.distinct.setEnabled(true);
                } else {
                    ParameterDialog.this.sortDirectionLabel.setEnabled(false);
                    ParameterDialog.this.sortDirectionChooser.setEnabled(false);
                    ParameterDialog.this.distinct.setEnabled(false);
                }
            }
        });
        Composite sortDirectionArea = new Composite((Composite)sortGroup, 0);
        sortDirectionArea.setLayoutData((Object)new GridData(768));
        sortDirectionArea.setLayout((Layout)new GridLayout(2, false));
        this.sortDirectionLabel = new Label(sortDirectionArea, 0);
        this.sortDirectionLabel.setText(LABEL_SORT_DIRECTION);
        this.sortDirectionChooser = new Combo(sortDirectionArea, 2048);
        this.sortDirectionChooser.setLayoutData((Object)new GridData(768));
        this.sortDirectionChooser.add(CHOICE_ASCENDING);
        this.sortDirectionChooser.add(CHOICE_DESCENDING);
        this.sortDirectionChooser.setText(CHOICE_ASCENDING);
        Composite distinctBtnArea = new Composite((Composite)sortGroup, 0);
        distinctBtnArea.setLayoutData((Object)new GridData(768));
        distinctBtnArea.setLayout((Layout)new GridLayout());
        this.distinct = new Button(distinctBtnArea, 32);
        this.distinct.setText(CHECKBOX_DISTINCT);
        this.distinct.setSelection(true);
    }

    private void createDefaultEditor() {
        this.createLabel(this.valueArea, LABEL_DEFAULT_VALUE);
        this.defaultValueEditor = new Text(this.valueArea, 2048);
        this.defaultValueEditor.setLayoutData((Object)new GridData(768));
        this.defaultValueEditor.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParameterDialog.this.changeDefaultValue(UIUtil.convertToModelString(ParameterDialog.this.defaultValueEditor.getText(), false));
                if (ParameterDialog.this.isStatic()) {
                    ParameterDialog.this.refreshValueTable();
                }
            }
        });
    }

    private void createPromptLine(Composite parent) {
        this.promptMessageLine = new Label(parent, 0);
        this.promptMessageLine.setLayoutData((Object)new GridData(768));
    }

    protected void okPressed() {
        try {
            this.inputParameter.setName(this.nameEditor.getText());
            this.inputParameter.setPromptText(UIUtil.convertToModelString(this.promptTextEditor.getText(), true));
            String newControlType = this.getSelectedControlType();
            if (PARAM_CONTROL_COMBO.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(false);
            } else if (PARAM_CONTROL_LIST.equals(newControlType)) {
                newControlType = "list-box";
                this.inputParameter.setMustMatch(true);
            } else {
                this.inputParameter.setProperty("mustMatch", null);
            }
            this.inputParameter.setControlType(newControlType);
            if ("dateTime".equals(this.getSelectedDataType())) {
                this.defaultValue = DEUtil.convertToXMLString((Date)DataTypeUtil.toDate((String)this.defaultValue, (ULocale)ULocale.US));
            }
            this.inputParameter.setDefaultValue(this.defaultValue);
            this.inputParameter.setDataType(DATA_TYPE_CHOICE_SET.findChoiceByDisplayName(this.dataTypeChooser.getText()).getName());
            PropertyHandle selectionChioceList = this.inputParameter.getPropertyHandle("selectionList");
            selectionChioceList.setValue(null);
            if (this.isStatic()) {
                this.inputParameter.setValueType("static");
                if (!"text-box".equals(newControlType) && !"check-box".equals(newControlType)) {
                    Iterator iter = this.choiceList.iterator();
                    while (iter.hasNext()) {
                        SelectionChoice choice = (SelectionChoice)iter.next();
                        if (this.isValidValue(choice.getValue()) != null) continue;
                        selectionChioceList.addItem((IStructure)choice);
                    }
                }
                this.inputParameter.setDataSetName(null);
                this.inputParameter.setValueExpr(null);
                this.inputParameter.setLabelExpr(null);
            } else {
                this.inputParameter.setValueType("dynamic");
                this.inputParameter.setDataSetName(this.dataSetChooser.getText());
                this.inputParameter.setValueExpr(this.getExpression(this.columnChooser.getText()));
                if (this.displayTextChooser.getText().equals(LABEL_NULL)) {
                    this.inputParameter.setLabelExpr("");
                } else {
                    this.inputParameter.setLabelExpr(this.getExpression(this.displayTextChooser.getText()));
                }
            }
            this.inputParameter.setHelpText(UIUtil.convertToModelString(this.helpTextEditor.getText(), false));
            this.inputParameter.setCategory(this.formatCategroy);
            this.inputParameter.setPattern(this.formatPattern);
            if (this.isStatic() && (PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) || "radio-button".equals(this.getSelectedControlType())) && !this.containValue(null, this.defaultValue, COLUMN_VALUE)) {
                this.defaultValue = null;
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_HIDDEN)) {
                this.inputParameter.setHidden(this.getProperty(CHECKBOX_HIDDEN));
            }
            if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_NULL)) {
                this.inputParameter.setAllowNull(this.getProperty(CHECKBOX_ALLOW_NULL));
            }
            if (this.allowBlank.isEnabled()) {
                if (this.dirtyProperties.containsKey(CHECKBOX_ALLOW_BLANK)) {
                    this.inputParameter.setAllowBlank(this.getProperty(CHECKBOX_ALLOW_BLANK));
                }
            } else {
                this.inputParameter.setProperty("allowBlank", null);
            }
            if (this.doNotEcho.isEnabled()) {
                if (this.dirtyProperties.containsKey(CHECKBOX_DO_NOT_ECHO)) {
                    this.inputParameter.setConcealValue(this.getProperty(CHECKBOX_DO_NOT_ECHO));
                }
            } else {
                this.inputParameter.setProperty("concealValue", null);
            }
            if (this.sorttingArea != null && !this.sorttingArea.isDisposed() && this.sorttingArea.isVisible()) {
                if (!this.sortKeyChooser.getText().equals(CHOICE_NONE)) {
                    this.inputParameter.setFixedOrder(false);
                    this.inputParameter.setDistinct(!this.distinct.getSelection());
                    if (this.sortKeyChooser.getText().equals(CHOICE_DISPLAY_TEXT)) {
                        this.inputParameter.setSortBy("label");
                    } else if (this.sortKeyChooser.getText().equals(CHOICE_VALUE_COLUMN)) {
                        this.inputParameter.setSortBy("value");
                    }
                    if (this.sortDirectionChooser.getText().equals(CHOICE_ASCENDING)) {
                        this.inputParameter.setSortDirection("asc");
                    } else if (this.sortDirectionChooser.getText().equals(CHOICE_DESCENDING)) {
                        this.inputParameter.setSortDirection("desc");
                    }
                } else {
                    this.inputParameter.setFixedOrder(true);
                    this.inputParameter.setSortBy(null);
                    this.inputParameter.setSortDirection(null);
                    this.inputParameter.setDistinct(false);
                }
            } else {
                this.inputParameter.setProperty("fixedOrder", null);
            }
            if (!this.isStatic() && !StringUtil.isBlank((String)this.listLimit.getText())) {
                try {
                    this.inputParameter.setListlimit(Integer.parseInt(this.listLimit.getText()));
                }
                catch (NumberFormatException ex) {
                    ExceptionHandler.openErrorMessageBox(ERROR_TITLE_INVALID_LIST_LIMIT, MessageFormat.format(ERROR_MSG_INVALID_LIST_LIMIT, Integer.toString(Integer.MAX_VALUE)));
                }
            } else {
                this.inputParameter.setProperty("listLimit", null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle(e);
            return;
        }
        this.setResult(this.inputParameter);
        super.okPressed();
    }

    private void createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        if (content != null) {
            label.setText(content);
        }
        this.setLabelLayoutData(label);
    }

    private void setLabelLayoutData(Label label) {
        GridData gd = new GridData();
        if (label.getText().equals(LABEL_VALUES)) {
            gd.verticalAlignment = 1;
        }
        label.setLayoutData((Object)gd);
    }

    private void addCheckBoxListener(final Button checkBox, final String key) {
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ParameterDialog.this.checkBoxChange(checkBox, key);
            }
        });
    }

    protected void checkBoxChange(Button checkBox, String key) {
        this.dirtyProperties.put(key, new Boolean(checkBox.getSelection()));
        if (CHECKBOX_ALLOW_BLANK.equals(key) || CHECKBOX_ALLOW_NULL.equals(key)) {
            if (this.isStatic()) {
                this.makeUniqueAndValid();
                this.refreshValueTable();
            }
            this.updateMessageLine();
        }
    }

    private void clearArea(Composite area) {
        Control[] children = area.getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].dispose();
        }
    }

    private void updateTableButtons() {
        boolean isDefault;
        boolean isEnable = true;
        SelectionChoice selectedChoice = null;
        if (this.valueTable.getSelection().isEmpty()) {
            isEnable = false;
        } else {
            selectedChoice = (SelectionChoice)((IStructuredSelection)this.valueTable.getSelection()).getFirstElement();
        }
        boolean bl = isDefault = isEnable && this.isDefaultChoice(selectedChoice);
        if (isDefault) {
            this.changeDefault.setText(BUTTON_LABEL_REMOVE_DEFAULT);
        } else {
            this.changeDefault.setText(BUTTON_LABEL_SET_DEFAULT);
        }
        this.changeDefault.setSelection(isDefault);
        this.changeDefault.setEnabled(isEnable);
    }

    private void updateButtons() {
        boolean canFinish;
        boolean bl = canFinish = !StringUtil.isBlank((String)this.nameEditor.getText());
        if (canFinish) {
            if (this.errorMessageLine != null && !this.errorMessageLine.isDisposed()) {
                boolean bl2 = canFinish = this.errorMessageLine.getImage() == null;
            }
            if (this.columnChooser != null && !this.columnChooser.isDisposed() && !this.isStatic()) {
                canFinish &= this.getExpression(this.columnChooser.getText()) != null;
            }
        }
        this.getOkButton().setEnabled(canFinish);
    }

    private void updateCheckBoxArea() {
        if (("text-box".equals(this.getSelectedControlType()) || PARAM_CONTROL_LIST.equals(this.getSelectedControlType())) && "string".equals(this.getSelectedDataType())) {
            this.allowBlank.setEnabled(true);
        } else {
            this.allowBlank.setEnabled(false);
        }
        if ("text-box".equals(this.getSelectedControlType())) {
            this.doNotEcho.setEnabled(true);
        } else {
            this.doNotEcho.setEnabled(false);
        }
    }

    private void updateMessageLine() {
        String errorMessage = this.validateName();
        if (errorMessage == null) {
            if (!this.isStatic() && this.columnChooser != null && !this.columnChooser.isDisposed() && this.columnChooser.getItemCount() == 0) {
                errorMessage = ERROR_MSG_NO_AVAILABLE_COLUMN;
            } else if (!(this.defaultValue != null || !PARAM_CONTROL_COMBO.equals(this.getSelectedControlType()) && !"radio-button".equals(this.getSelectedControlType()) || this.canBeNull() && this.containValue(null, null, COLUMN_VALUE))) {
                errorMessage = ERROR_MSG_NO_DEFAULT_VALUE;
            }
        }
        if (errorMessage != null) {
            this.errorMessageLine.setText(errorMessage);
            this.errorMessageLine.setImage(ERROR_ICON);
        } else {
            this.errorMessageLine.setText("");
            this.errorMessageLine.setImage(null);
        }
        if (this.promptMessageLine != null && !this.promptMessageLine.isDisposed()) {
            if ("dateTime".equals(this.getSelectedDataType())) {
                this.promptMessageLine.setText(LABEL_DATETIME_PROMPT);
            } else {
                this.promptMessageLine.setText("");
            }
        }
        this.updateButtons();
    }

    private String validateName() {
        String name = this.nameEditor.getText().trim();
        if (name.length() == 0) {
            return ERROR_MSG_NAME_IS_EMPTY;
        }
        if (!name.equals(this.inputParameter.getName()) && this.inputParameter.getModuleHandle().findParameter(name) != null) {
            return ERROR_MSG_DUPLICATED_NAME;
        }
        return null;
    }

    private void refreshValueTable() {
        if (this.valueTable != null && !this.valueTable.getTable().isDisposed()) {
            this.valueTable.refresh();
            this.updateTableButtons();
        }
    }

    private boolean getProperty(String key) {
        return (Boolean)this.dirtyProperties.get(key);
    }

    private String format(String string) {
        if (this.canBeNull() && string == null) {
            return LABEL_NULL;
        }
        if (StringUtil.isBlank((String)string) || this.formatCategroy == null) {
            return string;
        }
        try {
            String type;
            String pattern = this.formatPattern;
            if (this.formatPattern == null) {
                if (this.isCustom()) {
                    return string;
                }
                pattern = this.formatCategroy;
            }
            if ("dateTime".equals(type = this.getSelectedDataType())) {
                Date date = DataTypeUtil.toDate((String)string, (ULocale)ULocale.US);
                string = new DateFormatter(pattern).format(date);
            } else if ("float".equals(type)) {
                string = new NumberFormatter(pattern).format(DataTypeUtil.toDouble((Object)string).doubleValue());
            } else if ("decimal".equals(type)) {
                string = new NumberFormatter(pattern).format(DataTypeUtil.toBigDecimal((Object)string));
            } else if ("string".equals(type)) {
                string = new StringFormatter(pattern).format(string);
            }
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        return string;
    }

    private String isValidValue(String value) {
        if (this.canBeNull()) {
            if (value == null || value.length() == 0) {
                return null;
            }
        } else if (value == null || value.length() == 0) {
            return ERROR_MSG_CANNOT_BE_NULL;
        }
        if (this.canBeBlank()) {
            if (StringUtil.isBlank((String)value)) {
                return null;
            }
        } else if (StringUtil.isBlank((String)value)) {
            return ERROR_MSG_CANNOT_BE_BLANK;
        }
        try {
            this.getValue(value);
        }
        catch (BirtException e) {
            return ERROR_MSG_MISMATCH_DATA_TYPE;
        }
        return null;
    }

    private boolean isEqual(String value1, String value2) {
        Object v1 = null;
        Object v2 = null;
        try {
            v1 = this.getValue(value1);
            v2 = this.getValue(value2);
        }
        catch (BirtException e) {
            // empty catch block
        }
        if (v1 == null) {
            return v2 == null;
        }
        if (v1 instanceof Double && v2 instanceof Double) {
            return ((Double)v1).compareTo((Double)v2) == 0;
        }
        if (v1 instanceof BigDecimal && v2 instanceof BigDecimal) {
            return ((BigDecimal)v1).compareTo((BigDecimal)v2) == 0;
        }
        if (v1 instanceof Integer && v2 instanceof Integer) {
            return ((Integer)v1).compareTo((Integer)v2) == 0;
        }
        return v1.equals(v2);
    }

    private Object getValue(String value) throws BirtException {
        if ("boolean".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("decimal".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("dateTime".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toDate((String)value, (ULocale)ULocale.US);
        }
        if ("float".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("integer".equals(this.getSelectedDataType())) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }

    private IChoiceSet getFormatChoiceSet(String type) {
        IChoiceSet choiceSet = null;
        if ("string".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat");
        } else if ("dateTime".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("dateTimeFormat");
        } else if ("decimal".equals(type) || "float".equals(type) || "integer".equals(type)) {
            choiceSet = DEUtil.getMetaDataDictionary().getChoiceSet("numberFormat");
        }
        return choiceSet;
    }

    private void updateFormatField() {
        String previewString;
        String displayFormat;
        String type = this.getSelectedDataType();
        IChoiceSet choiceSet = this.getFormatChoiceSet(type);
        if (choiceSet == null) {
            displayFormat = DEUtil.getMetaDataDictionary().getChoiceSet("stringFormat").findChoice("Unformatted").getDisplayName();
            previewString = "True";
        } else {
            displayFormat = choiceSet.findChoice(this.formatCategroy).getDisplayName();
            if (this.isCustom()) {
                displayFormat = displayFormat + ": " + this.formatPattern;
            }
            previewString = this.defaultValue != null ? this.format(this.defaultValue) : (type.equals("dateTime") ? new DateFormatter(this.isCustom() ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(new Date()) : (type.equals("string") ? new StringFormatter(this.isCustom() ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(Messages.getString((String)"ParameterDialog.Label.Sample")) : (type.equals("integer") ? new NumberFormatter(this.isCustom() ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(1234567890L) : new NumberFormatter(this.isCustom() ? this.formatPattern : this.formatCategroy, ULocale.getDefault()).format(1.2345678901234E8))));
        }
        this.formatField.setText(displayFormat);
        this.previewLabel.setText(this.convertNullString(previewString));
        this.changeFormat.setEnabled(choiceSet != null);
    }

    private String convertNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    private boolean containValue(SelectionChoice selectedChoice, String newValue, String property) {
        Iterator iter = this.choiceList.iterator();
        while (iter.hasNext()) {
            SelectionChoice choice = (SelectionChoice)iter.next();
            if (choice == selectedChoice) continue;
            String value = null;
            if (COLUMN_VALUE.equals(property) && this.isEqual(value = choice.getValue(), newValue)) {
                return true;
            }
            if (!COLUMN_DISPLAY_TEXT.equals(property)) continue;
            value = choice.getLabel();
            if (value == null) {
                value = choice.getValue();
            }
            if (value == null) {
                value = LABEL_NULL;
            }
            if (!value.equals(newValue)) continue;
            return true;
        }
        return false;
    }

    private void popupFormatBuilder(boolean refresh) {
        String dataType = this.getSelectedDataType();
        if ("boolean".equals(dataType)) {
            return;
        }
        int formatType = "string".equals(dataType) ? 1 : ("dateTime".equals(dataType) ? 3 : 2);
        FormatBuilder formatBuilder = new FormatBuilder(formatType);
        formatBuilder.setInputFormat(this.formatCategroy, this.formatPattern);
        formatBuilder.setPreviewText(this.defaultValue);
        if (formatBuilder.open() == 0) {
            this.formatCategroy = ((String[])formatBuilder.getResult())[0];
            this.formatPattern = ((String[])formatBuilder.getResult())[1];
            this.updateFormatField();
            if (refresh) {
                this.refreshValueTable();
            }
        }
    }

    private boolean canBeBlank() {
        boolean canBeBlank = false;
        if (PARAM_CONTROL_LIST.equals(this.getSelectedControlType()) || "text-box".equals(this.getSelectedControlType())) {
            canBeBlank = this.dirtyProperties.containsKey(CHECKBOX_ALLOW_BLANK) ? ((Boolean)this.dirtyProperties.get(CHECKBOX_ALLOW_BLANK)).booleanValue() : this.inputParameter.allowBlank();
        }
        return canBeBlank;
    }

    private boolean canBeNull() {
        boolean canBeNull = false;
        canBeNull = this.dirtyProperties.containsKey(CHECKBOX_ALLOW_NULL) ? ((Boolean)this.dirtyProperties.get(CHECKBOX_ALLOW_NULL)).booleanValue() : this.inputParameter.allowNull();
        return canBeNull;
    }

    private boolean isDefaultChoice(SelectionChoice choice) {
        String choiceValue = choice.getValue();
        String defaultValue = this.convertToStandardFormat(this.defaultValue);
        if (this.canBeNull() && choiceValue == null && defaultValue == null) {
            return true;
        }
        return choiceValue != null && this.isEqual(choiceValue, defaultValue);
    }

    private boolean isStatic() {
        return this.staticRadio.getSelection();
    }

    private String convertToStandardFormat(String string) {
        if (string != null && "dateTime".equals(this.getSelectedDataType())) {
            try {
                string = this.convertToStandardFormat(DataTypeUtil.toDate((String)string, (ULocale)ULocale.US));
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        return string;
    }

    private String convertToStandardFormat(Date date) {
        if (date == null) {
            return null;
        }
        return new DateFormatter(STANDARD_DATE_TIME_PATTERN, ULocale.US).format(date);
    }

    private String getExpression(String columnName) {
        if (columnName.equals(NONE_DISPLAY_TEXT)) {
            return null;
        }
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!cachedColumn.getColumnName().equals(columnName)) continue;
            return DEUtil.getExpression((Object)cachedColumn);
        }
        return null;
    }

    private String getColumnName(String expression) {
        Iterator iter = this.columnList.iterator();
        while (iter.hasNext()) {
            ResultSetColumnHandle cachedColumn = (ResultSetColumnHandle)iter.next();
            if (!DEUtil.getExpression((Object)cachedColumn).equals(expression)) continue;
            return cachedColumn.getColumnName();
        }
        return null;
    }

    private String getInputControlDisplayName() {
        String type = this.getInputControlType();
        String displayName = null;
        if (CONTROL_TYPE_CHOICE_SET.findChoice(type) != null) {
            displayName = CONTROL_TYPE_CHOICE_SET.findChoice(type).getDisplayName();
        } else if (PARAM_CONTROL_COMBO.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_COMBO;
        } else if (PARAM_CONTROL_LIST.equals(type)) {
            displayName = DISPLAY_NAME_CONTROL_LIST;
        }
        return displayName;
    }

    private String validateChoice(SelectionChoice choice, String displayLabel, String value) {
        String errorMessage = this.isValidValue(value);
        if (errorMessage != null) {
            return errorMessage;
        }
        String newValue = this.convertToStandardFormat(value);
        if (displayLabel == null && this.containValue(choice, newValue, COLUMN_DISPLAY_TEXT) || this.containValue(choice, displayLabel, COLUMN_DISPLAY_TEXT)) {
            return ERROR_MSG_DUPLICATED_LABEL;
        }
        if (this.containValue(choice, newValue, COLUMN_VALUE)) {
            return ERROR_MSG_DUPLICATED_VALUE;
        }
        return null;
    }

    private void changeDefaultValue(String value) {
        this.defaultValue = value;
        this.updateFormatField();
        this.updateMessageLine();
    }

    private boolean isCustom() {
        return "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy) || "Custom".equals(this.formatCategroy);
    }

    static /* synthetic */ String access$600(ParameterDialog x0, SelectionChoice x1, String x2, String x3) {
        return x0.validateChoice(x1, x2, x3);
    }
}

