/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.FontManager;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.ComputedColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SortkeyBuilder
extends BaseDialog {
    public static final String DLG_TITLE_NEW = Messages.getString((String)"SortkeyBuilder.DialogTitle.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"SortkeyBuilder.DialogTitle.Edit");
    private SortKeyHandle input;
    private DesignElementHandle handle;
    private IChoiceSet choiceSet;
    private Combo comboDirection;
    private Combo comboKey;
    private List columnList;
    private static final String[] EMPTY = new String[0];
    private Listener ComboKeyModify = new Listener(){

        public void handleEvent(Event e) {
            Assert.isLegal((boolean)(e.widget instanceof Combo));
            Combo combo = (Combo)e.widget;
            String newValue = combo.getText();
            String value = DEUtil.getExpression((Object)SortkeyBuilder.this.getResultSetColumn(newValue));
            if (value != null) {
                newValue = value;
            }
            combo.setText(newValue);
            SortkeyBuilder.this.updateButtons();
        }
    };

    public SortkeyBuilder(String title) {
        this(UIUtil.getDefaultShell(), title);
    }

    public SortkeyBuilder(Shell parentShell, String title) {
        super(parentShell, title);
        this.choiceSet = ChoiceSetFactory.getStructChoiceSet("SortKey", "direction");
    }

    protected Control createContents(Composite parent) {
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.AddEditSortkey_ID");
        Composite contents = new Composite(parent, 0);
        contents.setLayout((Layout)new GridLayout());
        contents.setLayoutData((Object)new GridData(1808));
        this.createTitleArea(contents);
        Composite composite = new Composite(contents, 0);
        GridLayout glayout = new GridLayout();
        glayout.marginHeight = 0;
        glayout.marginWidth = 0;
        glayout.verticalSpacing = 0;
        composite.setLayout((Layout)glayout);
        composite.setLayoutData((Object)new GridData(1808));
        SortkeyBuilder.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        Composite innerParent = (Composite)this.createDialogArea(composite);
        this.createButtonBar(composite);
        this.createInputContents(innerParent);
        Composite space = new Composite(innerParent, 0);
        GridData gdata = new GridData(768);
        gdata.heightHint = 10;
        space.setLayoutData((Object)gdata);
        Label lb = new Label(innerParent, 258);
        lb.setLayoutData((Object)new GridData(768));
        this.updateButtons();
        return composite;
    }

    private Composite createInputContents(Composite parent) {
        Label lb = new Label(parent, 0);
        lb.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Prompt"));
        Composite content = new Composite(parent, 0);
        content.setLayoutData((Object)new GridData(768));
        GridLayout glayout = new GridLayout(3, false);
        content.setLayout((Layout)glayout);
        Label labelKey = new Label(content, 0);
        labelKey.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Key"));
        this.comboKey = new Combo(content, 2048);
        GridData gdata = new GridData();
        gdata.widthHint = 200;
        this.comboKey.setLayoutData((Object)gdata);
        this.comboKey.setItems(this.getDataSetColumns());
        if (this.comboKey.getItemCount() == 0) {
            this.comboKey.add(DEUtil.resolveNull(null));
        }
        this.comboKey.addListener(13, this.ComboKeyModify);
        this.comboKey.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SortkeyBuilder.this.updateButtons();
            }
        });
        Button btnExpression = new Button(content, 0);
        btnExpression.setText("...");
        gdata = new GridData();
        gdata.heightHint = 20;
        gdata.widthHint = 20;
        btnExpression.setLayoutData((Object)gdata);
        btnExpression.setToolTipText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Button.ExpressionBuilder"));
        btnExpression.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newValue;
                String oldValue = SortkeyBuilder.this.comboKey.getText();
                ExpressionBuilder dialog = new ExpressionBuilder(UIUtil.getDefaultShell(), oldValue);
                dialog.setExpressionProvier(new ExpressionProvider(SortkeyBuilder.this.handle));
                if (dialog.open() == 0 && !(newValue = dialog.getResult()).equals(oldValue)) {
                    SortkeyBuilder.this.comboKey.setText(newValue);
                }
                SortkeyBuilder.this.updateButtons();
            }
        });
        Label labelDirection = new Label(content, 0);
        labelDirection.setText(Messages.getString((String)"SortkeyBuilder.DialogTitle.Label.Direction"));
        this.comboDirection = new Combo(content, 2056);
        gdata = new GridData(768);
        this.comboDirection.setLayoutData((Object)gdata);
        String[] displayNames = ChoiceSetFactory.getDisplayNamefromChoiceSet(this.choiceSet);
        this.comboDirection.setItems(displayNames);
        return content;
    }

    private Object getResultSetColumn(String name) {
        if (this.columnList.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.columnList.size(); ++i) {
            ComputedColumnHandle column = (ComputedColumnHandle)this.columnList.get(i);
            if (!column.getName().equals(name)) continue;
            return column;
        }
        return null;
    }

    private Composite createTitleArea(Composite parent) {
        int heightMargins = 3;
        int widthMargins = 8;
        final Composite titleArea = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = heightMargins;
        layout.marginWidth = widthMargins;
        titleArea.setLayout((Layout)layout);
        Display display = parent.getDisplay();
        Color background = JFaceColors.getBannerBackground((Display)display);
        GridData layoutData = new GridData(768);
        layoutData.heightHint = 20 + heightMargins * 2;
        titleArea.setLayoutData((Object)layoutData);
        titleArea.setBackground(background);
        titleArea.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setForeground(titleArea.getDisplay().getSystemColor(18));
                Rectangle bounds = titleArea.getClientArea();
                bounds.height -= 2;
                --bounds.width;
                e.gc.drawRectangle(bounds);
            }
        });
        Label label = new Label(titleArea, 0);
        label.setBackground(background);
        label.setFont(FontManager.getFont((String)label.getFont().toString(), (int)10, (int)1));
        label.setText(this.getTitle());
        return titleArea;
    }

    protected boolean initDialog() {
        if (this.input == null) {
            this.comboKey.setText("");
            this.comboDirection.select(0);
            return true;
        }
        if (this.input.getKey() != null && this.input.getKey().trim().length() != 0) {
            this.comboKey.setText(this.input.getKey().trim());
        }
        if (this.input.getDirection() != null && this.input.getDirection().trim().length() != 0) {
            int index;
            String value = this.input.getDirection().trim();
            IChoice choice = this.choiceSet.findChoice(value);
            if (choice != null) {
                value = choice.getDisplayName();
            }
            index = (index = this.comboDirection.indexOf(value)) < 0 ? 0 : index;
            this.comboDirection.select(index);
        }
        this.updateButtons();
        return true;
    }

    private String[] getDataSetColumns() {
        if (this.columnList.isEmpty()) {
            return EMPTY;
        }
        String[] values = new String[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            values[i] = ((ComputedColumnHandle)this.columnList.get(i)).getName();
        }
        return values;
    }

    public void setHandle(DesignElementHandle handle) {
        this.handle = handle;
        this.inilializeColumnList(handle);
    }

    private void inilializeColumnList(DesignElementHandle handle) {
        this.columnList = DEUtil.getVisiableColumnBindingsList((DesignElementHandle)handle);
    }

    protected void okPressed() {
        String direction = this.comboDirection.getText();
        IChoice choice = this.choiceSet.findChoiceByDisplayName(direction);
        if (choice != null) {
            direction = choice.getDisplayName();
        }
        int index = this.comboDirection.indexOf(direction);
        CommandStack stack = SessionHandleAdapter.getInstance().getCommandStack();
        stack.startTrans(this.getTitle());
        try {
            if (this.input == null) {
                SortKey sortKey = StructureFactory.createSortKey();
                sortKey.setKey(this.comboKey.getText().trim());
                if (index >= 0) {
                    sortKey.setDirection(choice.getName());
                }
                PropertyHandle propertyHandle = this.handle.getPropertyHandle("sort");
                propertyHandle.addItem((IStructure)sortKey);
            } else {
                this.input.setKey(this.comboKey.getText().trim());
                if (index >= 0) {
                    this.input.setDirection(choice.getName());
                }
            }
            stack.commit();
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e, Messages.getString((String)"SortkeyBuilder.DialogTitle.Error.SetSortKey.Title"), e.getLocalizedMessage());
            stack.rollback();
        }
        super.okPressed();
    }

    public void setInput(Object input) {
        this.input = input instanceof SortKeyHandle ? (SortKeyHandle)input : null;
    }

    private void updateButtons() {
        this.getOkButton().setEnabled(this.isConditionOK());
    }

    private boolean isConditionOK() {
        return this.comboKey.getText().trim().length() != 0;
    }
}

