/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preferences;

import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ResourcePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    Text resourceText;
    public static final String TITLE_LABEL = Messages.getString((String)"ResourecePreferencePage.title");
    public static final String FOLDER_LABEL = Messages.getString((String)"ResourecePreferencePage.folder");
    public static final String BROWSER_BUTTON = Messages.getString((String)"ResourecePreferencePage.select");
    public static final String OPEN_DIALOG_TITLE = Messages.getString((String)"ResourecePreferencePage.openDialogTitle");
    public static final String OPEN_DILAOG_MESSAGE = Messages.getString((String)"ResourecePreferencePage.openDialogMessage");
    public static final String DIRCTORY = "resource";

    public ResourcePreferencePage() {
    }

    public ResourcePreferencePage(String title) {
        super(title);
    }

    public ResourcePreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridData data = new GridData(1810);
        data.grabExcessHorizontalSpace = true;
        mainComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        mainComposite.setLayout((Layout)layout);
        Label title = new Label(mainComposite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        title.setLayoutData((Object)data);
        title.setText(TITLE_LABEL);
        new Label(mainComposite, 0);
        new Label(mainComposite, 0);
        this.createBrowse(mainComposite);
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.Preference_BIRT_Resource_ID");
        return mainComposite;
    }

    private void createBrowse(Composite composite) {
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(2));
        label.setText(FOLDER_LABEL);
        this.resourceText = new Text(composite, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.resourceText.setLayoutData((Object)data);
        this.resourceText.setText(ReportPlugin.getDefault().getResourcePreference());
        this.resourceText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = e.text.indexOf(";") < 0;
            }
        });
        new Label(composite, 0);
        Button browser = new Button(composite, 8);
        browser.setText(BROWSER_BUTTON);
        data = new GridData();
        browser.setLayoutData((Object)data);
        browser.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell());
                dialog.setText(OPEN_DIALOG_TITLE);
                dialog.setMessage(OPEN_DILAOG_MESSAGE);
                String folderName = dialog.open();
                if (folderName == null) {
                    return;
                }
                if (!(folderName = folderName.replace('\\', '/')).endsWith("/")) {
                    folderName = folderName + "/";
                }
                ResourcePreferencePage.this.resourceText.setText(folderName);
            }
        });
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ReportPlugin.getDefault().getPreferenceStore());
    }

    protected void performDefaults() {
        this.resourceText.setText(ReportPlugin.getDefault().getDefaultResourcePreference());
    }

    public boolean performOk() {
        ReportPlugin.getDefault().setResourcePreference(this.resourceText.getText());
        SessionHandleAdapter.getInstance().getSessionHandle();
        SessionHandle.setBirtResourcePath((String)this.resourceText.getText());
        SessionHandleAdapter.getInstance().getSessionHandle().setResourceFolder(this.resourceText.getText());
        return super.performOk();
    }
}

