/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.util.CSSUtil;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.GroupElementHandle;
import org.eclipse.birt.report.model.api.GroupPropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class PropertyProcessor {
    protected String property;
    protected String elementName;

    public PropertyProcessor(String elementName, String property) {
        this.elementName = elementName;
        this.property = property;
    }

    public String getDisplayName() {
        String name = null;
        IElementPropertyDefn propertyDefn = DesignEngine.getMetaDataDictionary().getElement(this.elementName).getProperty(this.property);
        if (propertyDefn != null) {
            name = Messages.getString((String)propertyDefn.getDisplayNameID());
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    public String getDisplayName(List modelList) {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        String name = null;
        IElementPropertyDefn propertyDefn = multiSelectionHandle.getPropertyHandle(this.property).getPropertyDefn();
        if (propertyDefn != null) {
            name = propertyDefn.getDisplayName();
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    public IChoiceSet getChoiceSet(List modelList) {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        return multiSelectionHandle.getPropertyHandle(this.property).getPropertyDefn().getChoices();
    }

    public String getStringValue(List modelList) {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        String value = multiSelectionHandle.getStringProperty(this.property);
        if (modelList.size() == 1 && value == null) {
            value = "";
        } else if (value == null) {
            value = "";
        }
        return value;
    }

    public String getLocalStringValue(List modelList) {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        String value = multiSelectionHandle.getLocalStringProperty(this.property);
        if (modelList.size() == 1 && value == null) {
            value = "";
        } else if (value == null) {
            value = "";
        }
        return value;
    }

    public boolean isReadOnly(List modelList) {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        GroupPropertyHandle propertyHandle = multiSelectionHandle.getPropertyHandle(this.property);
        if (propertyHandle != null) {
            return propertyHandle.isReadOnly();
        }
        return false;
    }

    private GroupElementHandle getMultiSelectionHandle(List modelList) {
        return DEUtil.getMultiSelectionHandle((List)modelList);
    }

    public String getMeasureValue(List modelList) {
        String value = this.getStringValue(modelList);
        if (value == null || value.equals("")) {
            return value;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)value);
            return StringUtil.doubleToString((double)dimensionValue.getMeasure(), (int)3);
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public String getUnit(List modelList) {
        String value = this.getStringValue(modelList);
        if (value == null || value.equals("")) {
            return value;
        }
        try {
            DimensionValue dimensionValue = DimensionValue.parse((String)value);
            return dimensionValue.getUnits();
        }
        catch (PropertyValueException e) {
            ExceptionHandler.handle(e);
            return "";
        }
    }

    public String getDefaultUnit(List modelList) {
        if (modelList == null || modelList.size() == 0) {
            return null;
        }
        String unit = null;
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        if (!multiSelectionHandle.isSameType()) {
            return null;
        }
        DesignElementHandle handle = (DesignElementHandle)modelList.get(0);
        unit = handle.getPropertyHandle(this.property).getDefaultUnit();
        return unit;
    }

    public boolean validateDimensionValue(String value, List modelList) throws PropertyValueException {
        DimensionValue dimensionValue = DimensionValue.parse((String)value);
        if (dimensionValue == null) {
            return true;
        }
        int size = DEUtil.getFontSizeIntValue((DesignElementHandle)((DesignElementHandle)modelList.get(0)));
        double pointValue = CSSUtil.convertToPoint((Object)dimensionValue, (int)size);
        return pointValue < 1000000.0;
    }

    public void setStringValue(String value, List modelList) throws SemanticException {
        GroupElementHandle multiSelectionHandle = this.getMultiSelectionHandle(modelList);
        multiSelectionHandle.setStringProperty(this.property, value);
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String elementName) {
        this.elementName = elementName;
    }
}

