/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.context.BirtContext;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.context.ViewerAttributeBean;
import org.eclipse.birt.report.presentation.aggregation.layout.EngineFragment;
import org.eclipse.birt.report.presentation.aggregation.layout.RequesterFragment;
import org.eclipse.birt.report.service.BirtReportServiceFactory;
import org.eclipse.birt.report.service.BirtViewerReportService;
import org.eclipse.birt.report.service.api.InputOptions;
import org.eclipse.birt.report.servlet.BaseReportEngineServlet;

public class BirtEngineServlet
extends BaseReportEngineServlet {
    private static final long serialVersionUID = 1L;

    protected void __init(ServletConfig servletConfig) {
        BirtViewerReportService birtViewerReportService = new BirtViewerReportService(servletConfig);
        BirtReportServiceFactory.init(birtViewerReportService);
        this.engine = new EngineFragment();
        this.requester = new RequesterFragment();
        this.requester.buildComposite();
        this.requester.setJSPRootPath("/webcontent/birt");
    }

    protected IContext __getContext(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        InputOptions inputOptions = new InputOptions();
        inputOptions.setOption("request", httpServletRequest);
        BirtReportServiceFactory.getReportService().setContext(this.getServletContext(), inputOptions);
        return new BirtContext(httpServletRequest, httpServletResponse);
    }

    protected boolean __authenticate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return true;
    }

    protected void __doGet(IContext iContext) throws ServletException, IOException, BirtException {
        ViewerAttributeBean viewerAttributeBean = (ViewerAttributeBean)iContext.getBean();
        if ("/run".equalsIgnoreCase(iContext.getRequest().getServletPath()) && viewerAttributeBean != null && viewerAttributeBean.isMissingParameter()) {
            this.requester.service(iContext.getRequest(), iContext.getResponse());
        } else if ("/parameter".equalsIgnoreCase(iContext.getRequest().getServletPath())) {
            this.requester.service(iContext.getRequest(), iContext.getResponse());
        } else {
            this.engine.service(iContext.getRequest(), iContext.getResponse());
        }
    }

    protected void __handleNonSoapException(IContext iContext, Exception exception) throws ServletException, IOException {
        exception.printStackTrace();
        String string = "webcontent/birt/pages/common/Error.jsp";
        iContext.getRequest().setAttribute("error", (Object)exception);
        RequestDispatcher requestDispatcher = iContext.getRequest().getRequestDispatcher(string);
        requestDispatcher.include((ServletRequest)iContext.getRequest(), (ServletResponse)iContext.getResponse());
    }
}

