/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ExpressionDialogCellEditor;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSetParameterHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ParamBindingHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ParamBinding;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ChartDataBindingPage
extends Composite {
    List input = null;
    protected HashMap propertiesMap = new HashMap(7);
    Table table;
    Combo combo;
    private ArrayList resultList;
    private ArrayList bindingParametersList;
    public static final String Binding = "binding";
    private TableViewer tableViewer;
    static final String[] columnNames = new String[]{Messages.getString("ChartDataBindingPage.Lbl.Parameter"), Messages.getString("ChartDataBindingPage.Lbl.DataType"), Messages.getString("ChartDataBindingPage.Lbl.Value")};
    static final String NONE = Messages.getString("ChartDataBindingPage.Lbl.None");
    private transient boolean enableAutoCommit = true;
    private ExpressionDialogCellEditor expressionCellEditor;
    static IChoiceSet DataTypes = DesignEngine.getMetaDataDictionary().getChoiceSet("columnDataType");
    static final String DEFAULT_VALUE_LABEL = Messages.getString("ChartDataBindingPage.Lbl.DefaultValue");
    static final String DATA_SET_LABEL = Messages.getString("ChartDataBindingPage.Lbl.DataSet");

    public ChartDataBindingPage(Composite parent, int style) {
        super(parent, style);
        this.buildUI();
    }

    protected void buildUI() {
        FormLayout layout = new FormLayout();
        layout.marginHeight = 7;
        layout.marginWidth = 7;
        layout.spacing = 5;
        this.setLayout((Layout)layout);
        Label title = new Label((Composite)this, 0);
        PropertyProcessor processor = new PropertyProcessor("ReportItem", "dataSet");
        title.setText(processor.getDisplayName());
        this.combo = new Combo((Composite)this, 8);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value = ChartDataBindingPage.this.combo.getText();
                if (value.equals(NONE)) {
                    value = null;
                }
                if (ChartDataBindingPage.this.canChangeDataSet(value)) {
                    try {
                        ChartDataBindingPage.this.startTrans("");
                        DataSetHandle dataSet = null;
                        if (value != null) {
                            dataSet = SessionHandleAdapter.getInstance().getReportDesignHandle().findDataSet(value);
                        }
                        ChartDataBindingPage.this.getReportItemHandle().setDataSet(dataSet);
                        ChartDataBindingPage.this.getPropertyHandle().setStringValue(null);
                        ChartDataBindingPage.this.commit();
                    }
                    catch (SemanticException e1) {
                        ChartDataBindingPage.this.rollback();
                        e1.printStackTrace();
                    }
                    Object[] descriptors = ChartDataBindingPage.this.propertiesMap.values().toArray();
                    for (int i = 0; i < descriptors.length; ++i) {
                        IPropertyDescriptor descriptor = (IPropertyDescriptor)descriptors[i];
                        descriptor.setModelList(ChartDataBindingPage.this.input);
                    }
                    ChartDataBindingPage.this.refreshValues();
                } else {
                    ChartDataBindingPage.this.combo.setText(value);
                }
            }
        });
        FormData data = new FormData();
        data.left = new FormAttachment((Control)title, 0, 131072);
        data.top = new FormAttachment((Control)title, 0, 0x1000000);
        data.right = new FormAttachment(50);
        this.combo.setLayoutData((Object)data);
        this.table = new Table((Composite)this, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            if (i == 1) {
                column.setWidth(80);
                continue;
            }
            column.setWidth(160);
        }
        data = new FormData();
        data.top = new FormAttachment((Control)this.combo, 0, 1024);
        data.left = new FormAttachment((Control)title, 0, 16384);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
        this.createTableViewer();
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columnNames);
        this.expressionCellEditor = new ExpressionDialogCellEditor((Composite)this.table);
        this.tableViewer.setCellEditors(new CellEditor[]{null, null, this.expressionCellEditor});
        this.tableViewer.setContentProvider((IContentProvider)new BindingContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new BindingLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new BindingCellModifier());
    }

    protected void refreshValues() {
        String dataSetName;
        if (this.input.size() != 1) {
            this.combo.setEnabled(false);
            this.combo.deselectAll();
            this.table.removeAll();
            this.table.setEnabled(false);
            return;
        }
        this.combo.setEnabled(true);
        this.table.setEnabled(true);
        String selectedDataSetName = this.combo.getText();
        String[] oldList = this.combo.getItems();
        String[] dataSets = ChoiceSetFactory.getDataSets();
        String[] newList = new String[dataSets.length + 1];
        newList[0] = NONE;
        System.arraycopy(dataSets, 0, newList, 1, dataSets.length);
        if (!((Object)Arrays.asList(oldList)).equals(Arrays.asList(newList))) {
            this.combo.setItems(newList);
            this.combo.setText(selectedDataSetName);
        }
        if (!(dataSetName = this.getDataSetName()).equals(selectedDataSetName)) {
            this.combo.deselectAll();
            this.combo.setText(dataSetName);
        }
        this.reconstructTable();
        this.updateBindingData();
    }

    ReportItemHandle getReportItemHandle() {
        return (ReportItemHandle)this.input.get(0);
    }

    private String getDataSetName() {
        if (this.getReportItemHandle().getDataSet() == null) {
            return NONE;
        }
        String dataSetName = this.getReportItemHandle().getDataSet().getQualifiedName();
        if (dataSetName == null || "".equals(dataSetName)) {
            dataSetName = NONE;
        }
        return dataSetName;
    }

    private void reconstructTable() {
        ReportItemHandle reportItemHandle = (ReportItemHandle)this.input.get(0);
        this.tableViewer.setInput((Object)reportItemHandle);
        this.expressionCellEditor.setItemHandle(reportItemHandle);
    }

    private void updateBindingData() {
        if (this.input.size() != 1) {
            return;
        }
        ReportItemHandle reportItemHandle = (ReportItemHandle)this.input.get(0);
        if (reportItemHandle.getDataSet() == null) {
            return;
        }
        Iterator iterator = reportItemHandle.paramBindingsIterator();
        while (iterator != null && iterator.hasNext()) {
            ParamBindingHandle handle = (ParamBindingHandle)iterator.next();
            String expression = handle.getExpression();
            int rowIndex = this.bindingParametersList.indexOf(handle);
            if (rowIndex == -1 || expression == null) continue;
            this.table.getItem(rowIndex).setText(columnNames.length - 1, expression);
            TableItem item = this.table.getItem(rowIndex);
            if (item.getData(Binding) != null) continue;
            item.setData(Binding, (Object)handle);
        }
    }

    ParamBindingHandle createBindingHandle(String name) throws SemanticException {
        PropertyHandle propertyHandle = this.getPropertyHandle();
        ParamBinding binding = StructureFactory.createParamBinding();
        binding.setParamName(name);
        propertyHandle.addItem((IStructure)binding);
        return (ParamBindingHandle)binding.getHandle((SimpleValueHandle)propertyHandle);
    }

    PropertyHandle getPropertyHandle() {
        ReportItemHandle handle = (ReportItemHandle)this.input.get(0);
        return handle.getPropertyHandle("paramBindings");
    }

    private CommandStack getActionStack() {
        return SessionHandleAdapter.getInstance().getCommandStack();
    }

    void startTrans(String name) {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().startTrans(name);
        }
    }

    void commit() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().commit();
        }
    }

    void rollback() {
        if (this.isEnableAutoCommit()) {
            this.getActionStack().rollback();
        }
    }

    public void setInput(List elements) {
        this.input = elements;
        this.reconstructTable();
        Object[] descriptors = this.propertiesMap.values().toArray();
        for (int i = 0; i < descriptors.length; ++i) {
            IPropertyDescriptor descriptor = (IPropertyDescriptor)descriptors[i];
            descriptor.setModelList(elements);
        }
        this.refreshValues();
    }

    public boolean isEnableAutoCommit() {
        return this.enableAutoCommit;
    }

    public void setEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
    }

    boolean canChangeDataSet(String newName) {
        if (this.isEnableAutoCommit()) {
            PropertyProcessor processor = new PropertyProcessor("Table", "dataSet");
            String currentDataSetName = processor.getStringValue(this.input);
            if (currentDataSetName == null || "".equals(currentDataSetName) || NONE.equals(currentDataSetName)) {
                return true;
            }
            if (!currentDataSetName.equals(newName)) {
                return MessageDialog.openQuestion(null, (String)Messages.getString("ChartDataBindingPage.Lbl.SaveDataSet"), (String)Messages.getString("ChartDataBindingPage.Msg.AskSaveDataSet"));
            }
            return false;
        }
        return true;
    }

    private class BindingContentProvider
    implements IStructuredContentProvider {
        private BindingContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ParamBindingHandle handle;
            if (inputElement == null) {
                return new Object[0];
            }
            ReportItemHandle inputHandle = (ReportItemHandle)inputElement;
            DataSetHandle dataHandle = inputHandle.getDataSet();
            if (dataHandle == null) {
                return new Object[0];
            }
            ChartDataBindingPage.this.bindingParametersList = new ArrayList();
            ArrayList<String> bindingParametersNameList = new ArrayList<String>();
            ChartDataBindingPage.this.resultList = new ArrayList();
            Iterator iterator = inputHandle.paramBindingsIterator();
            while (iterator.hasNext()) {
                handle = (ParamBindingHandle)iterator.next();
                ChartDataBindingPage.this.bindingParametersList.add(handle);
                bindingParametersNameList.add(handle.getParamName());
            }
            iterator = dataHandle.parametersIterator();
            while (iterator.hasNext()) {
                handle = (DataSetParameterHandle)iterator.next();
                Object[] result = new Object[]{handle, null};
                int index = bindingParametersNameList.indexOf(handle.getName());
                if (index != -1) {
                    result[1] = ChartDataBindingPage.this.bindingParametersList.get(index);
                }
                ChartDataBindingPage.this.resultList.add(result);
            }
            return ChartDataBindingPage.this.resultList.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class BindingCellModifier
    implements ICellModifier {
        private BindingCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property.equals(columnNames[2]);
        }

        public Object getValue(Object element, String property) {
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            if (bindingParameter != null) {
                return bindingParameter.getExpression();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            int index;
            Object model = element;
            if (element instanceof Item) {
                model = ((Item)element).getData();
            }
            if ((index = ChartDataBindingPage.this.resultList.indexOf(model)) != -1) {
                Object[] pair = (Object[])model;
                ParamBindingHandle bindingHandle = (ParamBindingHandle)pair[1];
                if ((value == null || "".equals(value)) && bindingHandle != null) {
                    try {
                        ChartDataBindingPage.this.getPropertyHandle().removeItem(bindingHandle.getStructure());
                    }
                    catch (PropertyValueException e) {
                        e.printStackTrace();
                        return;
                    }
                }
                ChartDataBindingPage.this.startTrans(Messages.getString("ChartDataBindingPage.Lbl.SaveParameterBinding"));
                if (bindingHandle == null) {
                    try {
                        bindingHandle = ChartDataBindingPage.this.createBindingHandle(ChartDataBindingPage.this.table.getItem(index).getText(0));
                    }
                    catch (SemanticException e) {
                        e.printStackTrace();
                        ChartDataBindingPage.this.rollback();
                        return;
                    }
                }
                bindingHandle.setExpression((String)value);
                ChartDataBindingPage.this.commit();
                ChartDataBindingPage.this.reconstructTable();
            }
        }
    }

    private class BindingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private BindingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String text = "";
            DataSetParameterHandle parameter = (DataSetParameterHandle)((Object[])element)[0];
            ParamBindingHandle bindingParameter = (ParamBindingHandle)((Object[])element)[1];
            switch (columnIndex) {
                case 0: {
                    if (parameter.getName() == null) break;
                    text = parameter.getName();
                    break;
                }
                case 1: {
                    if (parameter.getDataType() == null) break;
                    text = ChoiceSetFactory.getDisplayNameFromChoiceSet((String)parameter.getDataType(), (IChoiceSet)DataTypes);
                    break;
                }
                case 2: {
                    if (bindingParameter != null && bindingParameter.getExpression() != null) {
                        text = bindingParameter.getExpression();
                        break;
                    }
                    if (parameter.getDefaultValue() == null) break;
                    text = parameter.getDefaultValue() + " " + DEFAULT_VALUE_LABEL;
                }
            }
            return text;
        }
    }
}

