/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.Operator;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.ILocalizableInfo;
import org.eclipse.birt.report.model.api.metadata.IMemberInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.swt.graphics.Image;

public class ChartExpressionProvider
extends ExpressionProvider {
    public static final String CHART_VARIABLES = Messages.getString("ChartExpressionProvider.Category.ChartVariables");
    private static final String DATA_POINTS = Messages.getString("ChartExpressionProvider.ChartVariables.DataPoints");

    public Object[] getCategory() {
        ArrayList<String> categoryList = new ArrayList<String>(3);
        categoryList.add(NATIVE_OBJECTS);
        categoryList.add(CHART_VARIABLES);
        categoryList.add(OPERATORS);
        return categoryList.toArray();
    }

    public Object[] getChildren(Object parent) {
        ArrayList<Object> childrenList;
        block6: {
            block7: {
                block10: {
                    block9: {
                        block8: {
                            block5: {
                                childrenList = new ArrayList<Object>();
                                if (!(parent instanceof Object[])) break block5;
                                Object[] array = (Object[])parent;
                                if (array instanceof Operator[]) {
                                    return array;
                                }
                                for (int i = 0; i < array.length; ++i) {
                                    Object[] children = this.getChildren(array[i]);
                                    childrenList.addAll(Arrays.asList(children));
                                }
                                break block6;
                            }
                            if (!(parent instanceof String)) break block7;
                            if (!DATA_POINTS.equals(parent)) break block8;
                            childrenList.add("categoryData");
                            childrenList.add("valueData");
                            childrenList.add("valueSeriesName");
                            break block6;
                        }
                        if (!CHART_VARIABLES.equals(parent)) break block9;
                        childrenList.add(DATA_POINTS);
                        break block6;
                    }
                    if (!NATIVE_OBJECTS.equals(parent)) break block10;
                    childrenList.addAll(this.getClassList(true));
                    break block6;
                }
                if (!OPERATORS.equals(parent)) break block6;
                childrenList.add(OPERATORS_ASSIGNMENT);
                childrenList.add(OPERATORS_COMPARISON);
                childrenList.add(OPERATORS_COMPUTATIONAL);
                childrenList.add(OPERATORS_LOGICAL);
                childrenList.add(0, childrenList.toArray());
                break block6;
            }
            if (parent instanceof IClassInfo) {
                IClassInfo classInfo = (IClassInfo)parent;
                Iterator iter = classInfo.getMembers().iterator();
                while (iter.hasNext()) {
                    childrenList.add(new ILocalizableInfo[]{classInfo, (IMemberInfo)iter.next()});
                }
                iter = classInfo.getMethods().iterator();
                while (iter.hasNext()) {
                    childrenList.add(new ILocalizableInfo[]{classInfo, (IMethodInfo)iter.next()});
                }
            }
        }
        return childrenList.toArray();
    }

    public String getDisplayText(Object element) {
        if (element instanceof Object[]) {
            if (element instanceof Operator[]) {
                if (element == OPERATORS_ASSIGNMENT) {
                    return DISPLAY_TEXT_ASSIGNMENT;
                }
                if (element == OPERATORS_COMPARISON) {
                    return DISPLAY_TEXT_COMPARISON;
                }
                if (element == OPERATORS_COMPUTATIONAL) {
                    return DISPLAY_TEXT_COMPUTATIONAL;
                }
                if (element == OPERATORS_LOGICAL) {
                    return DISPLAY_TEXT_LOGICAL;
                }
            } else if (element instanceof ILocalizableInfo[]) {
                ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
                StringBuffer displayText = new StringBuffer(info.getName());
                if (info instanceof IMethodInfo) {
                    IMethodInfo method = (IMethodInfo)info;
                    displayText.append("(");
                    displayText.append(") ");
                    displayText.append(method.getReturnType());
                }
                return displayText.toString();
            }
            return ALL;
        }
        if (element instanceof String) {
            if (element.equals("categoryData")) {
                return Messages.getString("ChartExpressionProvider.DataPoints.BaseValue");
            }
            if (element.equals("valueData")) {
                return Messages.getString("ChartExpressionProvider.DataPoints.OrthogonalValue");
            }
            if (element.equals("valueSeriesName")) {
                return Messages.getString("ChartExpressionProvider.DataPoints.SeriesValue");
            }
            return (String)element;
        }
        if (element instanceof Operator) {
            return ((Operator)element).symbol;
        }
        return element.toString();
    }

    public Image getImage(Object element) {
        if (element instanceof Operator) {
            return IMAGE_OPERATOR;
        }
        if (element instanceof ILocalizableInfo[]) {
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            if (info instanceof IMethodInfo) {
                if (((IMethodInfo)info).isStatic()) {
                    return IMAGE_STATIC_METHOD;
                }
                return IMAGE_METHOD;
            }
            if (info instanceof IMemberInfo) {
                if (((IMemberInfo)info).isStatic()) {
                    return IMAGE_STATIC_MEMBER;
                }
                return IMAGE_MEMBER;
            }
        }
        return null;
    }

    public String getInsertText(Object element) {
        if (element instanceof Operator) {
            return ((Operator)element).insertString;
        }
        if (element instanceof ILocalizableInfo[]) {
            IClassInfo classInfo = (IClassInfo)((ILocalizableInfo[])element)[0];
            ILocalizableInfo info = ((ILocalizableInfo[])element)[1];
            StringBuffer insertText = new StringBuffer();
            if (info instanceof IMemberInfo) {
                IMemberInfo memberInfo = (IMemberInfo)info;
                if (memberInfo.isStatic()) {
                    insertText.append(classInfo.getName() + ".");
                }
                insertText.append(memberInfo.getName());
            } else if (info instanceof IMethodInfo) {
                IMethodInfo methodInfo = (IMethodInfo)info;
                if (methodInfo.isStatic()) {
                    insertText.append(classInfo.getName() + ".");
                }
                insertText.append(methodInfo.getName());
                insertText.append("()");
            }
            return insertText.toString();
        }
        if (element instanceof String) {
            return (String)element;
        }
        return null;
    }

    public String getTooltipText(Object element) {
        if (element instanceof Operator) {
            return ((Operator)element).tooltip;
        }
        if (element instanceof ILocalizableInfo[]) {
            return ((ILocalizableInfo[])element)[1].getToolTip();
        }
        return this.getDisplayText(element);
    }
}

