/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.swt.RegionAction;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.device.swt.util.SwtUtil;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.event.WrappedStructureSource;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.URLValue;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

class SwtEventHandler
implements MouseListener,
MouseMoveListener,
MouseTrackListener,
KeyListener {
    private static final ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");
    private final Cursor hand_cursor;
    private final LinkedHashMap lhmAllTriggers;
    private final IUpdateNotifier iun;
    private RegionAction raTooltip = null;
    private RegionAction raHighlighted = null;
    private final ULocale lcl;
    private final GC _gc;

    SwtEventHandler(LinkedHashMap _lhmAllTriggers, IUpdateNotifier _jc, ULocale _lcl) {
        this.lhmAllTriggers = _lhmAllTriggers;
        this.iun = _jc;
        this.lcl = _lcl;
        this.hand_cursor = new Cursor((Device)Display.getDefault(), 21);
        this._gc = new GC((Drawable)Display.getDefault());
    }

    private final List getActionsForConditions(TriggerCondition[] tca) {
        if (tca == null || tca.length == 0) {
            return null;
        }
        ArrayList al = new ArrayList();
        for (int i = 0; i < tca.length; ++i) {
            ArrayList tal = (ArrayList)this.lhmAllTriggers.get(tca[i]);
            if (tal == null) continue;
            al.addAll(tal);
        }
        if (al.size() > 0) {
            return al;
        }
        return null;
    }

    private final boolean isLeftButton(MouseEvent e) {
        return e.button == 1;
    }

    private void handleAction(List al, Object event) {
        this.handleAction(al, event, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void handleAction(List al, Object event, boolean cleanState) {
        if (al == null || event == null) {
            return;
        }
        Point p = null;
        if (event instanceof MouseEvent) {
            p = new Point(((MouseEvent)event).x, ((MouseEvent)event).y);
        }
        if (event instanceof KeyEvent) {
            // empty if block
        }
        boolean bFound = false;
        block12: for (int i = 0; i < al.size(); ++i) {
            RegionAction ra = (RegionAction)al.get(i);
            if (p != null && !ra.contains(p, this._gc)) continue;
            Action ac = ra.getAction();
            StructureSource src = ra.getSource();
            switch (ac.getType().getValue()) {
                case 0: {
                    URLValue uv = (URLValue)ac.getValue();
                    logger.log(1, Messages.getString("SwtEventHandler.info.redirect.url", this.lcl) + uv.getBaseUrl());
                    SwtUtil.openURL(uv.getBaseUrl());
                    break block12;
                }
                case 1: {
                    if (ra != this.raTooltip) {
                        this.hideTooltip();
                    }
                    this.raTooltip = ra;
                    bFound = true;
                    this.showTooltip(this.raTooltip);
                    break block12;
                }
                case 2: {
                    if (src.getType() != StructureType.SERIES && src.getType() != StructureType.SERIES_DATA_POINT) break;
                    Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
                    logger.log(1, Messages.getString("SwtEventHandler.info.toggle.visibility", this.lcl) + seRT);
                    Series seDT = null;
                    try {
                        seDT = this.findDesignTimeSeries(seRT);
                    }
                    catch (ChartException oosx) {
                        logger.log((Exception)((Object)oosx));
                        return;
                    }
                    seDT.setVisible(!seDT.isVisible());
                    this.iun.regenerateChart();
                    break block12;
                }
                case 6: {
                    if (src.getType() != StructureType.SERIES && src.getType() != StructureType.SERIES_DATA_POINT) break;
                    Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
                    logger.log(1, Messages.getString("SwtEventHandler.info.toggle.datapoint.visibility", this.lcl) + seRT);
                    Series seDT = null;
                    try {
                        seDT = this.findDesignTimeSeries(seRT);
                    }
                    catch (ChartException oosx) {
                        logger.log((Exception)((Object)oosx));
                        return;
                    }
                    seDT.getLabel().setVisible(!seDT.getLabel().isVisible());
                    this.iun.regenerateChart();
                    break block12;
                }
                case 4: {
                    boolean newRegion;
                    bFound = true;
                    boolean bl = newRegion = this.raHighlighted == null || this.raHighlighted.isEmpty();
                    if (!(newRegion || p != null && this.raHighlighted.contains(p, this._gc))) {
                        newRegion = true;
                    }
                    if (!newRegion) break;
                    this.raHighlighted = ra.copy();
                    this.toggleHighlight(ra);
                    break block12;
                }
                case 5: {
                    if (this.iun instanceof ICallBackNotifier) {
                        CallBackValue cv = (CallBackValue)ac.getValue();
                        ((ICallBackNotifier)this.iun).callback(event, (Object)ra.getSource(), cv);
                        break block12;
                    }
                    logger.log(2, Messages.getString("SwtEventHandler.info.improper.callback.notifier", new Object[]{this.iun}, this.lcl));
                    break block12;
                }
            }
        }
        if (!bFound && this.raTooltip != null) {
            this.hideTooltip();
            this.raTooltip = null;
        }
        if ((cleanState || !bFound) && this.raHighlighted != null) {
            this.raHighlighted.dispose();
            this.raHighlighted = null;
        }
    }

    private final Series findDesignTimeSeries(Series seRT) throws ChartException {
        Series seDT = null;
        Chart cmRT = this.iun.getRunTimeModel();
        Chart cmDT = this.iun.getDesignTimeModel();
        if (cmDT instanceof ChartWithAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithAxes cwaRT = (ChartWithAxes)cmRT;
            ChartWithAxes cwaDT = (ChartWithAxes)cmDT;
            Axis[] axaBase = cwaRT.getPrimaryBaseAxes();
            Axis axBase = axaBase[0];
            Axis[] axaOrthogonal = cwaRT.getOrthogonalAxes(axBase, true);
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = axaBase[0].getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                for (i = 0; i < axaOrthogonal.length; ++i) {
                    elSD = axaOrthogonal[i].getSeriesDefinitions();
                    for (j = 0; j < elSD.size(); ++j) {
                        sd = (SeriesDefinition)elSD.get(j);
                        elSE = sd.getSeries();
                        for (k = 0; k < elSE.size(); ++k) {
                            se = (Series)elSE.get(k);
                            if (seRT != se) continue;
                            bFound = true;
                            break;
                        }
                        if (bFound) break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 8, "SwtEventHandler.info.cannot.find.series", new Object[]{seRT}, Messages.getResourceBundle(this.lcl));
            }
            axaBase = cwaDT.getPrimaryBaseAxes();
            axBase = axaBase[0];
            axaOrthogonal = cwaDT.getOrthogonalAxes(axBase, true);
            elSD = i == -1 ? axaBase[0].getSeriesDefinitions() : axaOrthogonal[i].getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        } else if (cmDT instanceof ChartWithoutAxes) {
            EList elSE;
            SeriesDefinition sd;
            ChartWithoutAxes cwoaRT = (ChartWithoutAxes)cmRT;
            ChartWithoutAxes cwoaDT = (ChartWithoutAxes)cmDT;
            Series se = null;
            int i = -1;
            int j = 0;
            int k = 0;
            boolean bFound = false;
            EList elSD = cwoaRT.getSeriesDefinitions();
            for (j = 0; j < elSD.size(); ++j) {
                sd = (SeriesDefinition)elSD.get(j);
                elSE = sd.getSeries();
                for (k = 0; k < elSE.size(); ++k) {
                    se = (Series)elSE.get(k);
                    if (seRT != se) continue;
                    bFound = true;
                    break;
                }
                if (bFound) break;
            }
            if (!bFound) {
                i = 1;
                elSD = ((SeriesDefinition)cwoaRT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
                for (j = 0; j < elSD.size(); ++j) {
                    sd = (SeriesDefinition)elSD.get(j);
                    elSE = sd.getSeries();
                    for (k = 0; k < elSE.size(); ++k) {
                        se = (Series)elSE.get(k);
                        if (seRT != se) continue;
                        bFound = true;
                        break;
                    }
                    if (bFound) break;
                }
            }
            if (!bFound) {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 8, "SwtEventHandler.info.cannot.find.series", new Object[]{seRT}, Messages.getResourceBundle(this.lcl));
            }
            elSD = i == -1 ? cwoaDT.getSeriesDefinitions() : ((SeriesDefinition)cwoaDT.getSeriesDefinitions().get(0)).getSeriesDefinitions();
            sd = (SeriesDefinition)elSD.get(j);
            elSE = sd.getSeries();
            seDT = (Series)elSE.get(k);
        }
        return seDT;
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONDBLCLICK_LITERAL});
        this.handleAction(al, e);
    }

    public void mouseDown(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONMOUSEDOWN_LITERAL});
        this.handleAction(al, e);
    }

    public void mouseUp(MouseEvent e) {
        if (!this.isLeftButton(e)) {
            return;
        }
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONMOUSEUP_LITERAL, TriggerCondition.ONCLICK_LITERAL, TriggerCondition.MOUSE_CLICK_LITERAL});
        this.handleAction(al, e);
    }

    public void mouseMove(MouseEvent e) {
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONCLICK_LITERAL, TriggerCondition.ONMOUSEDOWN_LITERAL, TriggerCondition.MOUSE_CLICK_LITERAL});
        if (al != null) {
            boolean bFound = false;
            for (int i = 0; i < al.size(); ++i) {
                RegionAction ra = (RegionAction)al.get(i);
                if (!ra.contains(e.x, e.y, this._gc)) continue;
                ((Composite)this.iun.peerInstance()).setCursor(this.hand_cursor);
                bFound = true;
                break;
            }
            if (!bFound) {
                ((Composite)this.iun.peerInstance()).setCursor(null);
            }
        }
        al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONMOUSEMOVE_LITERAL, TriggerCondition.ONMOUSEOVER_LITERAL});
        this.handleAction(al, e, false);
    }

    public void keyPressed(KeyEvent e) {
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONKEYDOWN_LITERAL});
        this.handleAction(al, e);
    }

    public void keyReleased(KeyEvent e) {
        List al = this.getActionsForConditions(new TriggerCondition[]{TriggerCondition.ONKEYUP_LITERAL, TriggerCondition.ONKEYPRESS_LITERAL});
        this.handleAction(al, e);
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
    }

    public void mouseHover(MouseEvent e) {
    }

    private final void toggleHighlight(RegionAction ra) {
        if (ra == null) {
            return;
        }
        StructureSource src = ra.getSource();
        if (src.getType() == StructureType.SERIES || src.getType() == StructureType.SERIES_DATA_POINT) {
            Series seRT = src.getType() == StructureType.SERIES ? (Series)src.getSource() : (Series)((WrappedStructureSource)src).getParent().getSource();
            logger.log(1, Messages.getString("SwtEventHandler.info.toggle.visibility", this.lcl) + seRT);
            Series seDT = null;
            SeriesDefinition sdDT = null;
            try {
                seDT = this.findDesignTimeSeries(seRT);
                if (seDT.eContainer() instanceof SeriesDefinition) {
                    sdDT = (SeriesDefinition)seDT.eContainer();
                }
            }
            catch (ChartException oosx) {
                logger.log((Exception)((Object)oosx));
                return;
            }
            boolean highlight = this.iun.getContext((Object)seDT) == null;
            boolean changed = false;
            if (seDT != null) {
                changed = this.performHighlight(seDT, highlight);
            }
            if (sdDT != null) {
                Iterator itr = sdDT.getSeriesPalette().getEntries().iterator();
                while (itr.hasNext()) {
                    Object entry = itr.next();
                    if (!(entry instanceof ColorDefinition)) continue;
                    this.performHighlight((ColorDefinition)entry, highlight);
                    changed = true;
                }
            }
            if (highlight) {
                if (this.iun.getContext((Object)seDT) == null) {
                    this.iun.putContext((Object)seDT, (Object)Boolean.TRUE);
                }
            } else {
                this.iun.removeContext((Object)seDT);
            }
            if (changed) {
                this.iun.regenerateChart();
            }
        }
    }

    private boolean performHighlight(Series se, boolean highlighted) {
        Object context;
        boolean changed = false;
        List lineContext = highlighted ? new ArrayList() : ((context = this.iun.getContext((Object)se)) instanceof List ? (List)context : new ArrayList());
        int idx = 0;
        TreeIterator itr = se.eAllContents();
        while (itr.hasNext()) {
            Object context2;
            Object obj = itr.next();
            if (obj instanceof ColorDefinition && !(((ColorDefinition)obj).eContainer() instanceof LineAttributes)) {
                this.performHighlight((ColorDefinition)obj, highlighted);
                changed = true;
                continue;
            }
            if (!(obj instanceof LineAttributes)) continue;
            LineAttributes la = (LineAttributes)obj;
            if (highlighted) {
                int[] ls = new int[]{la.getThickness(), la.getColor().getRed(), la.getColor().getGreen(), la.getColor().getBlue(), la.getColor().getTransparency()};
                lineContext.add(ls);
                la.setThickness(3);
                la.getColor().set(255, 255, 255, 127);
                changed = true;
            } else if (idx < lineContext.size() && (context2 = lineContext.get(idx)) instanceof int[] && ((int[])context2).length > 4) {
                int[] ls = (int[])context2;
                la.setThickness(ls[0]);
                la.getColor().setRed(ls[1]);
                la.getColor().setGreen(ls[2]);
                la.getColor().setBlue(ls[3]);
                la.getColor().setTransparency(ls[4]);
                changed = true;
            }
            ++idx;
        }
        if (highlighted && lineContext.size() > 0) {
            this.iun.putContext((Object)se, lineContext);
        }
        return changed;
    }

    private void performHighlight(ColorDefinition cd, boolean highlighted) {
        if (cd != null) {
            if (highlighted) {
                cd.setRed((cd.getRed() + 255) / 2);
                cd.setGreen((cd.getGreen() + 255) / 2);
                cd.setBlue((cd.getBlue() + 255) / 2);
            } else {
                cd.setRed(Math.max(0, cd.getRed() * 2 - 255));
                cd.setGreen(Math.max(0, cd.getGreen() * 2 - 255));
                cd.setBlue(Math.max(0, cd.getBlue() * 2 - 255));
            }
        }
    }

    private final void hideTooltip() {
        ((Composite)this.iun.peerInstance()).setToolTipText(null);
    }

    private final void showTooltip(RegionAction ra) {
        Action ac = ra.getAction();
        TooltipValue tv = (TooltipValue)ac.getValue();
        String s = tv.getText();
        ((Composite)this.iun.peerInstance()).setToolTipText(s);
    }

    public final void dispose() {
        if (this.raHighlighted != null) {
            this.raHighlighted.dispose();
            this.raHighlighted = null;
        }
        this.hand_cursor.dispose();
        this._gc.dispose();
    }
}

