/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.lib.explorer;

import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.ui.ContextMenuProvider;
import org.eclipse.birt.report.designer.ui.lib.explorer.LibraryExplorerTreeViewPage;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddElementtoReport;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddLibraryAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.AddSelectedLibToCurrentReportDesignAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.DeleteLibraryAction;
import org.eclipse.birt.report.designer.ui.lib.explorer.action.RefreshLibExplorerAction;
import org.eclipse.birt.report.model.api.CascadingParameterGroupHandle;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;

public class LibraryExplorerContextMenuProvider
extends ContextMenuProvider {
    private RefreshLibExplorerAction refreshExplorerAction;
    private AddLibraryAction addLibraryAction;
    private AddSelectedLibToCurrentReportDesignAction useLibraryAction;
    private DeleteLibraryAction deleteLibraryAction;

    public LibraryExplorerContextMenuProvider(LibraryExplorerTreeViewPage page) {
        super((ISelectionProvider)page.getTreeViewer());
        this.refreshExplorerAction = new RefreshLibExplorerAction(page);
        this.addLibraryAction = new AddLibraryAction(page.getTreeViewer());
        this.useLibraryAction = new AddSelectedLibToCurrentReportDesignAction((StructuredViewer)page.getTreeViewer());
        this.deleteLibraryAction = new DeleteLibraryAction(page);
    }

    public void buildContextMenu(IMenuManager menu) {
        if (Policy.TRACING_MENU_SHOW) {
            System.out.println("Menu(for Views) >> Shows for library");
        }
        menu.removeAll();
        menu.add((IContributionItem)new Separator("additions"));
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        if (selection != null && selection.getFirstElement() != null) {
            Object selected = selection.getFirstElement();
            this.refreshExplorerAction.setSelectedElement(selected);
            menu.add((IAction)this.refreshExplorerAction);
            menu.add((IContributionItem)new Separator());
            if (selected instanceof LibraryHandle) {
                menu.add((IAction)this.addLibraryAction);
                if (this.useLibraryAction.isEnabled()) {
                    menu.add((IAction)this.useLibraryAction);
                }
                if (this.deleteLibraryAction.isEnabled()) {
                    menu.add((IAction)this.deleteLibraryAction);
                }
            } else {
                menu.add((IAction)this.addLibraryAction);
            }
            if (this.canAddtoReport(selected) && selection.size() == 1) {
                AddElementtoReport addElementAction = new AddElementtoReport((StructuredViewer)this.getViewer());
                addElementAction.setSelectedElement(selected);
                menu.add((IAction)addElementAction);
            }
        } else {
            this.refreshExplorerAction.setSelectedElement(null);
            menu.add((IAction)this.refreshExplorerAction);
            menu.add((IAction)this.addLibraryAction);
        }
    }

    protected boolean canAddtoReport(Object transfer) {
        if (transfer instanceof ReportElementHandle || transfer instanceof EmbeddedImageHandle) {
            if (transfer instanceof ScalarParameterHandle && ((ScalarParameterHandle)transfer).getContainer() instanceof CascadingParameterGroupHandle) {
                return false;
            }
            if (transfer instanceof StyleHandle && ((StyleHandle)transfer).getContainer() instanceof ThemeHandle) {
                return false;
            }
            return !(transfer instanceof ThemeHandle);
        }
        return false;
    }
}

