/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IColumn;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.css.dom.CellMergedStyle;
import org.eclipse.birt.report.engine.emitter.html.AttributeBuilder;
import org.eclipse.birt.report.engine.emitter.html.HTMLEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLReportEmitter;
import org.eclipse.birt.report.engine.emitter.html.HTMLWriter;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class HTMLVisionOptimize
extends HTMLEmitter {
    public HTMLVisionOptimize(HTMLReportEmitter parentEmitter, HTMLWriter writer, boolean isEmbeddable) {
        super(parentEmitter, writer, isEmbeddable);
    }

    public void buildTableStyle(ITableContent table, StringBuffer styleBuffer, String layoutPreference) {
        DimensionType width;
        IStyle style = table.getStyle();
        this.addDefaultTableStyles(styleBuffer);
        DimensionType x = table.getX();
        DimensionType y = table.getY();
        int display = this.getElementType(x, y, null, null, style);
        this.setDisplayProperty(display, 2, styleBuffer);
        DimensionType height = table.getHeight();
        if (null != height) {
            this.buildSize(styleBuffer, "height", height);
        }
        if (null != (width = table.getWidth())) {
            this.buildSize(styleBuffer, "width", width);
        } else {
            styleBuffer.append(" width: 100%;");
        }
        if ("fixed".equals(layoutPreference)) {
            styleBuffer.append(" table-layout:fixed;");
        }
        this.buildStyle((IContent)table, styleBuffer);
    }

    public void buildColumnStyle(IColumn column, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "width", column.getWidth());
    }

    public void buildRowStyle(IRowContent row, StringBuffer styleBuffer) {
        this.buildSize(styleBuffer, "height", row.getHeight());
        this.buildStyle((IContent)row, styleBuffer);
    }

    public void buildCellStyle(ICellContent cell, StringBuffer styleBuffer, boolean isInTableHead) {
        CellMergedStyle style = new CellMergedStyle(cell);
        AttributeBuilder.buildStyle(styleBuffer, (IStyle)style, this.parentEmitter);
        if (isInTableHead) {
            this.handleCellFont(cell, styleBuffer);
        }
        styleBuffer.append("overflow:hidden;");
        this.buildStyle((IContent)cell, styleBuffer);
    }

    public void handleCellAlign(ICellContent element) {
        IStyle cellStyle = element.getComputedStyle();
        CSSValue vAlign = cellStyle.getProperty(30);
        if (null == vAlign || IStyle.BASELINE_VALUE == vAlign) {
            vAlign = IStyle.TOP_VALUE;
        }
        this.writer.attribute("valign", vAlign.getCssText());
        CSSValue hAlign = cellStyle.getProperty(26);
        if (null != hAlign) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    public void buildContainerStyle(IContainerContent container, StringBuffer styleBuffer, int display) {
        this.handleShrink(display, container.getStyle(), container.getHeight(), container.getWidth(), styleBuffer);
        this.setDisplayProperty(display, 4, styleBuffer);
        this.buildStyle((IContent)container, styleBuffer);
    }

    public void buildTextStyle(ITextContent text, StringBuffer styleBuffer, int display, String url) {
        IStyle style = text.getStyle();
        this.handleShrink(display, style, text.getHeight(), text.getWidth(), styleBuffer);
        if (url != null) {
            this.setDisplayProperty(display, 5, styleBuffer);
        } else {
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        String textAlign = text.getComputedStyle().getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        this.buildStyle((IContent)text, styleBuffer);
        AttributeBuilder.checkHyperlinkTextDecoration(text.getComputedStyle(), styleBuffer);
    }

    public void buildForeignStyle(IForeignContent foreign, StringBuffer styleBuffer, int display, String url) {
        IStyle style = foreign.getStyle();
        this.handleShrink(display, style, foreign.getHeight(), foreign.getWidth(), styleBuffer);
        if (url != null) {
            this.setDisplayProperty(display, 5, styleBuffer);
        } else {
            this.setDisplayProperty(display, 4, styleBuffer);
        }
        String textAlign = foreign.getComputedStyle().getTextAlign();
        if (textAlign != null) {
            styleBuffer.append(" text-align:");
            styleBuffer.append(textAlign);
            styleBuffer.append(";");
        }
        this.buildStyle((IContent)foreign, styleBuffer);
        AttributeBuilder.checkHyperlinkTextDecoration(foreign.getComputedStyle(), styleBuffer);
    }

    public void buildImageStyle(IImageContent image, StringBuffer styleBuffer, int display) {
        this.buildSize(styleBuffer, "width", image.getWidth());
        this.buildSize(styleBuffer, "height", image.getHeight());
        this.setDisplayProperty(display, 0, styleBuffer);
        this.buildStyle((IContent)image, styleBuffer);
    }

    public void handleHorizontalAlign(IStyle style) {
        CSSValue hAlign = style.getProperty(26);
        if (null != hAlign) {
            this.writer.attribute("align", hAlign.getCssText());
        }
    }

    public void handleVerticalAlignBegine(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(30);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null) {
            this.writer.openTag("table");
            this.writer.attribute("style", " width:100%; height:100%;");
            this.writer.openTag("tr");
            this.writer.openTag("td");
            StringBuffer textStyleBuffer = new StringBuffer();
            textStyleBuffer.append(" vertical-align:");
            textStyleBuffer.append(vAlign.getCssText());
            textStyleBuffer.append(";");
            this.writer.attribute("style", textStyleBuffer);
        }
    }

    public void handleVerticalAlignEnd(IContent element) {
        IStyle style = element.getStyle();
        CSSValue vAlign = style.getProperty(30);
        DimensionType height = element.getHeight();
        if (vAlign != null && vAlign != IStyle.BASELINE_VALUE && height != null) {
            this.writer.closeTag("td");
            this.writer.closeTag("tr");
            this.writer.closeTag("table");
        }
    }

    protected void setDisplayProperty(int display, int mask, StringBuffer styleBuffer) {
        int flag = display & mask;
        if ((display & 8) > 0) {
            styleBuffer.append("display: none;");
        } else if (flag > 0) {
            if ((flag & 1) > 0) {
                styleBuffer.append("display: block;");
            } else if ((flag & 4) > 0) {
                styleBuffer.append("display: inline-block;");
            } else if ((flag & 2) > 0) {
                styleBuffer.append("display: inline;");
            }
        }
    }

    public void buildSize(StringBuffer content, String name, DimensionType value) {
        if (value != null) {
            if ("min-height".equals(name)) {
                content.append(" height: auto !important; height: ");
                content.append(value.toString());
                content.append("; min-height: ");
                content.append(value.toString());
                content.append(';');
            } else {
                super.buildSize(content, name, value);
            }
        }
    }

    public void buildStyle(IContent element, StringBuffer styleBuffer) {
        IStyle style = this.isEmbeddable ? element.getStyle() : element.getInlineStyle();
        AttributeBuilder.buildStyle(styleBuffer, style, this.parentEmitter);
    }

    protected void handleCellFont(ICellContent element, StringBuffer styleBuffer) {
        IStyle style = element.getStyle();
        String fontWeight = style.getFontWeight();
        if (fontWeight == null) {
            style = element.getComputedStyle();
            fontWeight = style.getFontWeight();
            if (fontWeight == null) {
                fontWeight = "normal";
            }
            styleBuffer.append("font-weight: ");
            styleBuffer.append(fontWeight);
            styleBuffer.append(";");
        }
    }
}

