/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers.models;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.models.MySafeRunnable;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;

public class CategoryDescriptor
implements Comparable {
    public static final String DRIVERTYPE_TAG = "driverExtension";
    private static final String EXTENSION_POINT_NAME = "driverExtension";
    private static final String CATEGORY_ELEMENT_TAG = "category";
    private static final String ID_ATTRIBUTE = "id";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String PARENTCATEGORY_ATTRIBUTE = "parentCategory";
    private static CategoryDescriptor[] fgCategoryDescriptors;
    private IConfigurationElement fElement;

    protected CategoryDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)DriverMgmtMessages.getString("CategoryDescriptor.msg.id_missing"));
        Assert.isNotNull((Object)this.getName(), (String)DriverMgmtMessages.getString("CategoryDescriptor.msg.name_missing"));
    }

    public static CategoryDescriptor[] getCategoryDescriptors() {
        if (fgCategoryDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityPlugin.getDefault().getBundle().getSymbolicName(), "driverExtension");
            fgCategoryDescriptors = CategoryDescriptor.createCategoryDescriptors(elements);
        }
        return fgCategoryDescriptors;
    }

    public static CategoryDescriptor getCategoryDescriptor(String id) {
        if (fgCategoryDescriptors == null) {
            fgCategoryDescriptors = CategoryDescriptor.getCategoryDescriptors();
        }
        for (int i = 0; i < fgCategoryDescriptors.length; ++i) {
            CategoryDescriptor desc = fgCategoryDescriptors[i];
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public static CategoryDescriptor[] getRootCategories() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        ArrayList<CategoryDescriptor> cats = new ArrayList<CategoryDescriptor>(col.size());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            CategoryDescriptor cat = (CategoryDescriptor)itr.next();
            if (cat.getParent() != null) continue;
            cats.add(cat);
        }
        return cats.toArray(new CategoryDescriptor[cats.size()]);
    }

    public CategoryDescriptor getParent() {
        if (this.getParentCategory() != null) {
            List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
            Iterator itr = col.iterator();
            while (itr.hasNext()) {
                CategoryDescriptor cat = (CategoryDescriptor)itr.next();
                if (!cat.getId().equals(this.getParentCategory())) continue;
                return cat;
            }
        }
        return null;
    }

    public List getChildCategories() {
        List<CategoryDescriptor> col = Arrays.asList(CategoryDescriptor.getCategoryDescriptors());
        ArrayList<CategoryDescriptor> cats = new ArrayList<CategoryDescriptor>(col.size());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            CategoryDescriptor cat = (CategoryDescriptor)itr.next();
            if (cat.getParent() == null || !cat.getParentCategory().equals(this.getId())) continue;
            cats.add(cat);
        }
        return cats;
    }

    public List getAssociatedDriverTypes() {
        List<TemplateDescriptor> col = Arrays.asList(TemplateDescriptor.getDriverTemplateDescriptors());
        ArrayList<TemplateDescriptor> dts = new ArrayList<TemplateDescriptor>(col.size());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            TemplateDescriptor dt = (TemplateDescriptor)itr.next();
            if (dt.getParentCategory() == null || !dt.getParentCategory().equals(this.getId())) continue;
            dts.add(dt);
        }
        return dts;
    }

    public String getId() {
        return this.fElement.getAttribute(ID_ATTRIBUTE);
    }

    public String getParentCategory() {
        return this.fElement.getAttribute(PARENTCATEGORY_ATTRIBUTE);
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public String getName() {
        String name = this.fElement.getAttribute(NAME_ATTRIBUTE);
        if (name == null && this.getId() != null) {
            name = this.getId();
        }
        return name;
    }

    public String getDescription() {
        String description = this.fElement.getAttribute(DESCRIPTION_ATTRIBUTE);
        if (description == null) {
            description = "";
        }
        return description;
    }

    public int compareTo(Object o) {
        if (o instanceof CategoryDescriptor) {
            return Collator.getInstance().compare(this.getName(), ((CategoryDescriptor)o).getName());
        }
        return Integer.MIN_VALUE;
    }

    private static CategoryDescriptor[] createCategoryDescriptors(IConfigurationElement[] elements) {
        ArrayList<CategoryDescriptor> result = new ArrayList<CategoryDescriptor>(5);
        HashSet<String> descIds = new HashSet<String>(5);
        for (int i = 0; i < elements.length; ++i) {
            IConfigurationElement element = elements[i];
            if (!CATEGORY_ELEMENT_TAG.equals(element.getName())) continue;
            CategoryDescriptor[] desc = new CategoryDescriptor[1];
            SafeRunner.run((ISafeRunnable)new MySafeRunnable(desc, element));
            if (desc[0] == null || descIds.contains(desc[0].getId())) continue;
            result.add(desc[0]);
            descIds.add(desc[0].getId());
        }
        Collections.sort(result);
        return result.toArray(new CategoryDescriptor[result.size()]);
    }

    public String toString() {
        return this.getName();
    }
}

