/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ConnectionProfileException;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IProfileListener;
import org.eclipse.datatools.connectivity.IProfileListener1;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileMgmt;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.UUID;

public class InternalProfileManager {
    private static InternalProfileManager mManager = null;
    private IConnectionProfile[] mProfiles = null;
    private boolean mIsDirty = false;
    private ListenerList mProfileListeners = new ListenerList();

    private InternalProfileManager() {
    }

    public static InternalProfileManager getInstance() {
        if (mManager == null) {
            mManager = new InternalProfileManager();
        }
        return mManager;
    }

    public IConnectionProfile[] getProfiles() {
        if (this.mProfiles == null) {
            this.loadProfiles();
        }
        return this.mProfiles;
    }

    public ICategory getCategory(String catID) {
        ConnectionProfileManager cpm = ConnectionProfileManager.getInstance();
        return cpm.getCategory(catID);
    }

    public ICategory[] getRootCategories() {
        Collection col = ConnectionProfileManager.getInstance().getCategories().values();
        ArrayList<ICategory> cats = new ArrayList<ICategory>(col.size());
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            ICategory cat = (ICategory)itr.next();
            if (cat.getParent() != null) continue;
            cats.add(cat);
        }
        return cats.toArray(new ICategory[cats.size()]);
    }

    public IConnectionProfile[] getProfilesByCategory(String catID) {
        ArrayList<IConnectionProfile> cps = new ArrayList<IConnectionProfile>();
        IConnectionProfile[] profiles = this.getProfiles();
        if (catID == null) {
            return profiles;
        }
        for (int i = 0; i < profiles.length; ++i) {
            if (profiles[i].getProvider().getCategory() == null || !profiles[i].getProvider().getCategory().getId().equals(catID)) continue;
            cps.add(profiles[i]);
        }
        return cps.toArray(new IConnectionProfile[0]);
    }

    public IConnectionProfile getProfileByName(String name) {
        IConnectionProfile[] cps = this.getProfiles();
        IConnectionProfile cp = null;
        for (int i = 0; i < cps.length; ++i) {
            if (!cps[i].getName().equals(name)) continue;
            cp = cps[i];
            break;
        }
        return cp;
    }

    public IConnectionProfile getProfileByInstanceID(String id) {
        IConnectionProfile[] cps = this.getProfiles();
        IConnectionProfile cp = null;
        for (int i = 0; i < cps.length; ++i) {
            if (!cps[i].getInstanceID().equals(id)) continue;
            cp = cps[i];
            break;
        }
        return cp;
    }

    public IConnectionProfile[] getProfileByProviderID(String ID) {
        IConnectionProfile[] cps = this.getProfiles();
        ArrayList<IConnectionProfile> cpset = new ArrayList<IConnectionProfile>();
        for (int i = 0; i < cps.length; ++i) {
            if (!cps[i].getProviderId().equals(ID)) continue;
            cpset.add(cps[i]);
        }
        return cpset.toArray(new IConnectionProfile[0]);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties) throws ConnectionProfileException {
        this.createProfile(name, description, providerID, baseProperties, "", false);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile) throws ConnectionProfileException {
        this.createProfile(name, description, providerID, baseProperties, parentProfile, false);
    }

    public void createProfile(String name, String description, String providerID, Properties baseProperties, String parentProfile, boolean autoConnect) throws ConnectionProfileException {
        ConnectionProfile profile = new ConnectionProfile(name, description, providerID, parentProfile, autoConnect, UUID.createUUID().toString());
        profile.setBaseProperties(baseProperties);
        this.addProfile(profile);
        profile.setCreated();
    }

    public String duplicateProfile(IConnectionProfile profile) throws ConnectionProfileException {
        String profileName;
        ConnectionProfile cp = (ConnectionProfile)profile;
        int i = 0;
        do {
            profileName = ConnectivityPlugin.getDefault().getResourceString("duplicate.profile.name", new Object[]{cp.getName(), new Integer(i)});
            ++i;
        } while (this.getProfileByName(profileName) != null);
        Properties props = (Properties)cp.getBaseProperties().clone();
        this.createProfile(profileName, cp.getDescription(), cp.getProviderId(), props, cp.getParentProfile() == null ? "" : cp.getParentProfile().getName(), cp.isAutoConnect());
        return profileName;
    }

    public void addProfile(IConnectionProfile profile) throws ConnectionProfileException {
        this.addProfile(profile, false);
    }

    public void addProfile(IConnectionProfile profile, boolean replaceExisting) throws ConnectionProfileException {
        IConnectionProfile[] cps = this.getProfiles();
        for (int i = 0; i < cps.length; ++i) {
            if (!cps[i].getName().equals(profile.getName())) continue;
            if (!replaceExisting) {
                throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{profile.getName()}));
            }
            if (cps[i] != profile) {
                this.modifyProfile(profile);
            }
            return;
        }
        this.mProfiles = new IConnectionProfile[cps.length + 1];
        if (cps.length != 0) {
            System.arraycopy(cps, 0, this.mProfiles, 0, cps.length);
        }
        this.mProfiles[cps.length] = profile;
        this.mIsDirty = true;
        this.fireProfileAdded(profile);
        this.saveChanges();
        if (profile.isAutoConnect()) {
            profile.connect(null);
        }
    }

    public void deleteProfile(IConnectionProfile profile) throws ConnectionProfileException {
        IConnectionProfile[] cps = this.getProfiles();
        ArrayList<IConnectionProfile> cpList = new ArrayList<IConnectionProfile>();
        boolean found = false;
        int index = -1;
        for (int i = 0; i < cps.length; ++i) {
            cpList.add(cps[i]);
            if (!cps[i].getName().equals(profile.getName())) continue;
            found = true;
            index = i;
        }
        if (!found || cps.length == 0) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        if (index >= 0) {
            cpList.remove(index);
        }
        this.mProfiles = cpList.toArray(new IConnectionProfile[0]);
        this.mIsDirty = true;
        profile.disconnect();
        this.fireProfileDeleted(profile);
        this.saveChanges();
    }

    public void modifyProfile(IConnectionProfile profile) throws ConnectionProfileException {
        this.modifyProfile(profile, null, null, null);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc) throws ConnectionProfileException {
        this.modifyProfile(profile, newName, newDesc, null);
    }

    public void modifyProfile(IConnectionProfile profile, String newName, String newDesc, Boolean autoConnect) throws ConnectionProfileException {
        IConnectionProfile[] cps = this.getProfiles();
        boolean found = false;
        boolean foundnew = false;
        int index = 0;
        for (int i = 0; i < cps.length; ++i) {
            if (cps[i].getName().equals(profile.getName())) {
                found = true;
                index = i;
            }
            if (!cps[i].getName().equals(newName)) continue;
            foundnew = true;
        }
        if (!found) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.notexist", new Object[]{profile.getName()}));
        }
        if (foundnew && !profile.getName().equals(newName)) {
            throw new ConnectionProfileException(ConnectivityPlugin.getDefault().getResourceString("profile.duplicate", new Object[]{newName}));
        }
        ConnectionProfile internalProfile = (ConnectionProfile)profile;
        String oldName = profile.getName();
        String oldDesc = profile.getDescription();
        Boolean oldAutoConnect = new Boolean(profile.isAutoConnect());
        if (newName != null && !newName.equals(oldName)) {
            internalProfile.setName(newName);
        }
        if (newDesc != null && !newDesc.equals(oldDesc)) {
            internalProfile.setDescription(newDesc);
        }
        if (autoConnect != null && !autoConnect.equals(oldAutoConnect)) {
            internalProfile.setAutoConnect(autoConnect);
            if (autoConnect.booleanValue() && !internalProfile.isConnected()) {
                internalProfile.connect(null);
            }
        }
        cps[index] = profile;
        this.mIsDirty = true;
        this.fireProfileChanged(profile, oldName, oldDesc, oldAutoConnect);
        this.saveChanges();
    }

    public void saveChanges() {
        if (this.mIsDirty) {
            try {
                ConnectionProfileMgmt.saveCPs(this.getProfiles());
                this.setDirty(false);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
            }
        }
    }

    public void addProfileListener(IProfileListener listener) {
        this.mProfileListeners.add((Object)listener);
    }

    public void removeProfileListener(IProfileListener listener) {
        this.mProfileListeners.remove((Object)listener);
    }

    private void loadProfiles() {
        IConnectionProfile[] dcps;
        IConnectionProfile[] scps;
        File serverFile = ConnectivityPlugin.getDefault().getStateLocation().append("ServerProfiles.dat").toFile();
        File defaultFile = null;
        try {
            URL url = ConnectivityPlugin.getDefault().getBundle().getEntry("WorkSpaceServerConnectionProfiles.xml");
            if (url != null) {
                defaultFile = new File(Platform.asLocalURL((URL)url).getFile());
            }
        }
        catch (IOException e) {
            ConnectivityPlugin.getDefault().log(e);
        }
        if (serverFile.exists()) {
            try {
                scps = ConnectionProfileMgmt.loadCPs(serverFile);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
                scps = new IConnectionProfile[]{};
            }
        } else {
            scps = new IConnectionProfile[]{};
        }
        if (defaultFile != null && defaultFile.exists() && defaultFile.lastModified() > serverFile.lastModified()) {
            try {
                dcps = ConnectionProfileMgmt.loadCPs(defaultFile);
            }
            catch (Exception e) {
                ConnectivityPlugin.getDefault().log(e);
                dcps = new IConnectionProfile[]{};
            }
        } else {
            dcps = new IConnectionProfile[]{};
        }
        HashMap<String, IConnectionProfile> nameToProfileMap = new HashMap<String, IConnectionProfile>(scps.length + dcps.length);
        for (int i = 0; i < dcps.length; ++i) {
            if (dcps[i].getName() == null) continue;
            nameToProfileMap.put(dcps[i].getName(), dcps[i]);
        }
        ArrayList defaultProfiles = new ArrayList(nameToProfileMap.values());
        for (int i = 0; i < scps.length; ++i) {
            IConnectionProfile replacedProfile;
            if (scps[i].getName() == null || (replacedProfile = nameToProfileMap.put(scps[i].getName(), scps[i])) == null) continue;
            defaultProfiles.remove(replacedProfile);
        }
        this.mProfiles = nameToProfileMap.values().toArray(new IConnectionProfile[nameToProfileMap.size()]);
        Iterator it = defaultProfiles.iterator();
        while (it.hasNext()) {
            this.fireProfileAdded((IConnectionProfile)it.next());
        }
        this.autoConnectProfiles();
    }

    private void fireProfileAdded(IConnectionProfile profile) {
        Object[] ls = this.mProfileListeners.getListeners();
        for (int i = 0; i < ls.length; ++i) {
            ((IProfileListener)ls[i]).profileAdded(profile);
        }
    }

    private void fireProfileDeleted(IConnectionProfile profile) {
        Object[] ls = this.mProfileListeners.getListeners();
        for (int i = 0; i < ls.length; ++i) {
            ((IProfileListener)ls[i]).profileDeleted(profile);
        }
    }

    private void fireProfileChanged(IConnectionProfile profile, String oldName, String oldDesc, Boolean oldAutoConnect) {
        Object[] ls = this.mProfileListeners.getListeners();
        for (int i = 0; i < ls.length; ++i) {
            if (ls[i] instanceof IProfileListener1) {
                ((IProfileListener1)ls[i]).profileChanged(profile, oldName, oldDesc, oldAutoConnect);
                continue;
            }
            ((IProfileListener)ls[i]).profileChanged(profile);
        }
    }

    private void autoConnectProfiles() {
        int count = this.mProfiles.length;
        for (int index = 0; index < count; ++index) {
            if (!this.mProfiles[index].isAutoConnect()) continue;
            this.mProfiles[index].connect(null);
        }
    }

    void dispose() {
        if (this.mProfiles == null) {
            return;
        }
        this.mProfileListeners.clear();
        this.saveChanges();
        int count = this.mProfiles.length;
        for (int index = 0; index < count; ++index) {
            ((ConnectionProfile)this.mProfiles[index]).dispose();
        }
        mManager = null;
    }

    public void setDirty(boolean isDirty) {
        this.mIsDirty = isDirty;
    }
}

