/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtensionPointManager;
import org.eclipse.birt.report.designer.internal.ui.extension.FormPageDef;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.editors.extension.IExtensionConstants;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.Assert;

public class EditorContributorManager
implements IExtensionConstants {
    private HashMap editorContributorMap;
    private static EditorContributorManager instance = null;

    private EditorContributorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditorContributorManager getInstance() {
        if (instance == null) {
            Class clazz = ExtensionPointManager.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new EditorContributorManager();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorContributor[] getEditorContributors() {
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            if (this.editorContributorMap == null) {
                this.createEditorContributorMap();
                if (this.editorContributorMap == null) {
                    return null;
                }
            }
        }
        return this.editorContributorMap.values().toArray(new EditorContributor[this.editorContributorMap.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EditorContributor getEditorContributor(String targetEditorId) {
        Assert.isLegal((targetEditorId != null ? 1 : 0) != 0);
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            if (this.editorContributorMap == null) {
                this.createEditorContributorMap();
                if (this.editorContributorMap == null) {
                    return null;
                }
            }
        }
        return (EditorContributor)this.editorContributorMap.get(targetEditorId);
    }

    public FormPageDef getFormPageDef(String targetEditorId, String pageId) {
        Assert.isLegal((targetEditorId != null ? 1 : 0) != 0);
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        int index = this.findFormPageIndex(targetEditorId, pageId);
        if (index != -1) {
            return this.getFormPageDef(targetEditorId, index);
        }
        return null;
    }

    public int findFormPageIndex(String targetEditorId, String pageId) {
        List formPageDefList;
        Assert.isLegal((targetEditorId != null ? 1 : 0) != 0);
        Assert.isLegal((pageId != null ? 1 : 0) != 0);
        EditorContributor editorContributor = this.getEditorContributor(targetEditorId);
        if (editorContributor != null && (formPageDefList = editorContributor.formPageList) != null) {
            for (int i = 0; i < formPageDefList.size(); ++i) {
                FormPageDef formPageDef = (FormPageDef)formPageDefList.get(i);
                if (formPageDef == null || !formPageDef.equals(pageId)) continue;
                return i;
            }
        }
        return -1;
    }

    public FormPageDef getFormPageDef(String targetEditorId, int index) {
        Assert.isLegal((targetEditorId != null ? 1 : 0) != 0);
        Assert.isLegal((index >= 0 ? 1 : 0) != 0);
        EditorContributor editorContributor = this.getEditorContributor(targetEditorId);
        if (editorContributor != null && editorContributor.formPageList != null) {
            return (FormPageDef)editorContributor.formPageList.get(index);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEditorContributorMap() {
        EditorContributorManager editorContributorManager = this;
        synchronized (editorContributorManager) {
            this.editorContributorMap = new HashMap();
            Iterator iter = this.getExtensionElements("org.eclipse.birt.report.designer.ui.editors.multiPageEditorContributor").iterator();
            while (iter.hasNext()) {
                IExtension extension = (IExtension)iter.next();
                IConfigurationElement[] elements = extension.getConfigurationElements();
                for (int i = 0; i < elements.length; ++i) {
                    EditorContributor editorContributor = this.createEditorContributor(elements[i]);
                    if (!this.editorContributorMap.containsKey(editorContributor.targetEditorId)) {
                        this.editorContributorMap.put(editorContributor.targetEditorId, editorContributor);
                        continue;
                    }
                    EditorContributor exsitContributor = (EditorContributor)this.editorContributorMap.get(editorContributor.targetEditorId);
                    exsitContributor.merge(editorContributor);
                }
            }
        }
    }

    private EditorContributor createEditorContributor(IConfigurationElement element) {
        EditorContributor editorContributor = new EditorContributor();
        editorContributor.targetEditorId = this.loadStringAttribute(element, "targetEditorId");
        editorContributor.formPageList = EditorContributorManager.sortFormPageList(this.createFormPageDefList(element));
        return editorContributor;
    }

    private static List sortFormPageList(List formPageList) {
        ArrayList<FormPageDef> list = new ArrayList<FormPageDef>(formPageList.size());
        HashMap relativeMap = new HashMap();
        Iterator iter = formPageList.iterator();
        while (iter.hasNext()) {
            List relativeList;
            FormPageDef element = (FormPageDef)iter.next();
            if (element.relative == null) {
                list.add(0, element);
                continue;
            }
            int relativePosition = EditorContributorManager.getRelativeElementPosition(element, list);
            if (relativePosition > -1) {
                list.add(relativePosition + element.position, element);
                if (!relativeMap.containsKey(element)) continue;
                relativeList = (List)relativeMap.get(element);
                Iterator iterator = relativeList.iterator();
                while (iterator.hasNext()) {
                    FormPageDef relativeFormPage = (FormPageDef)iterator.next();
                    list.remove(relativeFormPage);
                    list.add(relativePosition + element.position + relativeFormPage.position, relativeFormPage);
                }
                continue;
            }
            if (relativeMap.containsKey(element)) {
                relativeList = (List)relativeMap.get(element);
                FormPageDef relativeElement = (FormPageDef)relativeList.get(0);
                relativePosition = EditorContributorManager.getElementPosition(relativeElement, list);
                int position = relativePosition - relativeElement.position;
                list.add(position < 0 ? 0 : position, element);
                Iterator iterator = relativeList.iterator();
                while (iterator.hasNext()) {
                    FormPageDef relativeFormPage = (FormPageDef)iterator.next();
                    list.remove(relativeFormPage);
                    list.add(relativePosition + element.position + relativeFormPage.position, relativeFormPage);
                }
                continue;
            }
            EditorContributorManager.addRelativeMap(element, formPageList, relativeMap);
            list.add(list.size(), element);
        }
        return list;
    }

    private static int getElementPosition(FormPageDef relativeElement, List list) {
        return list.indexOf(relativeElement);
    }

    private static void addRelativeMap(FormPageDef element, List formPageList, Map relativeMap) {
        Iterator iter = formPageList.iterator();
        while (iter.hasNext()) {
            FormPageDef formPage = (FormPageDef)iter.next();
            if (!formPage.id.equals(element.relative)) continue;
            if (relativeMap.containsKey(formPage)) {
                ((ArrayList)relativeMap.get(formPage)).add(element);
                break;
            }
            ArrayList<FormPageDef> list = new ArrayList<FormPageDef>();
            list.add(element);
            relativeMap.put(formPage, list);
            break;
        }
    }

    private static int getRelativeElementPosition(FormPageDef element, List list) {
        String relativeId = element.relative;
        int i = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            FormPageDef formPage = (FormPageDef)iter.next();
            if (formPage.id.equals(relativeId)) {
                return list.indexOf(formPage);
            }
            ++i;
        }
        return -1;
    }

    private List createFormPageDefList(IConfigurationElement element) {
        ArrayList<FormPageDef> formPageDefList = new ArrayList<FormPageDef>();
        ArrayList<String> keyList = new ArrayList<String>();
        IConfigurationElement[] elements = element.getChildren();
        for (int i = 0; i < elements.length; ++i) {
            FormPageDef formPageDef = new FormPageDef(elements[i]);
            if (keyList.contains(formPageDef.id)) continue;
            formPageDefList.add(formPageDef);
            keyList.add(formPageDef.id);
        }
        return formPageDefList;
    }

    private List getExtensionElements(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Collections.EMPTY_LIST;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(id);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(extensionPoint.getExtensions());
    }

    private Object loadClass(IConfigurationElement element, String attributeName) {
        Object clazz = null;
        try {
            clazz = element.createExecutableExtension(attributeName);
        }
        catch (CoreException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return clazz;
    }

    private String loadStringAttribute(IConfigurationElement element, String attributeName) {
        return element.getAttribute(attributeName);
    }

    private boolean loadBooleanAttribute(IConfigurationElement element, String attributeName) {
        String value = element.getAttribute(attributeName);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static class EditorContributor {
        public String targetEditorId;
        public List formPageList;

        public boolean merge(EditorContributor contributor) {
            Assert.isNotNull((Object)this.targetEditorId);
            boolean merged = false;
            if (this.targetEditorId.equals(contributor.targetEditorId)) {
                Iterator itor = contributor.formPageList.iterator();
                while (itor.hasNext()) {
                    FormPageDef incomingPage = (FormPageDef)itor.next();
                    FormPageDef exsitPage = this.getPage(incomingPage.id);
                    if (exsitPage == null) {
                        this.formPageList.add(incomingPage);
                        merged = true;
                        continue;
                    }
                    int index = this.formPageList.indexOf(exsitPage);
                    this.formPageList.remove(exsitPage);
                    this.formPageList.add(index, incomingPage);
                }
                this.formPageList = EditorContributorManager.sortFormPageList(this.formPageList);
            }
            return merged;
        }

        public FormPageDef getPage(int index) {
            return (FormPageDef)this.formPageList.get(index);
        }

        public FormPageDef getPage(String id) {
            Iterator itor = this.formPageList.iterator();
            while (itor.hasNext()) {
                FormPageDef page = (FormPageDef)itor.next();
                if (!page.id.equals(id)) continue;
                return page;
            }
            return null;
        }
    }
}

