/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.ui.wizards;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.ResultSetColumns;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.ui.designsession.DesignSessionUtil;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.datatools.connectivity.oda.flatfile.FlatFileDriver;
import org.eclipse.datatools.connectivity.oda.flatfile.ui.i18n.Messages;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class FileSelectionWizardPage
extends DataSetWizardPage
implements ISelectionChangedListener {
    private static String DEFAULT_MESSAGE = Messages.getString("wizard.defaultMessage.selectFile");
    private static final String ALL_CSV_SUFFIX = "*.csv";
    private static final String CSV_SUFFIX = ".csv";
    private static final String ALL_TXT_SUFFIX = "*.txt";
    private static final String TXT_SUFFIX = ".txt";
    private static final String MATCH_ALL_FILES = "*.*";
    private final int DEFAULT_WIDTH = 200;
    private final int DEFAULT_HEIGHT = 200;
    private transient ComboViewer m_fileViewer = null;
    private transient ComboViewer m_fileFilter = null;
    private transient List m_availableList = null;
    private transient List m_selectedList = null;
    private transient Button m_btnAdd = null;
    private transient Button m_btnAddAll = null;
    private transient Button m_btnRemove = null;
    private transient Button m_btnRemoveAll = null;
    private boolean m_initialized = true;
    private String m_charSet = null;
    private String m_inclTypeLine;
    private String m_selectedFileFilter;
    private File m_selectedFile;

    public FileSelectionWizardPage(String pageName) {
        super(pageName);
        this.setTitle(pageName);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(false);
    }

    public FileSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createPageCustomControl(Composite parent) {
        this.setControl(this.createPageControl(parent));
        this.initializeControl();
    }

    private void initializeControl() {
        DataSetDesign dataSetDesign = this.getInitializationDesign();
        if (dataSetDesign == null) {
            return;
        }
        String queryText = dataSetDesign.getQueryText();
        if (queryText == null) {
            return;
        }
        this.updateValuesFromQuery(queryText);
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (!this.hasValidData()) {
            return design;
        }
        this.savePage(design);
        return design;
    }

    protected void collectResponseState() {
        super.collectResponseState();
    }

    protected boolean canLeave() {
        if (!this.isPageComplete()) {
            this.setMessage(Messages.getString("error.selectColumns"), 3);
        }
        return this.isPageComplete();
    }

    private Control createPageControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        final Shell shell = composite.getShell();
        FormLayout layout = new FormLayout();
        composite.setLayout((Layout)layout);
        FormData data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.top = new FormAttachment(0, 5);
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("label.selectFile"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(80, -5);
        this.m_fileViewer = new ComboViewer(composite, 2056);
        this.m_fileViewer.getControl().setLayoutData((Object)data);
        this.m_fileViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.m_fileViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.m_fileViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((File)element).getName();
            }
        });
        data = new FormData();
        data.left = new FormAttachment(this.m_fileViewer.getControl(), 5);
        data.top = new FormAttachment(0, 5);
        label = new Label(composite, 0);
        label.setText(Messages.getString("label.fileFilter"));
        label.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)label, 5);
        data.right = new FormAttachment(100, -5);
        this.m_fileFilter = new ComboViewer(composite, 8);
        this.m_fileFilter.getControl().setLayoutData((Object)data);
        this.m_fileFilter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String currSelectFilter = FileSelectionWizardPage.this.m_fileFilter.getCombo().getText();
                if (currSelectFilter.equalsIgnoreCase(FileSelectionWizardPage.this.m_selectedFileFilter)) {
                    return;
                }
                if (!FileSelectionWizardPage.this.m_initialized) {
                    FileSelectionWizardPage.this.m_selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                    FileSelectionWizardPage.this.m_initialized = true;
                } else if (currSelectFilter.equals(FileSelectionWizardPage.MATCH_ALL_FILES) || MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("confirm.reselectFileFilterTitle"), (String)Messages.getString("confirm.reselectFileFilterMessage"))) {
                    FileSelectionWizardPage.this.m_selectedFileFilter = currSelectFilter;
                    FileSelectionWizardPage.this.updateFileListAndCharSet();
                } else {
                    FileSelectionWizardPage.this.m_fileFilter.getCombo().setText(FileSelectionWizardPage.this.m_selectedFileFilter);
                }
            }
        });
        data = new FormData();
        data.top = new FormAttachment(this.m_fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(47, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 200;
        data.height = 200;
        this.m_availableList = new List(composite, 2818);
        this.m_availableList.setLayoutData((Object)data);
        this.m_availableList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.m_btnAdd.setEnabled(true);
                FileSelectionWizardPage.this.m_btnAddAll.setEnabled(true);
            }
        });
        this.m_availableList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileSelectionWizardPage.this.addColumns();
            }
        });
        data = new FormData();
        data.left = new FormAttachment((Control)this.m_availableList, 5);
        data.bottom = new FormAttachment(75);
        Composite btnComposite = new Composite(composite, 0);
        btnComposite.setLayoutData((Object)data);
        FillLayout btnLayout = new FillLayout(512);
        btnLayout.spacing = 5;
        btnComposite.setLayout((Layout)btnLayout);
        this.m_btnAdd = new Button(btnComposite, 0);
        this.m_btnAdd.setText(">");
        this.m_btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.addColumns();
            }
        });
        this.m_btnAddAll = new Button(btnComposite, 0);
        this.m_btnAddAll.setText(">>");
        this.m_btnAddAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.addItems(FileSelectionWizardPage.this.m_availableList.getItems(), FileSelectionWizardPage.this.m_selectedList);
                FileSelectionWizardPage.this.m_availableList.removeAll();
                FileSelectionWizardPage.this.m_btnAdd.setEnabled(false);
                FileSelectionWizardPage.this.m_btnAddAll.setEnabled(false);
                FileSelectionWizardPage.this.setPageComplete(true);
                FileSelectionWizardPage.this.m_btnRemoveAll.setEnabled(true);
                FileSelectionWizardPage.this.setMessage(DEFAULT_MESSAGE);
            }
        });
        this.m_btnRemove = new Button(btnComposite, 0);
        this.m_btnRemove.setText("<");
        this.m_btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.removeColumns();
            }
        });
        this.m_btnRemoveAll = new Button(btnComposite, 0);
        this.m_btnRemoveAll.setText("<<");
        this.m_btnRemoveAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.addItems(FileSelectionWizardPage.this.m_selectedList.getItems(), FileSelectionWizardPage.this.m_availableList);
                FileSelectionWizardPage.this.m_selectedList.removeAll();
                FileSelectionWizardPage.this.m_btnRemove.setEnabled(false);
                FileSelectionWizardPage.this.m_btnRemoveAll.setEnabled(false);
                FileSelectionWizardPage.this.m_btnAddAll.setEnabled(true);
                FileSelectionWizardPage.this.setPageComplete(false);
            }
        });
        data = new FormData();
        data.top = new FormAttachment(this.m_fileViewer.getControl(), 10, 1024);
        data.left = new FormAttachment((Control)btnComposite, 5);
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        data.width = 200;
        this.m_selectedList = new List(composite, 2818);
        this.m_selectedList.setLayoutData((Object)data);
        this.m_selectedList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileSelectionWizardPage.this.m_btnRemove.setEnabled(true);
                FileSelectionWizardPage.this.m_btnRemoveAll.setEnabled(true);
            }
        });
        this.m_selectedList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FileSelectionWizardPage.this.removeColumns();
            }
        });
        this.populateFileFilter();
        this.updateFileListAndCharSet();
        return composite;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        File file = (File)((IStructuredSelection)event.getSelection()).getFirstElement();
        if (file.equals(this.m_selectedFile)) {
            return;
        }
        this.m_selectedFile = file;
        this.setPageComplete(false);
        this.m_selectedList.removeAll();
        this.m_availableList.removeAll();
        String[] columnNames = this.getFileColumnNames(file);
        if (columnNames != null && columnNames.length != 0) {
            this.enableAll();
            this.m_availableList.setItems(columnNames);
            this.m_availableList.select(0);
            this.m_btnRemoveAll.setEnabled(false);
            this.m_btnRemove.setEnabled(false);
            this.setMessage(DEFAULT_MESSAGE);
        }
    }

    private void updateFileListAndCharSet() {
        org.eclipse.datatools.connectivity.oda.design.Properties dataSourceProps = this.getInitializationDesign().getDataSourceDesign().getPublicProperties();
        if (this.m_fileViewer != null && !this.m_fileViewer.getControl().isDisposed()) {
            File[] files;
            String odaHome = dataSourceProps.getProperty("HOME");
            if (odaHome == null) {
                this.setMessage("");
                this.disableAll();
                return;
            }
            this.m_charSet = dataSourceProps.getProperty("CHARSET");
            this.m_inclTypeLine = dataSourceProps.getProperty("INCLTYPELINE");
            File folder = new File(odaHome);
            if (folder.isDirectory() && folder.exists()) {
                files = folder.getAbsoluteFile().listFiles(new CSVFileFilter(this.m_fileFilter.getCombo().getText()));
                if (files != null) {
                    this.setMessage(DEFAULT_MESSAGE);
                    this.m_fileViewer.setInput((Object)files);
                } else {
                    this.m_fileViewer.setInput((Object)new File[0]);
                }
            } else {
                this.m_fileViewer.setInput((Object)new File[0]);
            }
            files = (File[])this.m_fileViewer.getInput();
            if (files.length > 0) {
                this.enableAll();
                File toSelectFile = null;
                if (this.m_selectedFile != null) {
                    for (int i = 0; i < files.length; ++i) {
                        if (!files[i].equals(this.m_selectedFile)) continue;
                        toSelectFile = this.m_selectedFile;
                        break;
                    }
                }
                if (toSelectFile == null) {
                    toSelectFile = files[0];
                }
                this.m_fileViewer.setSelection((ISelection)new StructuredSelection((Object)toSelectFile));
            } else {
                this.setMessage(Messages.getFormattedString("error.noCSVFiles", new Object[]{folder.getAbsolutePath()}));
                this.disableAll();
            }
        }
    }

    private String[] getFileColumnNames(File file) {
        return this.getQueryColumnNames("select * from " + file.getName(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getQueryColumnNames(String queryText, File file) {
        FlatFileDriver ffDriver = new FlatFileDriver();
        IConnection conn = null;
        try {
            conn = ffDriver.getConnection(null);
            IResultSetMetaData metadata = this.getResultSetMetaData(queryText, file, conn);
            int columnCount = metadata.getColumnCount();
            if (columnCount == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            String[] result = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                result[i] = metadata.getColumnName(i + 1);
            }
            String[] stringArray = result;
            return stringArray;
        }
        catch (OdaException e) {
            this.setMessage(e.getLocalizedMessage(), 3);
            this.disableAll();
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void closeConnection(IConnection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (OdaException odaException) {
            // empty catch block
        }
    }

    private IResultSetMetaData getResultSetMetaData(String queryText, File file, IConnection conn) throws OdaException {
        Properties prop = new Properties();
        prop.put("HOME", file.getParent());
        prop.put("CHARSET", this.m_charSet);
        prop.put("INCLTYPELINE", this.m_inclTypeLine);
        conn.open(prop);
        IQuery query = conn.newQuery(null);
        query.setMaxRows(1);
        query.prepare(queryText);
        query.executeQuery();
        return query.getMetaData();
    }

    private void enableAll() {
        this.m_availableList.setEnabled(true);
        this.m_selectedList.setEnabled(true);
        this.m_btnAdd.setEnabled(true);
        this.m_btnAddAll.setEnabled(true);
        this.m_btnRemove.setEnabled(true);
        this.m_btnRemoveAll.setEnabled(true);
    }

    private void disableAll() {
        this.m_availableList.setEnabled(false);
        this.m_selectedList.setEnabled(false);
        this.m_btnAdd.setEnabled(false);
        this.m_btnAddAll.setEnabled(false);
        this.m_btnRemove.setEnabled(false);
        this.m_btnRemoveAll.setEnabled(false);
        this.setPageComplete(false);
    }

    private void addItems(String[] items, List targetList) {
        for (int n = 0; n < items.length; ++n) {
            targetList.add(items[n]);
        }
    }

    private void removeSelectedItems(List targetList) {
        targetList.remove(targetList.getSelectionIndices());
        targetList.select(targetList.getTopIndex());
    }

    private String getQuery() {
        String tableName = null;
        StringBuffer buf = new StringBuffer();
        File file = (File)((StructuredSelection)this.m_fileViewer.getSelection()).getFirstElement();
        if (file != null) {
            tableName = file.getName();
        }
        if (tableName != null) {
            if (this.m_availableList.getItemCount() == 0) {
                buf.append("select * from ").append(tableName);
            } else {
                buf.append("select ");
                String[] columns = this.m_selectedList.getItems();
                for (int n = 0; n < columns.length; ++n) {
                    buf.append(columns[n]);
                    if (n >= columns.length - 1) continue;
                    buf.append(", ");
                }
                buf.append(" from ").append(tableName);
            }
        }
        return buf.toString();
    }

    private void updateValuesFromQuery(String query) {
        String[] splitQuery = FileSelectionWizardPage.stripFromClause(query);
        if (splitQuery.length == 2) {
            File f;
            String table = splitQuery[1];
            String columns = this.stripSelect(splitQuery[0]);
            if (table != null && columns != null && (f = this.selectTableFromQuery(table)) != null) {
                this.updateColumnsFromQuery(this.getColumnsFromQuery(columns), this.getFileColumnNames(f));
            }
        }
        if (this.m_selectedList.getItemCount() == 0) {
            this.m_btnRemoveAll.setEnabled(false);
            this.setPageComplete(false);
        }
    }

    private String stripSelect(String selectedColumns) {
        String[] result = selectedColumns.split("SELECT ");
        if (result.length == 2) {
            return result[1];
        }
        return null;
    }

    private static String[] stripFromClause(String query) {
        query = query.toUpperCase();
        return query.split(" FROM ");
    }

    private File selectTableFromQuery(String tableName) {
        this.resetInitialized();
        this.m_fileFilter.setSelection((ISelection)new StructuredSelection((Object)MATCH_ALL_FILES));
        File[] files = (File[])this.m_fileViewer.getInput();
        for (int n = 0; n < files.length; ++n) {
            if (!files[n].getName().equalsIgnoreCase(tableName)) continue;
            this.resetInitialized();
            if (tableName.toLowerCase().endsWith(CSV_SUFFIX)) {
                this.m_fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_CSV_SUFFIX));
            } else if (tableName.toLowerCase().endsWith(TXT_SUFFIX)) {
                this.m_fileFilter.setSelection((ISelection)new StructuredSelection((Object)ALL_TXT_SUFFIX));
            }
            this.m_fileViewer.setSelection((ISelection)new StructuredSelection((Object)files[n]));
            return files[n];
        }
        return null;
    }

    private void resetInitialized() {
        this.m_initialized = false;
    }

    private void updateColumnsFromQuery(String[] columns, String[] availableColumns) {
        this.m_availableList.setItems(availableColumns);
        this.m_selectedList.removeAll();
        block0: for (int n = 0; n < columns.length; ++n) {
            if (columns[n].trim().equals("*")) {
                this.m_availableList.removeAll();
                this.m_selectedList.setItems(availableColumns);
                this.m_btnAdd.setEnabled(false);
                this.m_btnAddAll.setEnabled(false);
                this.setPageComplete(true);
                this.m_btnRemoveAll.setEnabled(true);
                return;
            }
            for (int m = 0; m < availableColumns.length; ++m) {
                if (!availableColumns[m].equalsIgnoreCase(columns[n])) continue;
                this.m_selectedList.add(availableColumns[m]);
                if (this.m_availableList.indexOf(availableColumns[m]) < 0) continue block0;
                this.m_availableList.remove(availableColumns[m]);
                continue block0;
            }
        }
        this.setPageComplete(true);
        this.m_btnRemoveAll.setEnabled(true);
        this.m_btnAddAll.setEnabled(true);
        this.m_btnAdd.setEnabled(false);
        this.m_btnRemove.setEnabled(false);
        if (this.m_availableList.getItemCount() == 0) {
            this.m_btnAddAll.setEnabled(false);
        }
        if (this.m_selectedList.getItemCount() == 0) {
            this.m_btnRemoveAll.setEnabled(false);
            this.setPageComplete(false);
        }
    }

    private String[] getColumnsFromQuery(String columnList) {
        String[] columns = columnList.split(",");
        for (int n = 0; n < columns.length; ++n) {
            String[] result = columns[n].split(" AS ");
            columns[n] = result[0].trim();
        }
        return columns;
    }

    private void populateFileFilter() {
        if (this.m_fileFilter != null && !this.m_fileFilter.getControl().isDisposed() && this.m_fileFilter.getCombo().getSelectionIndex() == -1) {
            this.m_fileFilter.add((Object)ALL_CSV_SUFFIX);
            this.m_fileFilter.add((Object)ALL_TXT_SUFFIX);
            this.m_fileFilter.add((Object)MATCH_ALL_FILES);
            this.m_fileFilter.getCombo().select(0);
            this.m_selectedFileFilter = ALL_CSV_SUFFIX;
        }
    }

    private void addColumns() {
        this.addItems(this.m_availableList.getSelection(), this.m_selectedList);
        this.removeSelectedItems(this.m_availableList);
        if (this.m_availableList.getItemCount() == 0) {
            this.m_btnAddAll.setEnabled(false);
        }
        if (this.m_availableList.getSelectionCount() == 0) {
            this.m_btnAdd.setEnabled(false);
        }
        this.m_btnRemoveAll.setEnabled(true);
        this.setMessage(DEFAULT_MESSAGE);
        this.setPageComplete(true);
    }

    private boolean hasValidData() {
        if (this.m_fileViewer == null) {
            return false;
        }
        String fileName = this.m_fileViewer.getCombo().getText().toLowerCase();
        if (!(fileName.endsWith(CSV_SUFFIX) || fileName.endsWith(TXT_SUFFIX) || this.isContinue(Messages.getString("warning.columnExtensionInvalid")))) {
            return false;
        }
        if (this.isPageComplete()) {
            return true;
        }
        this.setMessage(Messages.getString("error.selectColumns"), 3);
        return false;
    }

    private void removeColumns() {
        this.addItems(this.m_selectedList.getSelection(), this.m_availableList);
        this.removeSelectedItems(this.m_selectedList);
        if (this.m_selectedList.getSelectionCount() == 0) {
            this.m_btnRemove.setEnabled(false);
        }
        if (this.m_selectedList.getItemCount() == 0) {
            this.m_btnRemoveAll.setEnabled(false);
            this.setPageComplete(false);
        }
        this.m_btnAddAll.setEnabled(true);
    }

    private boolean isContinue(String warnMsg) {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("title.warning"), null, warnMsg, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        return dialog.open() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePage(DataSetDesign dataSetDesign) {
        String queryText = this.getQuery();
        dataSetDesign.setQueryText(queryText);
        IConnection conn = null;
        try {
            FlatFileDriver ffDriver = new FlatFileDriver();
            conn = ffDriver.getConnection(null);
            IResultSetMetaData metadata = this.getResultSetMetaData(queryText, this.m_selectedFile, conn);
            this.setResultSetMetaData(dataSetDesign, metadata);
            this.closeConnection(conn);
        }
        catch (OdaException e) {
            try {
                dataSetDesign.setResultSets(null);
                this.closeConnection(conn);
            }
            catch (Throwable throwable) {
                this.closeConnection(conn);
                throw throwable;
            }
        }
    }

    private void setResultSetMetaData(DataSetDesign dataSetDesign, IResultSetMetaData md) throws OdaException {
        ResultSetColumns columns = DesignSessionUtil.toResultSetColumnsDesign((IResultSetMetaData)md);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        resultSetDefn.setResultSetColumns(columns);
        dataSetDesign.setPrimaryResultSet(resultSetDefn);
        dataSetDesign.getResultSets().setDerivedMetaData(true);
    }

    class CSVFileFilter
    implements FilenameFilter {
        private String extension = null;

        CSVFileFilter(String ext) {
            this.extension = FileSelectionWizardPage.ALL_CSV_SUFFIX.equalsIgnoreCase(ext) ? FileSelectionWizardPage.CSV_SUFFIX : (FileSelectionWizardPage.ALL_TXT_SUFFIX.equalsIgnoreCase(ext) ? FileSelectionWizardPage.TXT_SUFFIX : null);
        }

        public boolean accept(File dir, String name) {
            if (this.extension == null) {
                File file = new File(dir + File.separator + name);
                return file.isFile() && !file.isHidden();
            }
            return name.toLowerCase().endsWith(this.extension);
        }
    }
}

