/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import com.ibm.icu.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportStyleProcessor;
import org.eclipse.birt.chart.reportitem.QueryHelper;
import org.eclipse.birt.chart.reportitem.ui.DesignerRepresentation;
import org.eclipse.birt.chart.reportitem.ui.ReportDataServiceProvider;
import org.eclipse.birt.chart.reportitem.ui.ReportItemUIUtil;
import org.eclipse.birt.chart.reportitem.ui.dialogs.ChartExpressionProvider;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.chart.style.IStyleProcessor;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.ui.swt.interfaces.IUIServiceProvider;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.core.ui.frameworks.taskwizard.interfaces.IWizardContext;
import org.eclipse.birt.report.designer.internal.ui.dialogs.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.HyperlinkBuilder;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.extensions.ReportItemBuilderUI;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChartReportItemBuilderImpl
extends ReportItemBuilderUI
implements IUIServiceProvider {
    private static int iInstanceCount = 0;
    private transient ExtendedItemHandle extendedHandle = null;
    private transient String taskId = null;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.reportitem/trace");

    public ChartReportItemBuilderImpl() {
    }

    public ChartReportItemBuilderImpl(String taskId) {
        this.taskId = taskId;
    }

    public int open(ExtendedItemHandle eih) {
        if (iInstanceCount > 0) {
            return 1;
        }
        ++iInstanceCount;
        try {
            IReportItem item = null;
            try {
                item = eih.getReportItem();
                if (item == null) {
                    eih.loadExtendedElement();
                    item = eih.getReportItem();
                }
            }
            catch (ExtendedElementException exception) {
                logger.log((Exception)((Object)exception));
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemBuilderImpl.log.UnableToLocate"));
                --iInstanceCount;
                return 1;
            }
            ChartReportItemImpl crii = (ChartReportItemImpl)item;
            Chart cm = (Chart)crii.getProperty("chart.instance");
            Chart cmClone = cm == null ? null : (Chart)EcoreUtil.copy((EObject)cm);
            this.extendedHandle = eih;
            Shell parentShell = null;
            if (PlatformUI.isWorkbenchRunning()) {
                parentShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            }
            ChartWizard chartBuilder = new ChartWizard(parentShell);
            ChartWizardContext context = new ChartWizardContext(cmClone);
            context.setUIServiceProvider((IUIServiceProvider)this);
            context.setDataServiceProvider((IDataServiceProvider)new ReportDataServiceProvider(eih));
            context.setRtL(ReportItemUIUtil.isRtl());
            Object of = eih.getProperty("outputFormat");
            if (of instanceof String) {
                if (of.equals("GIF")) {
                    context.setOutputFormat("PNG");
                } else {
                    context.setOutputFormat((String)of);
                }
            }
            context.setExtendedItem((Object)eih);
            context.setProcessor((IStyleProcessor)new ChartReportStyleProcessor((DesignElementHandle)eih, false));
            context = (ChartWizardContext)chartBuilder.open(null, this.taskId, (IWizardContext)context);
            if (context != null && context.getModel() != null) {
                eih.setProperty("outputFormat", (Object)context.getOutputFormat());
                crii.executeSetModelCommand(eih, cm, context.getModel());
                try {
                    Bounds bo = context.getModel().getBlock().getBounds();
                    NumberFormat nf = ChartUIUtil.getDefaultNumberFormatInstance();
                    if (eih.getWidth().getStringValue() == null) {
                        eih.setWidth(nf.format(bo.getWidth()) + "pt");
                    }
                    if (eih.getHeight().getStringValue() == null) {
                        eih.setHeight(nf.format(bo.getHeight()) + "pt");
                    }
                }
                catch (SemanticException smx) {
                    logger.log((Exception)((Object)smx));
                }
                if (crii.getDesignerRepresentation() != null) {
                    ((DesignerRepresentation)((Object)crii.getDesignerRepresentation())).setDirty(true);
                }
                --iInstanceCount;
                this.extendedHandle = null;
                return 0;
            }
            --iInstanceCount;
            this.extendedHandle = null;
            return 1;
        }
        catch (Exception e) {
            --iInstanceCount;
            throw new RuntimeException(e);
        }
    }

    public String invoke(String sExpression, Object oContext, String sTitle) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvier((IExpressionProvider)new ExpressionProvider((DesignElementHandle)((ExtendedItemHandle)oContext)));
        if (sTitle != null) {
            eb.setDialogTitle(eb.getDialogTitle() + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    public String invoke(String sExpression, Object oContext, String sTitle, boolean isChartProvider) {
        ExpressionBuilder eb = new ExpressionBuilder(sExpression);
        eb.setExpressionProvier((IExpressionProvider)new ChartExpressionProvider());
        if (sTitle != null) {
            eb.setDialogTitle(eb.getDialogTitle() + " - " + sTitle);
        }
        if (eb.open() == 0) {
            sExpression = eb.getResult();
        }
        return sExpression;
    }

    public final String[] validate(Chart cm, Object oContext) {
        ArrayList<String> alProblems = new ArrayList<String>(4);
        ExtendedItemHandle eih = (ExtendedItemHandle)oContext;
        if (DEUtil.getDataSetList((DesignElementHandle)eih).size() == 0) {
            alProblems.add(Messages.getString("ChartReportItemBuilderImpl.problem.hasNotBeenFound"));
        }
        QueryHelper.SeriesQueries[] qsqa = new QueryHelper().getSeriesQueryDefinitions(cm);
        for (int i = 0; i < qsqa.length; ++i) {
            Collection co = qsqa[i].validate();
            if (co == null) continue;
            alProblems.addAll(co);
        }
        return alProblems.toArray(new String[alProblems.size()]);
    }

    public final List getRegisteredKeys() {
        return this.extendedHandle.getModuleHandle().getMessageKeys();
    }

    public final String getValue(String sKey) {
        String value = this.extendedHandle.getModuleHandle().getMessage(sKey);
        if (value == null || value.equals("")) {
            return sKey;
        }
        return value;
    }

    public final double getConvertedValue(double dOriginalValue, String sFromUnits, String sToUnits) {
        if (sFromUnits == null || sToUnits == null) {
            return dOriginalValue;
        }
        double dResult = -1.0;
        IDisplayServer ids = ChartUIUtil.getDisplayServer();
        if (sFromUnits.equalsIgnoreCase("pixels")) {
            dOriginalValue = dOriginalValue * 72.0 / (double)ids.getDpiResolution();
        }
        dResult = DimensionUtil.convertTo((double)dOriginalValue, (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sFromUnits), (String)ChartReportItemBuilderImpl.getBIRTUnitsFor(sToUnits)).getMeasure();
        if (sToUnits.equalsIgnoreCase("pixels")) {
            dResult = (double)ids.getDpiResolution() * dResult / 72.0;
        }
        return dResult;
    }

    private static String getBIRTUnitsFor(String sUnits) {
        if (sUnits.equalsIgnoreCase("inches")) {
            return "in";
        }
        if (sUnits.equalsIgnoreCase("centimeters")) {
            return "cm";
        }
        return "pt";
    }

    public String invoke(int command, String value, final Object context, String sTitle) throws ChartException {
        ExpressionBuilder eb = null;
        Shell shell = null;
        switch (command) {
            case 1: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.ExpressionBuilder_ID");
                eb = new ExpressionBuilder(shell, value);
                ExpressionProvider ep = new ExpressionProvider((DesignElementHandle)((ExtendedItemHandle)context));
                ep.addFilter(new ExpressionFilter(){

                    public boolean select(Object parentElement, Object element) {
                        return !parentElement.equals(ExpressionProvider.BIRT_OBJECTS) || !(element instanceof IClassInfo) || !((IClassInfo)element).getName().equals("Total");
                    }
                });
                eb.setExpressionProvier((IExpressionProvider)ep);
                if (sTitle != null) {
                    eb.setDialogTitle(eb.getDialogTitle() + " - " + sTitle);
                }
                if (eb.open() != 0) break;
                value = eb.getResult();
                break;
            }
            case 2: {
                eb = new ExpressionBuilder(value);
                eb.setExpressionProvier((IExpressionProvider)new ChartExpressionProvider());
                if (sTitle != null) {
                    eb.setDialogTitle(eb.getDialogTitle() + " - " + sTitle);
                }
                if (eb.open() != 0) break;
                value = eb.getResult();
                break;
            }
            case 3: {
                shell = new Shell(Display.getDefault(), 67696);
                ChartUIUtil.bindHelp((Control)shell, (String)"org.eclipse.birt.chart.cshelp.EditURL_ID");
                HyperlinkBuilder hb = new HyperlinkBuilder(shell){

                    protected void configureExpressionBuilder(ExpressionBuilder builder) {
                        builder.setExpressionProvier((IExpressionProvider)new ExpressionProvider((DesignElementHandle)((ExtendedItemHandle)context)));
                    }
                };
                try {
                    hb.setInputString(value, (DesignElementHandle)this.extendedHandle);
                    if (sTitle != null) {
                        hb.setTitle(hb.getTitle() + " - " + sTitle);
                    }
                    if (hb.open() != 0) break;
                    value = hb.getResultString();
                    break;
                }
                catch (Exception e) {
                    throw new ChartException("org.eclipse.birt.chart.reportitem.ui", 13, (Throwable)e);
                }
            }
        }
        return value;
    }

    public boolean isInvokingSupported() {
        return true;
    }
}

