/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.BooleanPropertyDescriptor;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.ChoicePropertyDescriptor;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.PropertyDescriptorAdapter;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.TextPropertyDescriptor;
import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.UnitPropertyDescriptor;
import org.eclipse.birt.chart.reportitem.ui.i18n.Messages;
import org.eclipse.birt.report.designer.ui.extensions.PropertyTabUIAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.AttributesUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.IPropertyDescriptor;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChartGeneralTabUIImpl
extends PropertyTabUIAdapter {
    private Object page;

    public void buildUI(Composite composite) {
        this.page = AttributesUtil.buildGeneralPage((Composite)composite, (String[])new String[]{null, "margin", "alt", "border", "section", "visibility", "toc", "bookmark", "userproperties", "namedexpressions", "eventhandler"}, (String[])new String[]{GeneralCategoryWrapper.CATEGORY_NAME}, (AttributesUtil.PageWrapper[])new AttributesUtil.PageWrapper[]{new GeneralCategoryWrapper()});
    }

    public String getTabDisplayName() {
        return AttributesUtil.getGeneralPageDisplayName();
    }

    public void setInput(List elements) {
        AttributesUtil.setPageInput((Object)this.page, (List)elements);
    }

    static class TypesCategoryWrapper
    extends AbstractCategoryWrapper {
        static String CATEGORY_NAME = Messages.getString("ChartGeneralTabUIImpl.category.types");

        TypesCategoryWrapper() {
        }

        public void buildContent(Composite parent, Map propertyMap) {
            parent.setLayout((Layout)TypesCategoryWrapper.createGridLayout(3));
            TypesCategoryWrapper.buildGridControl(parent, propertyMap, "ExtendedItem", "chart.dimension", 1, false, new ChoicePropertyDescriptor(new PropertyProcessor("ExtendedItem", "chart.dimension")), true);
            TypesCategoryWrapper.createHorizontalLine(parent, 3);
            TypesCategoryWrapper.buildGridControl(parent, propertyMap, "ExtendedItem", "plot.transposed", 2, false, new BooleanPropertyDescriptor(new PropertyProcessor("ExtendedItem", "plot.transposed")), false);
        }
    }

    static class GeneralCategoryWrapper
    extends AbstractCategoryWrapper {
        static String CATEGORY_NAME = Messages.getString("ChartGeneralTabUIImpl.category.general");
        private Text pathText;
        private Composite contextComposite;

        GeneralCategoryWrapper() {
        }

        public void setInput(List elements) {
            super.setInput(elements);
            if (this.contextComposite != null) {
                if (DEUtil.getGroupElementHandle((List)elements).isExtendedElements()) {
                    DesignElementHandle handle = (DesignElementHandle)DEUtil.getGroupElementHandle((List)elements).getElements().get(0);
                    try {
                        File libraryFile = new File(new URL(handle.getExtends().getRoot().getFileName()).getFile());
                        if (libraryFile.exists()) {
                            this.pathText.setText(libraryFile.getAbsolutePath());
                        }
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    this.contextComposite.setVisible(true);
                    GridData data = new GridData(768);
                    data.horizontalSpan = 5;
                    this.contextComposite.setLayoutData((Object)data);
                } else {
                    this.contextComposite.setVisible(false);
                    GridData data = (GridData)this.contextComposite.getLayoutData();
                    data.heightHint = 0;
                    this.contextComposite.setLayoutData((Object)data);
                }
            }
        }

        public void buildContent(Composite parent, Map propertyMap) {
            parent.setLayout((Layout)GeneralCategoryWrapper.createSpaceGridLayout(1, 0));
            this.contextComposite = new Composite(parent, 5);
            GridLayout gridLayout = GeneralCategoryWrapper.createGridLayout(5);
            gridLayout.marginHeight = 0;
            gridLayout.marginTop = 7;
            this.contextComposite.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 5;
            this.contextComposite.setLayoutData((Object)gridData);
            Label pathLabel = new Label(this.contextComposite, 0);
            pathLabel.setText(Messages.getString("GeneralPage.Library.Included"));
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            pathLabel.setLayoutData((Object)gridData);
            this.pathText = new Text(this.contextComposite, 2056);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.pathText.setLayoutData((Object)gridData);
            GeneralCategoryWrapper.createGridPlaceholder(this.contextComposite, 2, true);
            GeneralCategoryWrapper.createHorizontalLine(this.contextComposite, 5);
            Composite composite = new Composite(parent, 0);
            GridData data = new GridData(768);
            data.horizontalSpan = 1;
            data.grabExcessHorizontalSpace = true;
            composite.setLayoutData((Object)data);
            composite.setLayout((Layout)GeneralCategoryWrapper.createGridLayout(5));
            GeneralCategoryWrapper.buildGridControl(composite, propertyMap, "ExtendedItem", "name", 1, true, new TextPropertyDescriptor(new PropertyProcessor("ExtendedItem", "name")), true);
            GeneralCategoryWrapper.createHorizontalLine(composite, 5);
            GeneralCategoryWrapper.buildGridControl(composite, propertyMap, "ExtendedItem", "width", 1, true, new UnitPropertyDescriptor(new PropertyProcessor("ExtendedItem", "width")), true);
            GeneralCategoryWrapper.buildGridControl(composite, propertyMap, "ExtendedItem", "height", 1, true, new UnitPropertyDescriptor(new PropertyProcessor("ExtendedItem", "height")), true);
            GeneralCategoryWrapper.createGridPlaceholder(composite, 1, true);
            GeneralCategoryWrapper.buildGridControl(composite, propertyMap, "ExtendedItem", "style", 1, true, new ChoicePropertyDescriptor(new PropertyProcessor("ExtendedItem", "style")), true);
            GeneralCategoryWrapper.createGridPlaceholder(composite, 3, true);
        }
    }

    static abstract class AbstractCategoryWrapper
    extends AttributesUtil.PageWrapper {
        static final int MIN_TEXT_WIDTH = 80;
        static final int SPACING = 7;
        static final int MARGIN_HEIGHT = 7;
        static final int MARGIN_WIDTH = 7;

        AbstractCategoryWrapper() {
        }

        static Label createGridPlaceholder(Composite parent, int hSpan, boolean grabSpace) {
            Label label = new Label(parent, 0);
            GridData data = new GridData();
            data.horizontalSpan = hSpan;
            data.grabExcessHorizontalSpace = grabSpace;
            label.setLayoutData((Object)data);
            return label;
        }

        static Label createHorizontalLine(Composite parent, int hSpan) {
            Label label = new Label(parent, 258);
            GridData data = new GridData();
            data.horizontalSpan = hSpan;
            data.horizontalAlignment = 4;
            label.setLayoutData((Object)data);
            return label;
        }

        static GridLayout createGridLayout(int columns) {
            GridLayout layout = new GridLayout(columns, false);
            layout.marginHeight = 7;
            layout.marginWidth = 7;
            layout.horizontalSpacing = 7;
            layout.verticalSpacing = 7;
            return layout;
        }

        static GridLayout createSpaceGridLayout(int columns, int space) {
            GridLayout layout = new GridLayout(columns, false);
            layout.marginHeight = space;
            layout.marginWidth = space;
            layout.horizontalSpacing = space;
            layout.verticalSpacing = space;
            return layout;
        }

        static Control buildGridControl(Composite parent, Map propertiesMap, String elementName, String property, int hSpan, boolean grabSpace, IPropertyDescriptor descriptor, boolean hasLabel) {
            propertiesMap.put(property, descriptor);
            if (hasLabel) {
                Label label = new Label(parent, 0);
                label.setText(AbstractCategoryWrapper.getDisplayName(descriptor));
                if (label.getText().length() == 0 && descriptor instanceof PropertyDescriptorAdapter) {
                    ((PropertyDescriptorAdapter)descriptor).setDiplayNameLabel(label);
                }
            }
            Control control = descriptor.createControl(parent);
            GridData data = new GridData();
            data.horizontalSpan = hSpan;
            data.grabExcessHorizontalSpace = grabSpace;
            if (control instanceof Text) {
                data.widthHint = 80;
            }
            data.horizontalAlignment = 4;
            control.setLayoutData((Object)data);
            return control;
        }

        private static String getDisplayName(IPropertyDescriptor descriptor) {
            String name = null;
            PropertyProcessor processor = null;
            if (descriptor != null) {
                processor = descriptor.getPropertyProcessor();
            }
            if (processor != null) {
                name = processor.getDisplayName();
            }
            return name == null ? "" : name;
        }
    }
}

