/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui.dialogs.widget;

import org.eclipse.birt.chart.reportitem.ui.dialogs.widget.PropertyDescriptorAdapter;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.PropertyProcessor;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanPropertyDescriptor
extends PropertyDescriptorAdapter {
    protected Button button;

    public BooleanPropertyDescriptor(PropertyProcessor propertyProcessor) {
        super(propertyProcessor);
    }

    public void resetUIData() {
        boolean stateFlag;
        String value = this.getPropertyProcessor().getStringValue(this.getModelList());
        if (this.button.getText().length() == 0) {
            this.button.setText(this.getPropertyProcessor().getDisplayName(this.getModelList()));
        }
        boolean bl = stateFlag = value == null == this.button.getEnabled();
        if (stateFlag) {
            this.button.setEnabled(value != null);
        }
        boolean boolValue = "true".equalsIgnoreCase(value);
        if (this.button.getSelection() != boolValue) {
            this.button.setSelection(boolValue);
        }
    }

    public Control getControl() {
        return this.button;
    }

    public Control createControl(Composite parent) {
        this.button = new Button(parent, 32);
        this.button.setText(this.getDisplayName());
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BooleanPropertyDescriptor.this.processAction();
            }
        });
        return this.button;
    }

    private String getDisplayName() {
        String name = null;
        PropertyProcessor processor = this.getPropertyProcessor();
        if (processor != null) {
            name = processor.getDisplayName();
        }
        return name == null ? "" : name;
    }

    private void processAction() {
        String value = this.button.getSelection() ? "true" : "false";
        try {
            this.getPropertyProcessor().setStringValue(value, this.getModelList());
        }
        catch (SemanticException e) {
            this.handleError(e);
        }
    }
}

